// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Čeština';

  @override
  String s_translated(int percentage) {
    return 'Přeloženo: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Zkontrolováno: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Nedokončený překlad';

  @override
  String get p_translation_progress_desc =>
      'Ukazatele průběhu odrážejí zralost překladu.';

  @override
  String get s_save => 'Uložit';

  @override
  String get s_cancel => 'Zrušit';

  @override
  String get s_close => 'Zavřít';

  @override
  String get s_delete => 'Vymazat';

  @override
  String get s_move => 'Přesunout';

  @override
  String get s_quit => 'Ukončit';

  @override
  String get s_enable => 'Povolit';

  @override
  String get s_enabled => 'Povoleno';

  @override
  String get s_disabled => 'Zakázáno';

  @override
  String get s_status => 'Stav';

  @override
  String get s_unlock => 'Odemknout';

  @override
  String get s_calculate => 'Vypočítat';

  @override
  String get s_import => 'Importovat';

  @override
  String get s_overwrite => 'Přepsat';

  @override
  String get s_done => 'Hotovo';

  @override
  String get s_label => 'Jmenovka';

  @override
  String get s_name => 'Název';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Možnosti';

  @override
  String get s_details => 'Detaily';

  @override
  String get s_show_window => 'Zobrazit okno';

  @override
  String get s_hide_window => 'Skrýt okno';

  @override
  String get s_show_navigation => 'Zobrazit navigaci';

  @override
  String get s_expand_navigation => 'Rozbalit navigační panel';

  @override
  String get s_collapse_navigation => 'Skrýt navigační panel';

  @override
  String get s_expand_collapse_navigation => 'Rozbalit/skrýt navigační panel';

  @override
  String get s_show_menu => 'Zobrazit nabídku';

  @override
  String get s_toggle_menu_bar => 'Přepnout panel nabídky';

  @override
  String get s_more_info => 'Více informací';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'O aplikaci';

  @override
  String get s_algorithm => 'Algoritmus';

  @override
  String get s_appearance => 'Vzhled';

  @override
  String get s_actions => 'Akce';

  @override
  String get s_manage => 'Spravovat';

  @override
  String get s_setup => 'Nastavení';

  @override
  String get s_device => 'Zařízení';

  @override
  String get s_application => 'Aplikace';

  @override
  String get s_settings => 'Nastavení';

  @override
  String get l_settings_desc => 'Změnit předvolby aplikace';

  @override
  String get s_certificates => 'Certifikáty';

  @override
  String get s_security_key => 'Bezpečnostní klíč';

  @override
  String get s_slots => 'Sloty';

  @override
  String get s_help_and_about => 'Nápověda a informace';

  @override
  String get l_help_and_about_desc => 'Řešení problémů a podpora';

  @override
  String get s_help_and_feedback => 'Nápověda a zpětná vazba';

  @override
  String get s_home => 'Domov';

  @override
  String get s_user_guide => 'Uživatelská příručka';

  @override
  String get s_i_need_help => 'Potřebuji pomoc';

  @override
  String get s_troubleshooting => 'Řešení problémů';

  @override
  String get s_terms_of_use => 'Podmínky použití';

  @override
  String get s_privacy_policy => 'Zásady ochrany soukromí';

  @override
  String get s_open_src_licenses => 'Licence open source';

  @override
  String get s_please_wait => 'Počkejte prosím…';

  @override
  String get s_secret_key => 'Tajný klíč';

  @override
  String get s_show_secret_key => 'Zobrazit tajný klíč';

  @override
  String get s_hide_secret_key => 'Skrýt tajný klíč';

  @override
  String get s_private_key => 'Soukromý klíč';

  @override
  String get s_public_key => 'Veřejný klíč';

  @override
  String get s_invalid_length => 'Neplatná délka';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Neplatný formát, povolené znaky: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Neplatné znaky pro vybranou klávesnici';

  @override
  String get s_require_touch => 'Vyžadovat dotyk';

  @override
  String get q_have_account_info => 'Máte informace o účtu?';

  @override
  String get s_run_diagnostics => 'Spustit diagnostiku';

  @override
  String s_log_level(String level) {
    return 'Úroveň logu: $level';
  }

  @override
  String get s_character_count => 'Počet znaků';

  @override
  String get s_language => 'Jazyk';

  @override
  String p_community_translations_desc(String crowdin) {
    return 'Překlady jsou spravovány komunitou na $crowdin.';
  }

  @override
  String get s_choose_language => 'Vyberte jazyk';

  @override
  String get s_app_theme => 'Motiv aplikace';

  @override
  String get s_choose_app_theme => 'Vybrat motiv';

  @override
  String get s_system_default => 'Podle systému';

  @override
  String get s_light_mode => 'Světlý režim';

  @override
  String get s_dark_mode => 'Tmavý režim';

  @override
  String get s_list_layout => 'Zobrazit jako seznam';

  @override
  String get s_grid_layout => 'Zobrazit jako mřížku';

  @override
  String get s_mixed_layout => 'Smíšené zobrazení';

  @override
  String get s_select_layout => 'Vybrat zobrazení';

  @override
  String get s_select_to_scan => 'Vyberte pro skenování';

  @override
  String get s_hide_reader => 'Skrýt čtečku';

  @override
  String get s_show_hidden_readers => 'Zobrazit skryté čtečky';

  @override
  String get s_toggle_readers => 'Přepnout čtečky';

  @override
  String get l_toggle_readers_desc => 'Zobrazit nebo skrýt čtečky';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Sériové číslo: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Verze firmwaru: $version';
  }

  @override
  String get l_fips_capable => 'FIPS způsobilé';

  @override
  String get l_fips_approved => 'FIPS schváleno';

  @override
  String get l_insert_yk => 'Připojte svůj klíč YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Připojte nebo přiložte klíč YubiKey';

  @override
  String get l_unplug_yk => 'Odpojte YubiKey';

  @override
  String get l_reinsert_yk => 'Znovu připojte YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Položte YubiKey na NFC čtečku';

  @override
  String get l_replace_yk_on_reader => 'Položte YubiKey zpět na čtečku';

  @override
  String get l_remove_yk_from_reader => 'Odeberte YubiKey z NFC čtečky';

  @override
  String get p_try_reinsert_yk => 'Zkuste odpojit a znovu připojit YubiKey.';

  @override
  String get s_touch_required => 'Vyžaduje se dotyk';

  @override
  String get l_touch_button_now => 'Dotkněte se tlačítka na vašem YubiKey';

  @override
  String get l_keep_touching_yk => 'Opakovaně se dotkněte vašeho YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Nastavení aplikací';

  @override
  String get s_toggle_interfaces => 'Nastavení rozhraní';

  @override
  String get p_toggle_applications_desc => 'Povolit nebo zakázat aplikace.';

  @override
  String get p_toggle_interfaces_desc => 'Povolit nebo zakázat rozhraní USB.';

  @override
  String get l_toggle_applications_desc => 'Povolit/zakázat aplikace';

  @override
  String get l_toggle_interfaces_desc => 'Povolit/zakázat rozhraní';

  @override
  String get s_reconfiguring_yk => 'Probíhá konfigurace klíče YubiKey…';

  @override
  String get s_config_updated => 'Konfigurace aktualizována';

  @override
  String get l_config_updated_reinsert =>
      'Konfigurace byla aktualizována, odpojte a znovu připojte váš YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 aplikace zakázána';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn vyžaduje, aby byla aplikace FIDO2 povolena na vašem YubiKey';

  @override
  String get s_lock_code => 'Kód zámku';

  @override
  String get l_wrong_lock_code => 'Špatný kód zámku';

  @override
  String get s_show_lock_code => 'Zobrazit kód zámku';

  @override
  String get s_hide_lock_code => 'Skrýt kód zámku';

  @override
  String get p_lock_code_required_desc =>
      'Akce, kterou se chystáte provést, vyžaduje zadání kódu pro nastavení zámku.';

  @override
  String get l_helper_not_responding => 'Pomocný proces nereaguje';

  @override
  String get l_yk_no_access =>
      'K tomuto klíči YubiKey není možné získat přístup';

  @override
  String get s_yk_inaccessible => 'Nedostupné zařízení';

  @override
  String get l_open_connection_failed => 'Nepodařilo se otevřít připojení';

  @override
  String get l_ccid_connection_failed =>
      'Nepodařilo se otevřít připojení k čipové kartě';

  @override
  String get p_ccid_service_unavailable =>
      'Ujistěte se, že služba čipových karet je v spuštěna.';

  @override
  String get p_pcscd_unavailable =>
      'Ujistěte se, že je pcscd nainstalován a spuštěn.';

  @override
  String get l_no_yk_present => 'Žádný klíč YubiKey není připojen';

  @override
  String get s_unknown_type => 'Neznámý typ';

  @override
  String get s_unknown_device => 'Nerozpoznané zařízení';

  @override
  String get s_restricted_nfc => 'Aktivace NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Jak aktivovat NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Připojte svůj YubiKey k jakémukoli zdroji napájení USB, například počítači, po dobu nejméně 3 sekund.\n\nPo zapnutí bude NFC aktivováno a připraveno k použití.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Váš YubiKey má z důvodu ochrany proti bezdrátové manipulaci během přepravy omezenou funkci NFC. To znamená, že NFC operace jsou zakázány dokud je neaktivujete.';

  @override
  String get s_unsupported_yk => 'Nepodporovaný YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'Operace se nezdařila, zkuste to prosím znovu.';

  @override
  String get l_configuration_unsupported => 'Konfigurace není podporována';

  @override
  String get p_scp_unsupported =>
      'Pro komunikaci přes NFC vyžaduje YubiKey technologii, která není tímto telefonem podporována. Připojte YubiKey k USB portu telefonu.';

  @override
  String get l_error_occurred => 'Došlo k chybě';

  @override
  String get s_application_error => 'Chyba aplikace';

  @override
  String get l_import_error => 'Chyba importu';

  @override
  String get l_file_not_found => 'Soubor nebyl nalezen';

  @override
  String get l_file_too_big => 'Soubor je příliš velký';

  @override
  String get l_filesystem_error => 'Chyba při operaci souborového systému';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Nastavit PIN';

  @override
  String get s_change_pin => 'Změnit PIN';

  @override
  String get s_change_puk => 'Změnit PUK';

  @override
  String get s_show_pin => 'Zobrazit PIN';

  @override
  String get s_hide_pin => 'Skrýt PIN';

  @override
  String get s_show_puk => 'Zobrazit PUK';

  @override
  String get s_hide_puk => 'Skrýt PUK';

  @override
  String get s_current_pin => 'Aktuální PIN';

  @override
  String get s_current_puk => 'Aktuální PUK';

  @override
  String get s_new_pin => 'Nový PIN';

  @override
  String get s_new_puk => 'Nový PUK';

  @override
  String get s_confirm_pin => 'Potvrdit PIN';

  @override
  String get s_confirm_puk => 'Potvrdit PUK';

  @override
  String get s_unblock_pin => 'Resetovat PIN';

  @override
  String get l_pin_mismatch => 'Zadané PINy se neshodují';

  @override
  String get l_puk_mismatch => 'Zadané PUKy se neshodují';

  @override
  String get s_pin_set => 'PIN nastaven';

  @override
  String get s_puk_set => 'PUK nastaven';

  @override
  String l_set_pin_failed(String message) {
    return 'Nepodařilo se nastavit kód PIN: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Zbývá $retries pokusů',
      many: 'Zbývají $retries pokusy',
      one: 'Zbývá $retries pokus',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'zbývá $retries pokusů',
      few: 'zbývají $retries pokusy',
      one: 'zbývá $retries pokus',
    );
    return 'Nesprávný PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'zbývá $retries pokusů',
      few: 'zbývají $retries pokusy',
      one: 'zbývá $retries pokus',
    );
    return 'Nesprávný PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Ochrana kódem FIDO PIN';

  @override
  String get s_pin_change_required => 'Je vyžadována změna kódu PIN';

  @override
  String get l_enter_fido2_pin => 'Zadejte FIDO2 PIN pro váš YubiKey';

  @override
  String get l_pin_blocked_reset =>
      'PIN je zablokován; uveďte aplikaci FIDO do továrního nastavení';

  @override
  String get l_pin_blocked => 'PIN je zablokován';

  @override
  String get l_set_pin_first => 'Je vyžadován PIN';

  @override
  String get l_unlock_pin_first => 'Odemknout pomocí PIN';

  @override
  String get l_pin_soft_locked =>
      'PIN byl zablokován, dokud není YubiKey odpojen a znovu připojen';

  @override
  String get l_pin_change_required_desc =>
      'Před použitím této aplikace musí být nastaven nový PIN';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN musí být $min_length-$max_length znaků dlouhý a může obsahovat písmena, čísla a speciální znaky.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN musí být dlouhý $min_length-$max_length znaků, obsahuje alespoň $unique_characters jedinečných znaků a není běžně používaný kód PIN, jako je \"$common_pin\". Může obsahovat písmena, čísla a speciální znaky.';
  }

  @override
  String get s_ep_attestation => 'Ověření podniku';

  @override
  String get s_ep_attestation_enabled => 'Ověření podniku je povoleno';

  @override
  String get q_enable_ep_attestation => 'Povolit ověření podniku?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Tímto se povolí Ověření podniku umožňující autorizovaným doménám jedinečnou identifikaci vašeho YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Pokud je povoleno, Ověření podniku může být vypnuto pouze resetováním FIDO aplikace.';

  @override
  String get s_pin_required => 'Vyžadován PIN';

  @override
  String get p_pin_required_desc =>
      'Akce, kterou se chystáte provést, vyžaduje zadání kódu PIV PIN.';

  @override
  String get l_piv_pin_blocked => 'Zablokováno, pro obnovení použijte PUK';

  @override
  String get p_piv_pin_blocked_desc =>
      'PIN je zablokován. Použijte PUK pro jeho obnovení.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'PIN je zablokován. Je vyžadováno obnovení továrního nastavení.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Zablokováno, je potřeba obnovení továrních nastavení';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'PIN i PUK jsou zablokovány. Je potřeba resetovat aplikaci PIV.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name musí mít alespoň $length znaků.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name musí mít alespoň $length znaků, musí obsahovat alespoň 2 jedinečné znaky, a nesmí být běžně používaným $name, jako je \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Nový $name nesplňuje požadavky na složitost.';
  }

  @override
  String get s_dismiss => 'Zamítnout';

  @override
  String get p_default_pin_puk_key_desc =>
      'Doporučuje se změnit výchozí PIN, PUK a klíč správy.';

  @override
  String get l_warning_default_pin => 'Varování: používá se výchozí PIN';

  @override
  String get l_warning_default_puk => 'Varování: používá se výchozí PUK';

  @override
  String get l_default_pin_used => 'Byl použit výchozí PIN';

  @override
  String get l_default_puk_used => 'Byl použit výchozí PUK';

  @override
  String get l_pin_complexity => 'Složitost PIN je vynucena';

  @override
  String get s_password => 'Heslo';

  @override
  String get s_manage_password => 'Spravovat heslo';

  @override
  String get s_set_password => 'Nastavit heslo';

  @override
  String get s_password_set => 'Heslo nastaveno';

  @override
  String get s_show_password => 'Zobrazit heslo';

  @override
  String get s_hide_password => 'Skrýt heslo';

  @override
  String get l_password_protection => 'Ochrana účtů heslem';

  @override
  String get s_new_password => 'Nové heslo';

  @override
  String get s_current_password => 'Aktuální heslo';

  @override
  String get s_confirm_password => 'Potvrdit heslo';

  @override
  String get l_password_mismatch => 'Hesla se neshodují';

  @override
  String get s_wrong_password => 'Chybné heslo';

  @override
  String get p_wrong_password =>
      'Chybné heslo. Pokud neznáte své heslo, musíte obnovit YubiKey.';

  @override
  String get s_remove_password => 'Odstranit heslo';

  @override
  String get s_password_removed => 'Heslo odstraněno';

  @override
  String get s_remember_password => 'Zapamatovat heslo';

  @override
  String get s_clear_saved_password => 'Vymazat zapamatované heslo';

  @override
  String get s_password_forgotten => 'Zapamatované heslo bylo vymazáno';

  @override
  String get l_keystore_unavailable => 'Úložiště klíčů OS není k dispozici';

  @override
  String get l_remember_pw_failed => 'Nepodařilo se zapamatovat heslo';

  @override
  String get l_unlock_first => 'Odemknout pomocí hesla';

  @override
  String get l_set_password_first => 'Nastavit heslo';

  @override
  String get l_enter_oath_pw => 'Zadejte OATH heslo pro váš YubiKey';

  @override
  String get p_new_password_requirements =>
      'Heslo může obsahovat písmena, čísla a speciální znaky.';

  @override
  String get s_management_key => 'Klíč správy';

  @override
  String get s_current_management_key => 'Aktuální klíč správy';

  @override
  String get s_new_management_key => 'Nový klíč správy';

  @override
  String get l_change_management_key => 'Změnit klíč správy';

  @override
  String get l_management_key_changed => 'Klíč správy změněn';

  @override
  String get l_default_key_used => 'Používá se výchozí klíč správy';

  @override
  String get s_generate_random => 'Vytvořit náhodný';

  @override
  String get s_use_default => 'Použít výchozí';

  @override
  String get l_warning_default_key => 'Varování: používá se výchozí klíč';

  @override
  String get s_protect_key => 'Chránit pomocí PIN';

  @override
  String get p_protect_key_desc =>
      'Použijte PIN místo klíče správy během operací, které vyžadují ověření klíčem správy.';

  @override
  String get s_management_key_algorithm => 'Algoritmus klíče správy';

  @override
  String get p_management_key_algorithm_desc =>
      'Algoritmus, který má být vybrán pro klíč správy.';

  @override
  String get l_pin_protected_key => 'Je možno použít PIN';

  @override
  String get l_wrong_key => 'Špatný klíč';

  @override
  String get l_unlock_piv_management => 'Odemknout správu PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'Akce, kterou se chystáte provést, vyžaduje klíč správy pro PIV.';

  @override
  String l_account(String label) {
    return 'Účet: $label';
  }

  @override
  String get s_accounts => 'Účty';

  @override
  String get s_no_accounts => 'Žádné účty';

  @override
  String l_results_for(String query) {
    return 'Výsledky pro \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Začněte s OTP účty';

  @override
  String get l_no_accounts_desc =>
      'Přidejte si do vašeho YubiKey účty od jakéhokoli poskytovatele služeb podporujícího OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Přidat účet';

  @override
  String get p_add_account_desc =>
      'Naskenujte QR kód nebo zadejte přihlašovací údaje ručně.';

  @override
  String get s_add_accounts => 'Přidat účet(-y)';

  @override
  String get l_drop_qr_description => 'Přetáhněte QR kód pro přidání účtu(-ů)';

  @override
  String get p_add_account_three_ways =>
      'Existují tři způsoby, jak přidat účty.';

  @override
  String get s_scanning => 'Skenování (doporučeno)';

  @override
  String get p_scanning_desc =>
      'Před skenováním QR kódu se ujistěte, že je celý kód viditelný na obrazovce.';

  @override
  String get s_drag_and_drop => 'Přetažení';

  @override
  String get p_drag_and_drop_desc =>
      'Obrázek obsahující QR kód může být upuštěn kdekoli v zobrazení účtu.';

  @override
  String get s_manually => 'Ručně';

  @override
  String get p_manually_desc =>
      'Údaje o účtu mohou být zadány ručně ve formuláři.';

  @override
  String get s_account_added => 'Účet přidán';

  @override
  String l_account_add_failed(String message) {
    return 'Přidání účtu se nezdařilo: $message';
  }

  @override
  String get l_add_account_password_required => 'Je vyžadováno heslo';

  @override
  String get l_add_account_unlock_required => 'Vyžadováno odemknutí';

  @override
  String get l_add_account_already_exists => 'Účet již existuje';

  @override
  String get l_add_account_func_missing => 'Chybějící nebo deaktivovaná funkce';

  @override
  String get l_account_name_required => 'Váš účet musí mít jméno';

  @override
  String get l_name_already_exists => 'Toto jméno již pro vydavatele existuje';

  @override
  String get l_account_already_exists => 'Tento účet již na YubiKey existuje';

  @override
  String get l_invalid_character_issuer =>
      'Neplatný znak: \':\' není u vydavatele povoleno';

  @override
  String get l_select_accounts =>
      'Vyberte účet(-y), který chcete přidat na YubiKey';

  @override
  String get s_pin_account => 'Připnout účet';

  @override
  String get s_unpin_account => 'Odepnout účet';

  @override
  String get s_no_pinned_accounts => 'Žádné připnuté účty';

  @override
  String get s_pinned => 'Připnuté';

  @override
  String get l_pin_account_desc => 'Mějte své důležité účty pohromadě';

  @override
  String get s_rename_account => 'Přejmenovat účet';

  @override
  String get l_rename_account_desc => 'Upravit vydavatele/jméno účtu';

  @override
  String get s_account_renamed => 'Účet přejmenován';

  @override
  String l_rename_account_failed(String message) {
    return 'Nepodařilo se přejmenovat účet: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Tímto se změní způsob zobrazení účtu v seznamu.';

  @override
  String get s_delete_account => 'Odstranit účet';

  @override
  String get q_delete_account => 'Odstranit účet?';

  @override
  String get l_delete_account_desc => 'Odebrat účet z YubiKey';

  @override
  String get s_account_deleted => 'Účet odstraněn';

  @override
  String get p_warning_delete_account =>
      'Varování! Tato akce odstraní účet z vašeho YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Ujistěte se, že jste zakázali tento účet ze služby, se kterou je registrován, abyste se vyhnuli zablokování.';

  @override
  String get s_account_name => 'Název účtu';

  @override
  String get s_search_accounts => 'Hledat účty';

  @override
  String l_accounts_used(int used, int capacity) {
    return 'Použito $used z $capacity účtů';
  }

  @override
  String s_num_digits(int num) {
    return '$num číslic';
  }

  @override
  String s_num_sec(int num) {
    return '$num sek';
  }

  @override
  String get s_issuer_optional => 'Vydavatel (nepovinné)';

  @override
  String get s_counter_based => 'Založeno na počítadle';

  @override
  String get s_time_based => 'Založeno na čase';

  @override
  String get l_copy_code_desc => 'Vložte kód do jiné aplikace';

  @override
  String get l_calculate_code_desc => 'Získejte nový kód z vašeho YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'ID uživatele';

  @override
  String get s_credential_id => 'ID pověření';

  @override
  String get s_display_name => 'Zobrazované jméno';

  @override
  String get s_user_name => 'Uživatelské jméno';

  @override
  String get s_passkeys => 'Přístupové klíče';

  @override
  String get s_no_passkeys => 'Žádné přístupové klíče';

  @override
  String get l_ready_to_use => 'Připraveno k použití';

  @override
  String get l_register_sk_on_websites =>
      'Registrovat jako bezpečnostní klíč na webových stránkách';

  @override
  String get l_no_discoverable_accounts =>
      'Nejsou uloženy žádné přístupové klíče';

  @override
  String get p_non_passkeys_note =>
      'Registrovaná pověření bez přístupového klíče nelze zobrazit.';

  @override
  String get s_delete_passkey => 'Odstranit přístupový klíč';

  @override
  String get q_delete_passkey => 'Odstranit přístupový klíč?';

  @override
  String get l_delete_passkey_desc => 'Odstranit přístupový klíč z YubiKey';

  @override
  String get s_passkey_deleted => 'Přístupový klíč smazán';

  @override
  String get p_warning_delete_passkey =>
      'Varování! Tato akce odstraní přístupový klíč z YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Již nebudete moci používat tento přístupový klíč pro službu, kde je registrován.';

  @override
  String get s_search_passkeys => 'Hledat přístupové klíče';

  @override
  String p_passkeys_used(int used, int max) {
    return 'Použito $used z $max přístupových klíčů.';
  }

  @override
  String get s_biometrics => 'Biometrie';

  @override
  String l_fingerprint(String label) {
    return 'Otisk prstu: $label';
  }

  @override
  String get s_fingerprints => 'Otisky prstů';

  @override
  String get l_fingerprint_captured => 'Otisk prstu úspěšně zachycen!';

  @override
  String get s_fingerprint_added => 'Otisk prstu přidán';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Chyba při přidávání otisku prstu: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Chyba při nastavování názvu: $message';
  }

  @override
  String get s_setup_fingerprints => 'Nastavit otisky prstů';

  @override
  String get p_setup_fingerprints_desc =>
      'Před použitím klíče je třeba nastavit otisky prstů.';

  @override
  String get s_add_fingerprint => 'Přidat otisk prstu';

  @override
  String get s_delete_fingerprint => 'Odstranit otisk prstu';

  @override
  String get q_delete_fingerprint => 'Smazat otisk prstu?';

  @override
  String get l_delete_fingerprint_desc => 'Odstranit otisk prstu z YubiKey';

  @override
  String get s_fingerprint_deleted => 'Otisk prstu odstraněn';

  @override
  String get p_warning_delete_fingerprint =>
      'Tímto odstraníte otisk prstu z vašeho YubiKey.';

  @override
  String get s_fingerprints_get_started => 'Začínáme s otisky prstů';

  @override
  String get p_set_fingerprints_desc =>
      'Než bude možné zaregistrovat otisky prstů, musí být nastaven PIN kód.';

  @override
  String get l_no_fps_added => 'Nebyly přidány žádné otisky prstů';

  @override
  String get s_rename_fp => 'Přejmenovat otisk prstu';

  @override
  String get l_rename_fp_desc => 'Změnit název';

  @override
  String get s_fingerprint_renamed => 'Otisk prstu přejmenován';

  @override
  String l_rename_fp_failed(String message) {
    return 'Chyba při přejmenování: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Přidat jeden nebo více (až pět) otisků prstů';

  @override
  String l_fingerprints_used(int used) {
    return 'Registrováno $used z 5 otisků prstů';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Pro začátek přiložte prst k YubiKey.';

  @override
  String get l_name_fingerprint => 'Pojmenujte tento otisk prstu';

  @override
  String get l_user_action_timeout_error =>
      'Selhalo z důvodu nečinnosti uživatele';

  @override
  String get l_wrong_inserted_yk_error =>
      'Znovu vložený YubiKey neodpovídá počátečnímu zařízení';

  @override
  String get l_failed_connecting_to_fido =>
      'Připojení k FIDO rozhraní se nezdařilo';

  @override
  String get l_self_signed_certificate => 'Certifikát s vlastním podpisem';

  @override
  String get l_certificate_signing_request =>
      'Žádost o podpis certifikátu (CSR)';

  @override
  String get s_certificate => 'Certifikát';

  @override
  String get s_subject => 'Předmět';

  @override
  String get l_export_csr_file => 'Uložit CSR do souboru';

  @override
  String get l_export_public_key => 'Exportovat veřejný klíč';

  @override
  String get l_export_public_key_file => 'Uložit veřejný klíč do souboru';

  @override
  String get l_export_public_key_desc => 'Exportovat veřejný klíč do souboru';

  @override
  String get l_public_key_exported => 'Veřejný klíč exportován';

  @override
  String get l_export_certificate => 'Exportovat certifikát';

  @override
  String get l_export_certificate_file => 'Exportovat certifikát do souboru';

  @override
  String get l_export_certificate_desc => 'Exportovat certifikát do souboru';

  @override
  String get l_certificate_exported => 'Certifikát exportován';

  @override
  String get l_select_import_file => 'Vyberte soubor k importu';

  @override
  String get l_import_file => 'Importovat soubor';

  @override
  String get l_import_desc => 'Importovat klíč a/nebo certifikát';

  @override
  String get l_import_nothing => 'Nic k importu';

  @override
  String get l_importing_file => 'Importuji soubor…';

  @override
  String get s_file_imported => 'Soubor importován';

  @override
  String get l_unsupported_key_type => 'Nepodporovaný typ klíče';

  @override
  String get l_delete_certificate => 'Odstranit certifikát';

  @override
  String get q_delete_certificate => 'Odstranit certifikát?';

  @override
  String get l_delete_certificate_desc => 'Odebrat certifikát z YubiKey';

  @override
  String get l_delete_key => 'Odstranit klíč';

  @override
  String get q_delete_key => 'Odstranit klíč?';

  @override
  String get l_delete_key_desc => 'Odebrat klíč z YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Odstranit certifikát/klíč';

  @override
  String get q_delete_certificate_or_key => 'Odstranit certifikát/klíč?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Odstranit certifikát nebo klíč z YubiKey';

  @override
  String get l_move_key => 'Přesunout klíč';

  @override
  String get l_move_key_desc => 'Přesunout klíč z jednoho PIV slotu do jiného';

  @override
  String get l_change_defaults => 'Změnit výchozí přístupové kódy';

  @override
  String get s_issuer => 'Vydavatel';

  @override
  String get s_serial => 'Sériové číslo';

  @override
  String get s_certificate_fingerprint => 'Otisk prstu';

  @override
  String get s_valid_from => 'Platné od';

  @override
  String get s_valid_to => 'Platné do';

  @override
  String get l_no_certificate => 'Není načten žádný certifikát';

  @override
  String get l_key_no_certificate => 'Klíč bez certifikátu';

  @override
  String get s_generate_key => 'Generovat klíč';

  @override
  String get l_generate_desc => 'Vygenerovat nový certifikát nebo CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Toto vygeneruje nový klíč na YubiKey v PIV slotu $slot.';
  }

  @override
  String get s_private_key_generated => 'Vygenerován soukromý klíč';

  @override
  String get p_select_what_to_delete =>
      'Vyberte, co chcete odstranit ze slotu.';

  @override
  String get p_warning_delete_certificate =>
      'Varování! Tato akce odstraní certifikát z vašeho YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Varování! Tato akce odstraní soukromý klíč z vašeho YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Varování! Tato akce odstraní certifikát a soukromý klíč z vašeho YubiKey.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Tímto odstraníte certifikát v PIV slotu $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Tímto odstraníte soukromý klíč v PIV slotu $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Tímto odstraníte certifikát a soukromý klíč v PIV slotu $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certifikát byl odstraněn';

  @override
  String get l_key_deleted => 'Klíč byl odstraněn';

  @override
  String get l_certificate_and_key_deleted =>
      'Certifikát a klíč byly odstraněny';

  @override
  String get l_include_certificate => 'Včetně certifikátu';

  @override
  String get l_select_destination_slot => 'Vyberte cílový slot';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Přesunout soukromý klíč v PIV slotu $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Přesunout soukromý klíč v PIV slotu $from_slot do slotu $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Přesunout soukromý klíč a certifikát v PIV slotu $from_slot do slotu $to_slot?';
  }

  @override
  String get p_password_protected_file => 'Vybraný soubor je chráněn heslem.';

  @override
  String p_import_items_desc(String slot) {
    return 'Následující položka(y) budou importovány do PIV slotu $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Veřejný klíč certifikátu se neshoduje se soukromým klíčem ve slotu';

  @override
  String get l_key_moved => 'Klíč přesunut';

  @override
  String get l_key_and_certificate_moved => 'Klíč a certifikát byly přesunuty';

  @override
  String get p_subject_desc =>
      'Rozlišovaný název (DN) ve formátu podle specifikace RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Neplatný formát RFC 4514';

  @override
  String get rfc4514_examples =>
      'Příklady:\nCN=Příklad jména\nCN=jsmith,DC=příklad,DC=net';

  @override
  String get s_allow_fingerprint => 'Povolit otisk prstu';

  @override
  String get s_pin_policy => 'Zásady PIN';

  @override
  String get s_output_format => 'Výstupní formát';

  @override
  String get s_expiration_date => 'Datum expirace';

  @override
  String get p_algorithm_desc => 'Použít algoritmus klíče.';

  @override
  String get p_expiration_date_desc =>
      'Datum vypršení platnosti certifikátu, standardně 1 rok (pouze certifikát).';

  @override
  String get p_key_options_bio_desc =>
      'Povolit použití biometrie namísto kódu PIN.';

  @override
  String get q_overwrite_slot => 'Přepsat slot?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Toto trvale přepíše existující obsah ve slotu $slot.';
  }

  @override
  String get l_overwrite_cert => 'Certifikát bude přepsán';

  @override
  String get l_overwrite_key => 'Soukromý klíč bude přepsán';

  @override
  String get l_overwrite_key_maybe =>
      'Jakýkoliv existující soukromý klíč v slotu bude přepsán';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Ověření';

  @override
  String get s_slot_9c => 'Digitální podpis';

  @override
  String get s_slot_9d => 'Správa klíčů';

  @override
  String get s_slot_9e => 'Ověření karty';

  @override
  String get s_retired_slot => 'Zrušená správa klíčů';

  @override
  String get s_otp_slot_one => 'Krátký dotyk';

  @override
  String get s_otp_slot_two => 'Dlouhý dotyk';

  @override
  String get l_otp_slot_empty => 'Slot je prázdný';

  @override
  String get l_otp_slot_configured => 'Slot je konfigurován';

  @override
  String get l_yubiotp_desc => 'Program OTP pověření Yubico';

  @override
  String get s_challenge_response => 'Odpověď na výzvu';

  @override
  String get l_challenge_response_desc =>
      'Naprogramujte pověření odpovědi na výzvu';

  @override
  String get s_static_password => 'Statické heslo';

  @override
  String get l_static_password_desc => 'Konfigurace statického hesla';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Program důvěryhodnosti založené na HMAC-SHA1';

  @override
  String get s_public_id => 'Veřejné ID';

  @override
  String get s_private_id => 'Soukromé ID';

  @override
  String get s_use_serial => 'Použít sériové číslo';

  @override
  String get l_select_file => 'Vybrat soubor';

  @override
  String get l_no_export_file => 'Žádný exportovaný soubor';

  @override
  String get s_no_export => 'Žádný export';

  @override
  String get s_export => 'Exportovat';

  @override
  String get l_export_configuration_file => 'Exportovat konfiguraci do souboru';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Exportované přihlašovací údaje mohou být nahrány na $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Klávesnice $layout';
  }

  @override
  String get s_delete_slot => 'Odstranit pověření';

  @override
  String get q_delete_slot => 'Smazat pověření?';

  @override
  String get l_delete_slot_desc => 'Odstranit pověření ve slotu';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Varování! Tato akce trvale odstraní pověření ze slotu $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Pověření smazáno';

  @override
  String get s_swap => 'Prohodit';

  @override
  String get s_swap_slots => 'Prohodit sloty';

  @override
  String get q_swap_slots => 'Prohodit sloty?';

  @override
  String get l_swap_slots_desc => 'Prohodit krátký a dlouhý dotyk';

  @override
  String get p_swap_slots_desc => 'Tímto se vymění konfigurace slotů.';

  @override
  String get l_slots_swapped => 'Konfigurace slotů vyměněny';

  @override
  String l_slot_credential_configured(String type) {
    return 'Konfigurováno pověření $type';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Konfigurováno pověření $type a exportováno do $file';
  }

  @override
  String get s_append_enter => 'Připojit ⏎';

  @override
  String get l_append_enter_desc => 'Připojit Enter po emitování OTP';

  @override
  String get p_otp_swap_error =>
      'Nepodařilo se vyměnit sloty! Ujistěte se, že YubiKey nemá omezující přístup.';

  @override
  String get l_wrong_access_code => 'Špatný přístupový kód';

  @override
  String get s_access_code => 'Přístupový kód';

  @override
  String get s_show_access_code => 'Zobrazit přístupový kód';

  @override
  String get s_hide_access_code => 'Skrýt přístupový kód';

  @override
  String p_enter_access_code(String slot) {
    return 'Zadejte přístupový kód pro slot $slot.';
  }

  @override
  String get s_enable_nfc => 'Povolit NFC';

  @override
  String get s_request_access => 'Žádost o přístup';

  @override
  String get s_permission_denied => 'Oprávnění odepřeno';

  @override
  String get l_elevating_permissions => 'Povýšení oprávnění…';

  @override
  String get s_review_permissions => 'Zkontrolovat oprávnění';

  @override
  String get s_open_windows_settings => 'Otevřít nastavení Windows';

  @override
  String get l_admin_privileges_required =>
      'Vyžadována oprávnění administrátora';

  @override
  String get p_elevated_permissions_required =>
      'Správa tohoto zařízení vyžaduje zvýšená oprávnění. Můžete také použít nastavení Windows pro správu konfigurace FIDO.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'Správa WebAuthn vyžaduje zvýšená oprávnění, případně můžete použít nastavení Windows pro správu konfigurace FIDO.';

  @override
  String get l_ms_store_permission_note =>
      'Verze aplikace z Microsoft Store nemusí být schopna povýšit oprávnění';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator potřebuje oprávnění kamery pro skenování QR kódů.';

  @override
  String get s_qr_scan => 'Skenování kódu QR';

  @override
  String get l_invalid_qr => 'Neplatný QR kód';

  @override
  String get l_qr_not_found => 'Nenalezen žádný QR kód';

  @override
  String get l_qr_scanned => 'Naskenovaný QR kód';

  @override
  String l_qr_file_too_large(String max) {
    return 'Soubor je příliš velký (max $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Neplatný obrázek';

  @override
  String get l_qr_select_file => 'Vyberte soubor s QR kódem';

  @override
  String l_qr_not_read(String message) {
    return 'Nepodařilo se načíst QR kód: $message';
  }

  @override
  String get l_point_camera_scan => 'Namiřte kameru na QR kód pro naskenování';

  @override
  String get q_want_to_scan => 'Chcete skenovat?';

  @override
  String get q_no_qr => 'Nemáte QR kód?';

  @override
  String get s_enter_manually => 'Zadejte ručně';

  @override
  String get s_read_from_file => 'Číst ze souboru';

  @override
  String get s_reset => 'Reset';

  @override
  String get s_factory_reset => 'Obnovení továrního nastavení';

  @override
  String get l_factory_reset_desc => 'Obnovit výchozí nastavení YubiKey';

  @override
  String get l_factory_reset_required =>
      'Vyžadováno obnovení továrního nastavení';

  @override
  String get l_oath_application_reset => 'Reset aplikace OATH';

  @override
  String get l_fido_app_reset => 'Reset aplikace FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Chyba při provádění reset: $message';
  }

  @override
  String get l_piv_app_reset => 'Reset aplikace PIV';

  @override
  String get p_factory_reset_an_app =>
      'Tovární obnovení aplikace na vašem YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Data jsou uložena ve více aplikacích na YubiKey, z nichž některé mohou být resetovány do továrního nastavení nezávisle na sobě.\n\nPro resetování vyberte aplikaci výše.';

  @override
  String get p_warning_factory_reset =>
      'Varování! Neodvolatelně smažete všechny OATH TOTP/HOTP účty z vašeho YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Vaše OATH přihlašovací údaje, stejně jako veškerá nastavení hesel, budou odstraněny z tohoto YubiKey. Ujistěte se, že jste je odstranili z příslušných webových stránek, abyste se vyhnuli zablokování vašich účtů.';

  @override
  String get p_warning_deletes_accounts =>
      'Varování! Neodvolatelně smažete z vašeho YubiKey všechny účty U2F a FIDO2 včetně přístupových klíčů.';

  @override
  String get p_warning_disable_accounts =>
      'Vaše přihlašovací údaje  včetně kódu PIN, budou odstraněny z tohoto YubiKey. Ujistěte se, že jste je odstranili z příslušných webových stránek, abyste se vyhnuli zablokování vašich účtů.';

  @override
  String get p_warning_piv_reset =>
      'Varování! Všechna data uložená pro PIV budou neodvolatelně smazána z vašeho YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'To zahrnuje soukromé klíče a certifikáty. Váš PIN, PUK, a klíč správy bude resetován na jejich výchozí tovární hodnoty.';

  @override
  String get p_warning_global_reset =>
      'Varování! Tímto se neodvolatelně smažou všechna uložená data, včetně přihlašovacích údajů, z vašeho YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Tovární resetování aplikací na vašem YubiKey. PIN bude resetován na tovární výchozí hodnotu a registrované otisky prstů budou odstraněny. Všechny klíče, certifikáty nebo jiné přihlašovací údaje budou trvale odstraněny.';

  @override
  String get l_copy_to_clipboard => 'Kopírovat do schránky';

  @override
  String get s_code_copied => 'Kód zkopírován';

  @override
  String get l_code_copied_clipboard => 'Kód zkopírován do schránky';

  @override
  String get s_copy_log => 'Kopírovat log';

  @override
  String get l_log_copied => 'Log zkopírován do schránky';

  @override
  String get l_diagnostics_copied =>
      'Diagnostická data zkopírována do schránky';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label zkopírován do schránky.';
  }

  @override
  String get s_custom_icons => 'Ikony účtů';

  @override
  String get l_set_icons_for_accounts => 'Nastavit ikony účtů';

  @override
  String get p_custom_icons_description =>
      'Balíčky ikon pomohou snáze rozpoznat vaše účty s dobře známými logy a barvami.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Balíčky ikon používají formát $aegis_icon_pack. Předem vytvořený balíček ikon můžete stáhnout, nebo si můžete vytvořit vlastní.';
  }

  @override
  String get s_replace_icon_pack => 'Nahradit balíček ikon';

  @override
  String get l_loading_icon_pack => 'Načítání balíčku ikon…';

  @override
  String get s_load_icon_pack => 'Načíst balíček ikon';

  @override
  String get s_remove_icon_pack => 'Odstranit balíček ikon';

  @override
  String get l_icon_pack_removed => 'Balíček ikon odstraněn';

  @override
  String get l_remove_icon_pack_failed => 'Chyba při odstraňování balíčku ikon';

  @override
  String get s_choose_icon_pack => 'Vybrat balíček ikon';

  @override
  String get l_icon_pack_imported => 'Balíček ikon importován';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Chyba při importu balíčku ikon: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Neplatný balíček ikon';

  @override
  String get l_icon_pack_copy_failed =>
      'Nepodařilo se zkopírovat soubory balíčku ikon';

  @override
  String get s_nfc_options => 'Možnosti NFC';

  @override
  String get l_on_yk_nfc_tap => 'Při přiložení YubiKey';

  @override
  String get l_do_nothing => 'Nedělat nic';

  @override
  String get l_launch_ya => 'Spustit Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Kopírovat OTP do schránky';

  @override
  String get l_launch_and_copy_otp =>
      'Spustit aplikaci a zkopírovat OTP do schránky';

  @override
  String get l_kbd_layout_for_static =>
      'Rozložení klávesnice (pro statické heslo)';

  @override
  String get s_choose_kbd_layout => 'Vybrat rozložení klávesnice';

  @override
  String get l_bypass_touch_requirement => 'Obejít požadavek dotyku';

  @override
  String get l_bypass_touch_requirement_on =>
      'Účty, které vyžadují dotyk, se automaticky zobrazují přes NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Účty, které vyžadují dotyk, vyžadují další přiložení YubiKey NFC';

  @override
  String get s_silence_nfc_sounds => 'Tichý zvuk NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'Při přiložení nebudou přehrány žádné zvuky';

  @override
  String get l_silence_nfc_sounds_off => 'Při přiložení bude přehrán zvuk';

  @override
  String get s_usb_options => 'Možnosti USB';

  @override
  String get l_launch_app_on_usb => 'Spustit při připojení YubiKey';

  @override
  String get l_launch_app_on_usb_on =>
      'Zabraňuje ostatním aplikacím používat YubiKey přes USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Ostatní aplikace mohou používat YubiKey přes USB';

  @override
  String get s_allow_screenshots => 'Povolit snímky obrazovky';

  @override
  String get s_nfc_ready_to_scan => 'Připraveno ke skenování';

  @override
  String get s_nfc_hold_still => 'Neodstraňujte YubiKey…';

  @override
  String get s_nfc_tap_your_yubikey => 'Přiložte YubiKey';

  @override
  String get l_nfc_failed_to_scan =>
      'Nepodařilo se naskenovat, zkuste to znovu';

  @override
  String get s_usb_processing => 'Čtení dat z YubiKey';

  @override
  String get s_usb_dont_remove => 'Neodstraňovat klíč…';

  @override
  String get l_usb_read_error => 'Nepodařilo se načíst data z YubiKey';

  @override
  String get p_ndef_set_otp =>
      'OTP kód z YubiKey byl úspěšně zkopírován do schránky.';

  @override
  String get p_ndef_set_password =>
      'Heslo z YubiKey bylo úspěšně zkopírováno do schránky.';

  @override
  String get p_ndef_parse_failure =>
      'Nepodařilo se zpracovat OTP kód z YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Přístup ke schránce se nezdařil při kopírování OTP kódu z YubiKey.';

  @override
  String get s_set_label => 'Nastavit jmenovku';

  @override
  String get s_set_color => 'Nastavit barvu';

  @override
  String get s_change_label => 'Změnit jmenovku';

  @override
  String get p_set_will_add_custom_name =>
      'Tímto nastavíte jmenovku vašeho YubiKey.';

  @override
  String get p_rename_will_change_custom_name =>
      'Tímto změníte jmenovku vašeho YubiKey.';

  @override
  String get s_shortcuts => 'Zkratky';

  @override
  String get s_keyboard_shortcuts => 'Klávesové zkratky';

  @override
  String get s_global_shortcuts => 'Globální klávesové zkratky';

  @override
  String get s_application_shortcuts => 'Klávesové zkratky aplikace';

  @override
  String s_quit_app(String app) {
    return 'Ukončit $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Skrýt $app';
  }

  @override
  String get s_search => 'Vyhledávání';

  @override
  String get s_next_device => 'Další zařízení';

  @override
  String get s_previous_device => 'Předchozí zařízení';

  @override
  String get s_open_settings => 'Otevřít nastavení';

  @override
  String get s_open_help_and_about => 'Otevřít nápovědu a informace';

  @override
  String get s_open_item => 'Otevřít položku';

  @override
  String get s_edit_item => 'Upravit položku';

  @override
  String get s_delete_item => 'Smazat položku';

  @override
  String get s_calculate_oath_code => 'Vypočítat kód OATH';

  @override
  String get s_open_keyboard_shortcuts => 'Zobrazit klávesové zkratky';
}
