/*
 * Copyright (C) 2022-2025 Yubico.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:material_symbols_icons/symbols.dart';

import '../../app/message.dart';
import '../../app/models.dart';
import '../../app/state.dart';
import '../../generated/l10n/app_localizations.dart';
import '../../widgets/basic_dialog.dart';
import '../models.dart';
import '../state.dart';

class DeleteFingerprintDialog extends ConsumerWidget {
  final DevicePath devicePath;
  final Fingerprint fingerprint;

  const DeleteFingerprintDialog(this.devicePath, this.fingerprint, {super.key});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final l10n = AppLocalizations.of(context);

    return BasicDialog(
      icon: Icon(Symbols.delete),
      title: Text(l10n.q_delete_fingerprint),
      actions: [
        TextButton(
          onPressed: () async {
            await ref
                .read(fingerprintProvider(devicePath).notifier)
                .deleteFingerprint(fingerprint);
            await ref.read(withContextProvider)((context) async {
              Navigator.of(context).pop(true);
              showMessage(context, l10n.s_fingerprint_deleted);
            });
          },
          child: Text(l10n.s_delete),
        ),
      ],
      content: Text(l10n.p_warning_delete_fingerprint),
    );
  }
}
