/*
 * Copyright (C) 2025 Yubico.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yubico.authenticator

import com.yubico.authenticator.device.DeviceManager
import com.yubico.yubikit.core.YubiKeyDevice
import org.slf4j.LoggerFactory

class HomeContextManager(deviceManager: DeviceManager) : AppContextManager(deviceManager) {

    init {
        logger.debug("HomeContextManager initialized")
    }

    override fun supports(appContext: OperationContext): Boolean =
        appContext == OperationContext.Home

    override fun activate() {
        super.activate()
        logger.debug("HomeContextManager activated")
    }

    override fun deactivate() {
        logger.debug("HomeContextManager deactivated")
        super.deactivate()
    }

    override suspend fun processYubiKey(device: YubiKeyDevice): Boolean {
        return true
    }

    override fun hasPending(): Boolean {
        return false
    }

    companion object {
        private val logger = LoggerFactory.getLogger(HomeContextManager::class.java)
    }
}