// Copyright (c) 2020-2025, tim maffett.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// BEGIN GENERATED CODE - DO NOT MODIFY BY HAND - generating code => /tool/makeX11EntryPoints.dart
import 'chalk.dart';
import 'chalk_x11.g.dart';

/// This extension class adds proper methods to Chalk for all of the
/// standard X11/CSS/SVG color names for use by Chalk.
extension ChalkX11Strings on String {
  static final Chalk _chalk = Chalk();

  /// set foreground color to X11/CSS color aliceBlue ![aliceblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,248,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0F8FF)/rgb(240, 248, 255)
  String get aliceBlue => _chalk.aliceBlue(this);

  /// set background color to X11/CSS color aliceBlue ![aliceblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,248,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0F8FF)/rgb(240, 248, 255)
  String get onAliceBlue => _chalk.onAliceBlue(this);

  /// set foreground color to X11/CSS color antiqueWhite ![antiquewhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,235,215%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAEBD7)/rgb(250, 235, 215)
  String get antiqueWhite => _chalk.antiqueWhite(this);

  /// set background color to X11/CSS color antiqueWhite ![antiquewhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,235,215%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAEBD7)/rgb(250, 235, 215)
  String get onAntiqueWhite => _chalk.onAntiqueWhite(this);

  /// set foreground color to X11/CSS color aqua ![aqua](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FFFF)/rgb(0, 255, 255)
  String get aqua => _chalk.aqua(this);

  /// set background color to X11/CSS color aqua ![aqua](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FFFF)/rgb(0, 255, 255)
  String get onAqua => _chalk.onAqua(this);

  /// set foreground color to X11/CSS color aquamarine ![aquamarine](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28127,255,212%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7FFFD4)/rgb(127, 255, 212)
  String get aquamarine => _chalk.aquamarine(this);

  /// set background color to X11/CSS color aquamarine ![aquamarine](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28127,255,212%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7FFFD4)/rgb(127, 255, 212)
  String get onAquamarine => _chalk.onAquamarine(this);

  /// set foreground color to X11/CSS color azure ![azure](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0FFFF)/rgb(240, 255, 255)
  String get azure => _chalk.azure(this);

  /// set background color to X11/CSS color azure ![azure](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0FFFF)/rgb(240, 255, 255)
  String get onAzure => _chalk.onAzure(this);

  /// set foreground color to X11/CSS color beige ![beige](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,245,220%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5F5DC)/rgb(245, 245, 220)
  String get beige => _chalk.beige(this);

  /// set background color to X11/CSS color beige ![beige](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,245,220%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5F5DC)/rgb(245, 245, 220)
  String get onBeige => _chalk.onBeige(this);

  /// set foreground color to X11/CSS color bisque ![bisque](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,228,196%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFE4C4)/rgb(255, 228, 196)
  String get bisque => _chalk.bisque(this);

  /// set background color to X11/CSS color bisque ![bisque](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,228,196%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFE4C4)/rgb(255, 228, 196)
  String get onBisque => _chalk.onBisque(this);

  /// set foreground color to X11/CSS color blackX11 ![black](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x000000)/rgb(0, 0, 0)
  String get blackX11 => _chalk.blackX11(this);

  /// set background color to X11/CSS color blackX11 ![black](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x000000)/rgb(0, 0, 0)
  String get onBlackX11 => _chalk.onBlackX11(this);

  /// set foreground color to X11/CSS color blanchedAlmond ![blanchedalmond](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,235,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFEBCD)/rgb(255, 235, 205)
  String get blanchedAlmond => _chalk.blanchedAlmond(this);

  /// set background color to X11/CSS color blanchedAlmond ![blanchedalmond](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,235,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFEBCD)/rgb(255, 235, 205)
  String get onBlanchedAlmond => _chalk.onBlanchedAlmond(this);

  /// set foreground color to X11/CSS color blueX11 ![blue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x0000FF)/rgb(0, 0, 255)
  String get blueX11 => _chalk.blueX11(this);

  /// set background color to X11/CSS color blueX11 ![blue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x0000FF)/rgb(0, 0, 255)
  String get onBlueX11 => _chalk.onBlueX11(this);

  /// set foreground color to X11/CSS color blueViolet ![blueviolet](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28138,43,226%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8A2BE2)/rgb(138, 43, 226)
  String get blueViolet => _chalk.blueViolet(this);

  /// set background color to X11/CSS color blueViolet ![blueviolet](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28138,43,226%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8A2BE2)/rgb(138, 43, 226)
  String get onBlueViolet => _chalk.onBlueViolet(this);

  /// set foreground color to X11/CSS color brown ![brown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28165,42,42%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA52A2A)/rgb(165, 42, 42)
  String get brown => _chalk.brown(this);

  /// set background color to X11/CSS color brown ![brown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28165,42,42%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA52A2A)/rgb(165, 42, 42)
  String get onBrown => _chalk.onBrown(this);

  /// set foreground color to X11/CSS color burlywood ![burlywood](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28222,184,135%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDEB887)/rgb(222, 184, 135)
  String get burlywood => _chalk.burlywood(this);

  /// set background color to X11/CSS color burlywood ![burlywood](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28222,184,135%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDEB887)/rgb(222, 184, 135)
  String get onBurlywood => _chalk.onBurlywood(this);

  /// set foreground color to X11/CSS color cadetBlue ![cadetblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2895,158,160%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x5F9EA0)/rgb(95, 158, 160)
  String get cadetBlue => _chalk.cadetBlue(this);

  /// set background color to X11/CSS color cadetBlue ![cadetblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2895,158,160%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x5F9EA0)/rgb(95, 158, 160)
  String get onCadetBlue => _chalk.onCadetBlue(this);

  /// set foreground color to X11/CSS color chartreuse ![chartreuse](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28127,255,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7FFF00)/rgb(127, 255, 0)
  String get chartreuse => _chalk.chartreuse(this);

  /// set background color to X11/CSS color chartreuse ![chartreuse](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28127,255,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7FFF00)/rgb(127, 255, 0)
  String get onChartreuse => _chalk.onChartreuse(this);

  /// set foreground color to X11/CSS color chocolate ![chocolate](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28210,105,30%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD2691E)/rgb(210, 105, 30)
  String get chocolate => _chalk.chocolate(this);

  /// set background color to X11/CSS color chocolate ![chocolate](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28210,105,30%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD2691E)/rgb(210, 105, 30)
  String get onChocolate => _chalk.onChocolate(this);

  /// set foreground color to X11/CSS color coral ![coral](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,127,80%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF7F50)/rgb(255, 127, 80)
  String get coral => _chalk.coral(this);

  /// set background color to X11/CSS color coral ![coral](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,127,80%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF7F50)/rgb(255, 127, 80)
  String get onCoral => _chalk.onCoral(this);

  /// set foreground color to X11/CSS color cornflowerBlue ![cornflowerblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28100,149,237%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x6495ED)/rgb(100, 149, 237)
  String get cornflowerBlue => _chalk.cornflowerBlue(this);

  /// set background color to X11/CSS color cornflowerBlue ![cornflowerblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28100,149,237%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x6495ED)/rgb(100, 149, 237)
  String get onCornflowerBlue => _chalk.onCornflowerBlue(this);

  /// set foreground color to X11/CSS color cornsilk ![cornsilk](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,248,220%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFF8DC)/rgb(255, 248, 220)
  String get cornsilk => _chalk.cornsilk(this);

  /// set background color to X11/CSS color cornsilk ![cornsilk](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,248,220%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFF8DC)/rgb(255, 248, 220)
  String get onCornsilk => _chalk.onCornsilk(this);

  /// set foreground color to X11/CSS color crimson ![crimson](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28220,20,60%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDC143C)/rgb(220, 20, 60)
  String get crimson => _chalk.crimson(this);

  /// set background color to X11/CSS color crimson ![crimson](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28220,20,60%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDC143C)/rgb(220, 20, 60)
  String get onCrimson => _chalk.onCrimson(this);

  /// set foreground color to X11/CSS color cyanX11 ![cyan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FFFF)/rgb(0, 255, 255)
  String get cyanX11 => _chalk.cyanX11(this);

  /// set background color to X11/CSS color cyanX11 ![cyan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FFFF)/rgb(0, 255, 255)
  String get onCyanX11 => _chalk.onCyanX11(this);

  /// set foreground color to X11/CSS color darkBlue ![darkblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00008B)/rgb(0, 0, 139)
  String get darkBlue => _chalk.darkBlue(this);

  /// set background color to X11/CSS color darkBlue ![darkblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00008B)/rgb(0, 0, 139)
  String get onDarkBlue => _chalk.onDarkBlue(this);

  /// set foreground color to X11/CSS color darkCyan ![darkcyan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,139,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x008B8B)/rgb(0, 139, 139)
  String get darkCyan => _chalk.darkCyan(this);

  /// set background color to X11/CSS color darkCyan ![darkcyan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,139,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x008B8B)/rgb(0, 139, 139)
  String get onDarkCyan => _chalk.onDarkCyan(this);

  /// set foreground color to X11/CSS color darkGoldenrod ![darkgoldenrod](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28184,134,11%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB8860B)/rgb(184, 134, 11)
  String get darkGoldenrod => _chalk.darkGoldenrod(this);

  /// set background color to X11/CSS color darkGoldenrod ![darkgoldenrod](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28184,134,11%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB8860B)/rgb(184, 134, 11)
  String get onDarkGoldenrod => _chalk.onDarkGoldenrod(this);

  /// set foreground color to X11/CSS color darkGray ![darkgray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28169,169,169%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA9A9A9)/rgb(169, 169, 169)
  String get darkGray => _chalk.darkGray(this);

  /// set background color to X11/CSS color darkGray ![darkgray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28169,169,169%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA9A9A9)/rgb(169, 169, 169)
  String get onDarkGray => _chalk.onDarkGray(this);

  /// set foreground color to X11/CSS color darkGreen ![darkgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,100,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x006400)/rgb(0, 100, 0)
  String get darkGreen => _chalk.darkGreen(this);

  /// set background color to X11/CSS color darkGreen ![darkgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,100,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x006400)/rgb(0, 100, 0)
  String get onDarkGreen => _chalk.onDarkGreen(this);

  /// set foreground color to X11/CSS color darkGrey ![darkgrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28169,169,169%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA9A9A9)/rgb(169, 169, 169)
  String get darkGrey => _chalk.darkGrey(this);

  /// set background color to X11/CSS color darkGrey ![darkgrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28169,169,169%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA9A9A9)/rgb(169, 169, 169)
  String get onDarkGrey => _chalk.onDarkGrey(this);

  /// set foreground color to X11/CSS color darkKhaki ![darkkhaki](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28189,183,107%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xBDB76B)/rgb(189, 183, 107)
  String get darkKhaki => _chalk.darkKhaki(this);

  /// set background color to X11/CSS color darkKhaki ![darkkhaki](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28189,183,107%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xBDB76B)/rgb(189, 183, 107)
  String get onDarkKhaki => _chalk.onDarkKhaki(this);

  /// set foreground color to X11/CSS color darkMagenta ![darkmagenta](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28139,0,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8B008B)/rgb(139, 0, 139)
  String get darkMagenta => _chalk.darkMagenta(this);

  /// set background color to X11/CSS color darkMagenta ![darkmagenta](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28139,0,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8B008B)/rgb(139, 0, 139)
  String get onDarkMagenta => _chalk.onDarkMagenta(this);

  /// set foreground color to X11/CSS color darkOliveGreen ![darkolivegreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2885,107,47%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x556B2F)/rgb(85, 107, 47)
  String get darkOliveGreen => _chalk.darkOliveGreen(this);

  /// set background color to X11/CSS color darkOliveGreen ![darkolivegreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2885,107,47%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x556B2F)/rgb(85, 107, 47)
  String get onDarkOliveGreen => _chalk.onDarkOliveGreen(this);

  /// set foreground color to X11/CSS color darkOrange ![darkorange](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,140,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF8C00)/rgb(255, 140, 0)
  String get darkOrange => _chalk.darkOrange(this);

  /// set background color to X11/CSS color darkOrange ![darkorange](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,140,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF8C00)/rgb(255, 140, 0)
  String get onDarkOrange => _chalk.onDarkOrange(this);

  /// set foreground color to X11/CSS color darkOrchid ![darkorchid](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28153,50,204%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9932CC)/rgb(153, 50, 204)
  String get darkOrchid => _chalk.darkOrchid(this);

  /// set background color to X11/CSS color darkOrchid ![darkorchid](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28153,50,204%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9932CC)/rgb(153, 50, 204)
  String get onDarkOrchid => _chalk.onDarkOrchid(this);

  /// set foreground color to X11/CSS color darkRed ![darkred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28139,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8B0000)/rgb(139, 0, 0)
  String get darkRed => _chalk.darkRed(this);

  /// set background color to X11/CSS color darkRed ![darkred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28139,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8B0000)/rgb(139, 0, 0)
  String get onDarkRed => _chalk.onDarkRed(this);

  /// set foreground color to X11/CSS color darkSalmon ![darksalmon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28233,150,122%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xE9967A)/rgb(233, 150, 122)
  String get darkSalmon => _chalk.darkSalmon(this);

  /// set background color to X11/CSS color darkSalmon ![darksalmon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28233,150,122%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xE9967A)/rgb(233, 150, 122)
  String get onDarkSalmon => _chalk.onDarkSalmon(this);

  /// set foreground color to X11/CSS color darkSeaGreen ![darkseagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28143,188,143%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8FBC8F)/rgb(143, 188, 143)
  String get darkSeaGreen => _chalk.darkSeaGreen(this);

  /// set background color to X11/CSS color darkSeaGreen ![darkseagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28143,188,143%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8FBC8F)/rgb(143, 188, 143)
  String get onDarkSeaGreen => _chalk.onDarkSeaGreen(this);

  /// set foreground color to X11/CSS color darkSlateBlue ![darkslateblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2872,61,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x483D8B)/rgb(72, 61, 139)
  String get darkSlateBlue => _chalk.darkSlateBlue(this);

  /// set background color to X11/CSS color darkSlateBlue ![darkslateblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2872,61,139%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x483D8B)/rgb(72, 61, 139)
  String get onDarkSlateBlue => _chalk.onDarkSlateBlue(this);

  /// set foreground color to X11/CSS color darkSlateGray ![darkslategray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2847,79,79%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x2F4F4F)/rgb(47, 79, 79)
  String get darkSlateGray => _chalk.darkSlateGray(this);

  /// set background color to X11/CSS color darkSlateGray ![darkslategray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2847,79,79%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x2F4F4F)/rgb(47, 79, 79)
  String get onDarkSlateGray => _chalk.onDarkSlateGray(this);

  /// set foreground color to X11/CSS color darkSlateGrey ![darkslategrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2847,79,79%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x2F4F4F)/rgb(47, 79, 79)
  String get darkSlateGrey => _chalk.darkSlateGrey(this);

  /// set background color to X11/CSS color darkSlateGrey ![darkslategrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2847,79,79%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x2F4F4F)/rgb(47, 79, 79)
  String get onDarkSlateGrey => _chalk.onDarkSlateGrey(this);

  /// set foreground color to X11/CSS color darkTurquoise ![darkturquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,206,209%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00CED1)/rgb(0, 206, 209)
  String get darkTurquoise => _chalk.darkTurquoise(this);

  /// set background color to X11/CSS color darkTurquoise ![darkturquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,206,209%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00CED1)/rgb(0, 206, 209)
  String get onDarkTurquoise => _chalk.onDarkTurquoise(this);

  /// set foreground color to X11/CSS color darkViolet ![darkviolet](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28148,0,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9400D3)/rgb(148, 0, 211)
  String get darkViolet => _chalk.darkViolet(this);

  /// set background color to X11/CSS color darkViolet ![darkviolet](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28148,0,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9400D3)/rgb(148, 0, 211)
  String get onDarkViolet => _chalk.onDarkViolet(this);

  /// set foreground color to X11/CSS color deepPink ![deeppink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,20,147%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF1493)/rgb(255, 20, 147)
  String get deepPink => _chalk.deepPink(this);

  /// set background color to X11/CSS color deepPink ![deeppink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,20,147%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF1493)/rgb(255, 20, 147)
  String get onDeepPink => _chalk.onDeepPink(this);

  /// set foreground color to X11/CSS color deepSkyBlue ![deepskyblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,191,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00BFFF)/rgb(0, 191, 255)
  String get deepSkyBlue => _chalk.deepSkyBlue(this);

  /// set background color to X11/CSS color deepSkyBlue ![deepskyblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,191,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00BFFF)/rgb(0, 191, 255)
  String get onDeepSkyBlue => _chalk.onDeepSkyBlue(this);

  /// set foreground color to X11/CSS color dimGray ![dimgray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28105,105,105%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x696969)/rgb(105, 105, 105)
  String get dimGray => _chalk.dimGray(this);

  /// set background color to X11/CSS color dimGray ![dimgray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28105,105,105%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x696969)/rgb(105, 105, 105)
  String get onDimGray => _chalk.onDimGray(this);

  /// set foreground color to X11/CSS color dimGrey ![dimgrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28105,105,105%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x696969)/rgb(105, 105, 105)
  String get dimGrey => _chalk.dimGrey(this);

  /// set background color to X11/CSS color dimGrey ![dimgrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28105,105,105%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x696969)/rgb(105, 105, 105)
  String get onDimGrey => _chalk.onDimGrey(this);

  /// set foreground color to X11/CSS color dodgerBlue ![dodgerblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2830,144,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x1E90FF)/rgb(30, 144, 255)
  String get dodgerBlue => _chalk.dodgerBlue(this);

  /// set background color to X11/CSS color dodgerBlue ![dodgerblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2830,144,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x1E90FF)/rgb(30, 144, 255)
  String get onDodgerBlue => _chalk.onDodgerBlue(this);

  /// set foreground color to X11/CSS color fireBrick ![firebrick](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28178,34,34%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB22222)/rgb(178, 34, 34)
  String get fireBrick => _chalk.fireBrick(this);

  /// set background color to X11/CSS color fireBrick ![firebrick](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28178,34,34%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB22222)/rgb(178, 34, 34)
  String get onFireBrick => _chalk.onFireBrick(this);

  /// set foreground color to X11/CSS color floralWhite ![floralwhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,250,240%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFAF0)/rgb(255, 250, 240)
  String get floralWhite => _chalk.floralWhite(this);

  /// set background color to X11/CSS color floralWhite ![floralwhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,250,240%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFAF0)/rgb(255, 250, 240)
  String get onFloralWhite => _chalk.onFloralWhite(this);

  /// set foreground color to X11/CSS color forestGreen ![forestgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2834,139,34%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x228B22)/rgb(34, 139, 34)
  String get forestGreen => _chalk.forestGreen(this);

  /// set background color to X11/CSS color forestGreen ![forestgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2834,139,34%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x228B22)/rgb(34, 139, 34)
  String get onForestGreen => _chalk.onForestGreen(this);

  /// set foreground color to X11/CSS color fuchsia ![fuchsia](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,0,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF00FF)/rgb(255, 0, 255)
  String get fuchsia => _chalk.fuchsia(this);

  /// set background color to X11/CSS color fuchsia ![fuchsia](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,0,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF00FF)/rgb(255, 0, 255)
  String get onFuchsia => _chalk.onFuchsia(this);

  /// set foreground color to X11/CSS color gainsboro ![gainsboro](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28220,220,220%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDCDCDC)/rgb(220, 220, 220)
  String get gainsboro => _chalk.gainsboro(this);

  /// set background color to X11/CSS color gainsboro ![gainsboro](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28220,220,220%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDCDCDC)/rgb(220, 220, 220)
  String get onGainsboro => _chalk.onGainsboro(this);

  /// set foreground color to X11/CSS color ghostWhite ![ghostwhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28248,248,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF8F8FF)/rgb(248, 248, 255)
  String get ghostWhite => _chalk.ghostWhite(this);

  /// set background color to X11/CSS color ghostWhite ![ghostwhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28248,248,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF8F8FF)/rgb(248, 248, 255)
  String get onGhostWhite => _chalk.onGhostWhite(this);

  /// set foreground color to X11/CSS color gold ![gold](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,215,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFD700)/rgb(255, 215, 0)
  String get gold => _chalk.gold(this);

  /// set background color to X11/CSS color gold ![gold](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,215,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFD700)/rgb(255, 215, 0)
  String get onGold => _chalk.onGold(this);

  /// set foreground color to X11/CSS color goldenrod ![goldenrod](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28218,165,32%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDAA520)/rgb(218, 165, 32)
  String get goldenrod => _chalk.goldenrod(this);

  /// set background color to X11/CSS color goldenrod ![goldenrod](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28218,165,32%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDAA520)/rgb(218, 165, 32)
  String get onGoldenrod => _chalk.onGoldenrod(this);

  /// set foreground color to X11/CSS color grayX11 ![gray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x808080)/rgb(128, 128, 128)
  String get grayX11 => _chalk.grayX11(this);

  /// set background color to X11/CSS color grayX11 ![gray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x808080)/rgb(128, 128, 128)
  String get onGrayX11 => _chalk.onGrayX11(this);

  /// set foreground color to X11/CSS color greenX11 ![green](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,128,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x008000)/rgb(0, 128, 0)
  String get greenX11 => _chalk.greenX11(this);

  /// set background color to X11/CSS color greenX11 ![green](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,128,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x008000)/rgb(0, 128, 0)
  String get onGreenX11 => _chalk.onGreenX11(this);

  /// set foreground color to X11/CSS color greenYellow ![greenyellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28173,255,47%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xADFF2F)/rgb(173, 255, 47)
  String get greenYellow => _chalk.greenYellow(this);

  /// set background color to X11/CSS color greenYellow ![greenyellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28173,255,47%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xADFF2F)/rgb(173, 255, 47)
  String get onGreenYellow => _chalk.onGreenYellow(this);

  /// set foreground color to X11/CSS color greyX11 ![grey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x808080)/rgb(128, 128, 128)
  String get greyX11 => _chalk.greyX11(this);

  /// set background color to X11/CSS color greyX11 ![grey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x808080)/rgb(128, 128, 128)
  String get onGreyX11 => _chalk.onGreyX11(this);

  /// set foreground color to X11/CSS color honeydew ![honeydew](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,255,240%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0FFF0)/rgb(240, 255, 240)
  String get honeydew => _chalk.honeydew(this);

  /// set background color to X11/CSS color honeydew ![honeydew](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,255,240%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0FFF0)/rgb(240, 255, 240)
  String get onHoneydew => _chalk.onHoneydew(this);

  /// set foreground color to X11/CSS color hotPink ![hotpink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,105,180%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF69B4)/rgb(255, 105, 180)
  String get hotPink => _chalk.hotPink(this);

  /// set background color to X11/CSS color hotPink ![hotpink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,105,180%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF69B4)/rgb(255, 105, 180)
  String get onHotPink => _chalk.onHotPink(this);

  /// set foreground color to X11/CSS color indianRed ![indianred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28205,92,92%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xCD5C5C)/rgb(205, 92, 92)
  String get indianRed => _chalk.indianRed(this);

  /// set background color to X11/CSS color indianRed ![indianred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28205,92,92%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xCD5C5C)/rgb(205, 92, 92)
  String get onIndianRed => _chalk.onIndianRed(this);

  /// set foreground color to X11/CSS color indigo ![indigo](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2875,0,130%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x4B0082)/rgb(75, 0, 130)
  String get indigo => _chalk.indigo(this);

  /// set background color to X11/CSS color indigo ![indigo](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2875,0,130%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x4B0082)/rgb(75, 0, 130)
  String get onIndigo => _chalk.onIndigo(this);

  /// set foreground color to X11/CSS color ivory ![ivory](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,240%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFFF0)/rgb(255, 255, 240)
  String get ivory => _chalk.ivory(this);

  /// set background color to X11/CSS color ivory ![ivory](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,240%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFFF0)/rgb(255, 255, 240)
  String get onIvory => _chalk.onIvory(this);

  /// set foreground color to X11/CSS color khaki ![khaki](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,230,140%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0E68C)/rgb(240, 230, 140)
  String get khaki => _chalk.khaki(this);

  /// set background color to X11/CSS color khaki ![khaki](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,230,140%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF0E68C)/rgb(240, 230, 140)
  String get onKhaki => _chalk.onKhaki(this);

  /// set foreground color to X11/CSS color lavender ![lavender](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28230,230,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xE6E6FA)/rgb(230, 230, 250)
  String get lavender => _chalk.lavender(this);

  /// set background color to X11/CSS color lavender ![lavender](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28230,230,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xE6E6FA)/rgb(230, 230, 250)
  String get onLavender => _chalk.onLavender(this);

  /// set foreground color to X11/CSS color lavenderBlush ![lavenderblush](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,240,245%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFF0F5)/rgb(255, 240, 245)
  String get lavenderBlush => _chalk.lavenderBlush(this);

  /// set background color to X11/CSS color lavenderBlush ![lavenderblush](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,240,245%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFF0F5)/rgb(255, 240, 245)
  String get onLavenderBlush => _chalk.onLavenderBlush(this);

  /// set foreground color to X11/CSS color lawnGreen ![lawngreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28124,252,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7CFC00)/rgb(124, 252, 0)
  String get lawnGreen => _chalk.lawnGreen(this);

  /// set background color to X11/CSS color lawnGreen ![lawngreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28124,252,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7CFC00)/rgb(124, 252, 0)
  String get onLawnGreen => _chalk.onLawnGreen(this);

  /// set foreground color to X11/CSS color lemonChiffon ![lemonchiffon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,250,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFACD)/rgb(255, 250, 205)
  String get lemonChiffon => _chalk.lemonChiffon(this);

  /// set background color to X11/CSS color lemonChiffon ![lemonchiffon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,250,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFACD)/rgb(255, 250, 205)
  String get onLemonChiffon => _chalk.onLemonChiffon(this);

  /// set foreground color to X11/CSS color lightBlue ![lightblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28173,216,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xADD8E6)/rgb(173, 216, 230)
  String get lightBlue => _chalk.lightBlue(this);

  /// set background color to X11/CSS color lightBlue ![lightblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28173,216,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xADD8E6)/rgb(173, 216, 230)
  String get onLightBlue => _chalk.onLightBlue(this);

  /// set foreground color to X11/CSS color lightCoral ![lightcoral](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF08080)/rgb(240, 128, 128)
  String get lightCoral => _chalk.lightCoral(this);

  /// set background color to X11/CSS color lightCoral ![lightcoral](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28240,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF08080)/rgb(240, 128, 128)
  String get onLightCoral => _chalk.onLightCoral(this);

  /// set foreground color to X11/CSS color lightCyan ![lightcyan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28224,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xE0FFFF)/rgb(224, 255, 255)
  String get lightCyan => _chalk.lightCyan(this);

  /// set background color to X11/CSS color lightCyan ![lightcyan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28224,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xE0FFFF)/rgb(224, 255, 255)
  String get onLightCyan => _chalk.onLightCyan(this);

  /// set foreground color to CSS color lightGoldenrodYellow ![lightgoldenrodyellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,250,210%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAFAD2)/rgb(250, 250, 210)
  String get lightGoldenrodYellow => _chalk.lightGoldenrodYellow(this);

  /// set background color to CSS color lightGoldenrodYellow ![lightgoldenrodyellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,250,210%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAFAD2)/rgb(250, 250, 210)
  String get onLightGoldenrodYellow => _chalk.onLightGoldenrodYellow(this);

  /// set foreground color to X11 color lightGoldenrod ![rgb(250, 250, 210)](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,250,210%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAFAD2)/rgb(250, 250, 210)
  String get lightGoldenrod => _chalk.lightGoldenrod(this);

  /// set background color to X11 color lightGoldenrod ![rgb(250, 250, 210)](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,250,210%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAFAD2)/rgb(250, 250, 210)
  String get onLightGoldenrod => _chalk.onLightGoldenrod(this);

  /// set foreground color to X11/CSS color lightGray ![lightgray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28211,211,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD3D3D3)/rgb(211, 211, 211)
  String get lightGray => _chalk.lightGray(this);

  /// set background color to X11/CSS color lightGray ![lightgray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28211,211,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD3D3D3)/rgb(211, 211, 211)
  String get onLightGray => _chalk.onLightGray(this);

  /// set foreground color to X11/CSS color lightGreen ![lightgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28144,238,144%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x90EE90)/rgb(144, 238, 144)
  String get lightGreen => _chalk.lightGreen(this);

  /// set background color to X11/CSS color lightGreen ![lightgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28144,238,144%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x90EE90)/rgb(144, 238, 144)
  String get onLightGreen => _chalk.onLightGreen(this);

  /// set foreground color to X11/CSS color lightGrey ![lightgrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28211,211,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD3D3D3)/rgb(211, 211, 211)
  String get lightGrey => _chalk.lightGrey(this);

  /// set background color to X11/CSS color lightGrey ![lightgrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28211,211,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD3D3D3)/rgb(211, 211, 211)
  String get onLightGrey => _chalk.onLightGrey(this);

  /// set foreground color to X11/CSS color lightPink ![lightpink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,182,193%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFB6C1)/rgb(255, 182, 193)
  String get lightPink => _chalk.lightPink(this);

  /// set background color to X11/CSS color lightPink ![lightpink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,182,193%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFB6C1)/rgb(255, 182, 193)
  String get onLightPink => _chalk.onLightPink(this);

  /// set foreground color to X11/CSS color lightSalmon ![lightsalmon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,160,122%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFA07A)/rgb(255, 160, 122)
  String get lightSalmon => _chalk.lightSalmon(this);

  /// set background color to X11/CSS color lightSalmon ![lightsalmon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,160,122%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFA07A)/rgb(255, 160, 122)
  String get onLightSalmon => _chalk.onLightSalmon(this);

  /// set foreground color to X11/CSS color lightSeaGreen ![lightseagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2832,178,170%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x20B2AA)/rgb(32, 178, 170)
  String get lightSeaGreen => _chalk.lightSeaGreen(this);

  /// set background color to X11/CSS color lightSeaGreen ![lightseagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2832,178,170%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x20B2AA)/rgb(32, 178, 170)
  String get onLightSeaGreen => _chalk.onLightSeaGreen(this);

  /// set foreground color to X11/CSS color lightSkyBlue ![lightskyblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28135,206,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x87CEFA)/rgb(135, 206, 250)
  String get lightSkyBlue => _chalk.lightSkyBlue(this);

  /// set background color to X11/CSS color lightSkyBlue ![lightskyblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28135,206,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x87CEFA)/rgb(135, 206, 250)
  String get onLightSkyBlue => _chalk.onLightSkyBlue(this);

  /// set foreground color to X11/CSS color lightSlateGray ![lightslategray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28119,136,153%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x778899)/rgb(119, 136, 153)
  String get lightSlateGray => _chalk.lightSlateGray(this);

  /// set background color to X11/CSS color lightSlateGray ![lightslategray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28119,136,153%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x778899)/rgb(119, 136, 153)
  String get onLightSlateGray => _chalk.onLightSlateGray(this);

  /// set foreground color to X11/CSS color lightSlateGrey ![lightslategrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28119,136,153%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x778899)/rgb(119, 136, 153)
  String get lightSlateGrey => _chalk.lightSlateGrey(this);

  /// set background color to X11/CSS color lightSlateGrey ![lightslategrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28119,136,153%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x778899)/rgb(119, 136, 153)
  String get onLightSlateGrey => _chalk.onLightSlateGrey(this);

  /// set foreground color to X11/CSS color lightSteelBlue ![lightsteelblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28176,196,222%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB0C4DE)/rgb(176, 196, 222)
  String get lightSteelBlue => _chalk.lightSteelBlue(this);

  /// set background color to X11/CSS color lightSteelBlue ![lightsteelblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28176,196,222%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB0C4DE)/rgb(176, 196, 222)
  String get onLightSteelBlue => _chalk.onLightSteelBlue(this);

  /// set foreground color to X11/CSS color lightYellow ![lightyellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,224%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFFE0)/rgb(255, 255, 224)
  String get lightYellow => _chalk.lightYellow(this);

  /// set background color to X11/CSS color lightYellow ![lightyellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,224%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFFE0)/rgb(255, 255, 224)
  String get onLightYellow => _chalk.onLightYellow(this);

  /// set foreground color to X11/CSS color lime ![lime](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FF00)/rgb(0, 255, 0)
  String get lime => _chalk.lime(this);

  /// set background color to X11/CSS color lime ![lime](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FF00)/rgb(0, 255, 0)
  String get onLime => _chalk.onLime(this);

  /// set foreground color to X11/CSS color limeGreen ![limegreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2850,205,50%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x32CD32)/rgb(50, 205, 50)
  String get limeGreen => _chalk.limeGreen(this);

  /// set background color to X11/CSS color limeGreen ![limegreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2850,205,50%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x32CD32)/rgb(50, 205, 50)
  String get onLimeGreen => _chalk.onLimeGreen(this);

  /// set foreground color to X11/CSS color linen ![linen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,240,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAF0E6)/rgb(250, 240, 230)
  String get linen => _chalk.linen(this);

  /// set background color to X11/CSS color linen ![linen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,240,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFAF0E6)/rgb(250, 240, 230)
  String get onLinen => _chalk.onLinen(this);

  /// set foreground color to X11/CSS color magentaX11 ![magenta](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,0,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF00FF)/rgb(255, 0, 255)
  String get magentaX11 => _chalk.magentaX11(this);

  /// set background color to X11/CSS color magentaX11 ![magenta](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,0,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF00FF)/rgb(255, 0, 255)
  String get onMagentaX11 => _chalk.onMagentaX11(this);

  /// set foreground color to X11/CSS color maroon ![maroon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x800000)/rgb(128, 0, 0)
  String get maroon => _chalk.maroon(this);

  /// set background color to X11/CSS color maroon ![maroon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x800000)/rgb(128, 0, 0)
  String get onMaroon => _chalk.onMaroon(this);

  /// set foreground color to X11/CSS color mediumAquamarine ![mediumaquamarine](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28102,205,170%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x66CDAA)/rgb(102, 205, 170)
  String get mediumAquamarine => _chalk.mediumAquamarine(this);

  /// set background color to X11/CSS color mediumAquamarine ![mediumaquamarine](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28102,205,170%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x66CDAA)/rgb(102, 205, 170)
  String get onMediumAquamarine => _chalk.onMediumAquamarine(this);

  /// set foreground color to X11/CSS color mediumBlue ![mediumblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x0000CD)/rgb(0, 0, 205)
  String get mediumBlue => _chalk.mediumBlue(this);

  /// set background color to X11/CSS color mediumBlue ![mediumblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x0000CD)/rgb(0, 0, 205)
  String get onMediumBlue => _chalk.onMediumBlue(this);

  /// set foreground color to X11/CSS color mediumOrchid ![mediumorchid](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28186,85,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xBA55D3)/rgb(186, 85, 211)
  String get mediumOrchid => _chalk.mediumOrchid(this);

  /// set background color to X11/CSS color mediumOrchid ![mediumorchid](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28186,85,211%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xBA55D3)/rgb(186, 85, 211)
  String get onMediumOrchid => _chalk.onMediumOrchid(this);

  /// set foreground color to X11/CSS color mediumPurple ![mediumpurple](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28147,112,219%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9370DB)/rgb(147, 112, 219)
  String get mediumPurple => _chalk.mediumPurple(this);

  /// set background color to X11/CSS color mediumPurple ![mediumpurple](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28147,112,219%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9370DB)/rgb(147, 112, 219)
  String get onMediumPurple => _chalk.onMediumPurple(this);

  /// set foreground color to X11/CSS color mediumSeaGreen ![mediumseagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2860,179,113%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x3CB371)/rgb(60, 179, 113)
  String get mediumSeaGreen => _chalk.mediumSeaGreen(this);

  /// set background color to X11/CSS color mediumSeaGreen ![mediumseagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2860,179,113%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x3CB371)/rgb(60, 179, 113)
  String get onMediumSeaGreen => _chalk.onMediumSeaGreen(this);

  /// set foreground color to X11/CSS color mediumSlateBlue ![mediumslateblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28123,104,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7B68EE)/rgb(123, 104, 238)
  String get mediumSlateBlue => _chalk.mediumSlateBlue(this);

  /// set background color to X11/CSS color mediumSlateBlue ![mediumslateblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28123,104,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x7B68EE)/rgb(123, 104, 238)
  String get onMediumSlateBlue => _chalk.onMediumSlateBlue(this);

  /// set foreground color to X11/CSS color mediumSpringGreen ![mediumspringgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,250,154%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FA9A)/rgb(0, 250, 154)
  String get mediumSpringGreen => _chalk.mediumSpringGreen(this);

  /// set background color to X11/CSS color mediumSpringGreen ![mediumspringgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,250,154%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FA9A)/rgb(0, 250, 154)
  String get onMediumSpringGreen => _chalk.onMediumSpringGreen(this);

  /// set foreground color to X11/CSS color mediumTurquoise ![mediumturquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2872,209,204%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x48D1CC)/rgb(72, 209, 204)
  String get mediumTurquoise => _chalk.mediumTurquoise(this);

  /// set background color to X11/CSS color mediumTurquoise ![mediumturquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2872,209,204%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x48D1CC)/rgb(72, 209, 204)
  String get onMediumTurquoise => _chalk.onMediumTurquoise(this);

  /// set foreground color to X11/CSS color mediumVioletRed ![mediumvioletred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28199,21,133%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xC71585)/rgb(199, 21, 133)
  String get mediumVioletRed => _chalk.mediumVioletRed(this);

  /// set background color to X11/CSS color mediumVioletRed ![mediumvioletred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28199,21,133%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xC71585)/rgb(199, 21, 133)
  String get onMediumVioletRed => _chalk.onMediumVioletRed(this);

  /// set foreground color to X11/CSS color midnightBlue ![midnightblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2825,25,112%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x191970)/rgb(25, 25, 112)
  String get midnightBlue => _chalk.midnightBlue(this);

  /// set background color to X11/CSS color midnightBlue ![midnightblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2825,25,112%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x191970)/rgb(25, 25, 112)
  String get onMidnightBlue => _chalk.onMidnightBlue(this);

  /// set foreground color to X11/CSS color mintCream ![mintcream](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,255,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5FFFA)/rgb(245, 255, 250)
  String get mintCream => _chalk.mintCream(this);

  /// set background color to X11/CSS color mintCream ![mintcream](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,255,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5FFFA)/rgb(245, 255, 250)
  String get onMintCream => _chalk.onMintCream(this);

  /// set foreground color to X11/CSS color mistyRose ![mistyrose](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,228,225%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFE4E1)/rgb(255, 228, 225)
  String get mistyRose => _chalk.mistyRose(this);

  /// set background color to X11/CSS color mistyRose ![mistyrose](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,228,225%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFE4E1)/rgb(255, 228, 225)
  String get onMistyRose => _chalk.onMistyRose(this);

  /// set foreground color to X11/CSS color moccasin ![moccasin](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,228,181%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFE4B5)/rgb(255, 228, 181)
  String get moccasin => _chalk.moccasin(this);

  /// set background color to X11/CSS color moccasin ![moccasin](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,228,181%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFE4B5)/rgb(255, 228, 181)
  String get onMoccasin => _chalk.onMoccasin(this);

  /// set foreground color to X11/CSS color navajoWhite ![navajowhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,222,173%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFDEAD)/rgb(255, 222, 173)
  String get navajoWhite => _chalk.navajoWhite(this);

  /// set background color to X11/CSS color navajoWhite ![navajowhite](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,222,173%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFDEAD)/rgb(255, 222, 173)
  String get onNavajoWhite => _chalk.onNavajoWhite(this);

  /// set foreground color to X11/CSS color navy ![navy](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x000080)/rgb(0, 0, 128)
  String get navy => _chalk.navy(this);

  /// set background color to X11/CSS color navy ![navy](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,0,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x000080)/rgb(0, 0, 128)
  String get onNavy => _chalk.onNavy(this);

  /// set foreground color to X11/CSS color oldLace ![oldlace](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28253,245,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFDF5E6)/rgb(253, 245, 230)
  String get oldLace => _chalk.oldLace(this);

  /// set background color to X11/CSS color oldLace ![oldlace](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28253,245,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFDF5E6)/rgb(253, 245, 230)
  String get onOldLace => _chalk.onOldLace(this);

  /// set foreground color to X11/CSS color olive ![olive](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,128,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x808000)/rgb(128, 128, 0)
  String get olive => _chalk.olive(this);

  /// set background color to X11/CSS color olive ![olive](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,128,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x808000)/rgb(128, 128, 0)
  String get onOlive => _chalk.onOlive(this);

  /// set foreground color to X11/CSS color oliveDrab ![olivedrab](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28107,142,35%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x6B8E23)/rgb(107, 142, 35)
  String get oliveDrab => _chalk.oliveDrab(this);

  /// set background color to X11/CSS color oliveDrab ![olivedrab](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28107,142,35%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x6B8E23)/rgb(107, 142, 35)
  String get onOliveDrab => _chalk.onOliveDrab(this);

  /// set foreground color to X11/CSS color orange ![orange](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,165,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFA500)/rgb(255, 165, 0)
  String get orange => _chalk.orange(this);

  /// set background color to X11/CSS color orange ![orange](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,165,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFA500)/rgb(255, 165, 0)
  String get onOrange => _chalk.onOrange(this);

  /// set foreground color to X11/CSS color orangeRed ![orangered](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,69,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF4500)/rgb(255, 69, 0)
  String get orangeRed => _chalk.orangeRed(this);

  /// set background color to X11/CSS color orangeRed ![orangered](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,69,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF4500)/rgb(255, 69, 0)
  String get onOrangeRed => _chalk.onOrangeRed(this);

  /// set foreground color to X11/CSS color orchid ![orchid](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28218,112,214%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDA70D6)/rgb(218, 112, 214)
  String get orchid => _chalk.orchid(this);

  /// set background color to X11/CSS color orchid ![orchid](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28218,112,214%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDA70D6)/rgb(218, 112, 214)
  String get onOrchid => _chalk.onOrchid(this);

  /// set foreground color to X11/CSS color paleGoldenrod ![palegoldenrod](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28238,232,170%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xEEE8AA)/rgb(238, 232, 170)
  String get paleGoldenrod => _chalk.paleGoldenrod(this);

  /// set background color to X11/CSS color paleGoldenrod ![palegoldenrod](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28238,232,170%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xEEE8AA)/rgb(238, 232, 170)
  String get onPaleGoldenrod => _chalk.onPaleGoldenrod(this);

  /// set foreground color to X11/CSS color paleGreen ![palegreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28152,251,152%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x98FB98)/rgb(152, 251, 152)
  String get paleGreen => _chalk.paleGreen(this);

  /// set background color to X11/CSS color paleGreen ![palegreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28152,251,152%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x98FB98)/rgb(152, 251, 152)
  String get onPaleGreen => _chalk.onPaleGreen(this);

  /// set foreground color to X11/CSS color paleTurquoise ![paleturquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28175,238,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xAFEEEE)/rgb(175, 238, 238)
  String get paleTurquoise => _chalk.paleTurquoise(this);

  /// set background color to X11/CSS color paleTurquoise ![paleturquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28175,238,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xAFEEEE)/rgb(175, 238, 238)
  String get onPaleTurquoise => _chalk.onPaleTurquoise(this);

  /// set foreground color to X11/CSS color paleVioletRed ![palevioletred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28219,112,147%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDB7093)/rgb(219, 112, 147)
  String get paleVioletRed => _chalk.paleVioletRed(this);

  /// set background color to X11/CSS color paleVioletRed ![palevioletred](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28219,112,147%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDB7093)/rgb(219, 112, 147)
  String get onPaleVioletRed => _chalk.onPaleVioletRed(this);

  /// set foreground color to X11/CSS color papayaWhip ![papayawhip](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,239,213%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFEFD5)/rgb(255, 239, 213)
  String get papayaWhip => _chalk.papayaWhip(this);

  /// set background color to X11/CSS color papayaWhip ![papayawhip](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,239,213%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFEFD5)/rgb(255, 239, 213)
  String get onPapayaWhip => _chalk.onPapayaWhip(this);

  /// set foreground color to X11/CSS color peachPuff ![peachpuff](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,218,185%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFDAB9)/rgb(255, 218, 185)
  String get peachPuff => _chalk.peachPuff(this);

  /// set background color to X11/CSS color peachPuff ![peachpuff](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,218,185%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFDAB9)/rgb(255, 218, 185)
  String get onPeachPuff => _chalk.onPeachPuff(this);

  /// set foreground color to X11/CSS color peru ![peru](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28205,133,63%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xCD853F)/rgb(205, 133, 63)
  String get peru => _chalk.peru(this);

  /// set background color to X11/CSS color peru ![peru](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28205,133,63%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xCD853F)/rgb(205, 133, 63)
  String get onPeru => _chalk.onPeru(this);

  /// set foreground color to X11/CSS color pink ![pink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,192,203%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFC0CB)/rgb(255, 192, 203)
  String get pink => _chalk.pink(this);

  /// set background color to X11/CSS color pink ![pink](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,192,203%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFC0CB)/rgb(255, 192, 203)
  String get onPink => _chalk.onPink(this);

  /// set foreground color to X11/CSS color plum ![plum](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28221,160,221%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDDA0DD)/rgb(221, 160, 221)
  String get plum => _chalk.plum(this);

  /// set background color to X11/CSS color plum ![plum](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28221,160,221%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xDDA0DD)/rgb(221, 160, 221)
  String get onPlum => _chalk.onPlum(this);

  /// set foreground color to X11/CSS color powderBlue ![powderblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28176,224,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB0E0E6)/rgb(176, 224, 230)
  String get powderBlue => _chalk.powderBlue(this);

  /// set background color to X11/CSS color powderBlue ![powderblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28176,224,230%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xB0E0E6)/rgb(176, 224, 230)
  String get onPowderBlue => _chalk.onPowderBlue(this);

  /// set foreground color to X11/CSS color purple ![purple](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,0,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x800080)/rgb(128, 0, 128)
  String get purple => _chalk.purple(this);

  /// set background color to X11/CSS color purple ![purple](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28128,0,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x800080)/rgb(128, 0, 128)
  String get onPurple => _chalk.onPurple(this);

  /// set foreground color to X11 color rebeccaPurple ![rgb(102, 51, 153)](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28102,51,153%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x663399)/rgb(102, 51, 153)
  String get rebeccaPurple => _chalk.rebeccaPurple(this);

  /// set background color to X11 color rebeccaPurple ![rgb(102, 51, 153)](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28102,51,153%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x663399)/rgb(102, 51, 153)
  String get onRebeccaPurple => _chalk.onRebeccaPurple(this);

  /// set foreground color to X11/CSS color redX11 ![red](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF0000)/rgb(255, 0, 0)
  String get redX11 => _chalk.redX11(this);

  /// set background color to X11/CSS color redX11 ![red](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,0,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF0000)/rgb(255, 0, 0)
  String get onRedX11 => _chalk.onRedX11(this);

  /// set foreground color to X11/CSS color rosyBrown ![rosybrown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28188,143,143%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xBC8F8F)/rgb(188, 143, 143)
  String get rosyBrown => _chalk.rosyBrown(this);

  /// set background color to X11/CSS color rosyBrown ![rosybrown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28188,143,143%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xBC8F8F)/rgb(188, 143, 143)
  String get onRosyBrown => _chalk.onRosyBrown(this);

  /// set foreground color to X11/CSS color royalBlue ![royalblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2865,105,225%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x4169E1)/rgb(65, 105, 225)
  String get royalBlue => _chalk.royalBlue(this);

  /// set background color to X11/CSS color royalBlue ![royalblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2865,105,225%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x4169E1)/rgb(65, 105, 225)
  String get onRoyalBlue => _chalk.onRoyalBlue(this);

  /// set foreground color to X11/CSS color saddleBrown ![saddlebrown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28139,69,19%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8B4513)/rgb(139, 69, 19)
  String get saddleBrown => _chalk.saddleBrown(this);

  /// set background color to X11/CSS color saddleBrown ![saddlebrown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28139,69,19%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x8B4513)/rgb(139, 69, 19)
  String get onSaddleBrown => _chalk.onSaddleBrown(this);

  /// set foreground color to X11/CSS color salmon ![salmon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,128,114%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFA8072)/rgb(250, 128, 114)
  String get salmon => _chalk.salmon(this);

  /// set background color to X11/CSS color salmon ![salmon](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28250,128,114%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFA8072)/rgb(250, 128, 114)
  String get onSalmon => _chalk.onSalmon(this);

  /// set foreground color to X11/CSS color sandyBrown ![sandybrown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28244,164,96%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF4A460)/rgb(244, 164, 96)
  String get sandyBrown => _chalk.sandyBrown(this);

  /// set background color to X11/CSS color sandyBrown ![sandybrown](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28244,164,96%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF4A460)/rgb(244, 164, 96)
  String get onSandyBrown => _chalk.onSandyBrown(this);

  /// set foreground color to X11/CSS color seaGreen ![seagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2846,139,87%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x2E8B57)/rgb(46, 139, 87)
  String get seaGreen => _chalk.seaGreen(this);

  /// set background color to X11/CSS color seaGreen ![seagreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2846,139,87%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x2E8B57)/rgb(46, 139, 87)
  String get onSeaGreen => _chalk.onSeaGreen(this);

  /// set foreground color to X11/CSS color seashell ![seashell](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,245,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFF5EE)/rgb(255, 245, 238)
  String get seashell => _chalk.seashell(this);

  /// set background color to X11/CSS color seashell ![seashell](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,245,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFF5EE)/rgb(255, 245, 238)
  String get onSeashell => _chalk.onSeashell(this);

  /// set foreground color to X11/CSS color sienna ![sienna](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28160,82,45%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA0522D)/rgb(160, 82, 45)
  String get sienna => _chalk.sienna(this);

  /// set background color to X11/CSS color sienna ![sienna](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28160,82,45%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xA0522D)/rgb(160, 82, 45)
  String get onSienna => _chalk.onSienna(this);

  /// set foreground color to X11/CSS color silver ![silver](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28192,192,192%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xC0C0C0)/rgb(192, 192, 192)
  String get silver => _chalk.silver(this);

  /// set background color to X11/CSS color silver ![silver](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28192,192,192%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xC0C0C0)/rgb(192, 192, 192)
  String get onSilver => _chalk.onSilver(this);

  /// set foreground color to X11/CSS color skyBlue ![skyblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28135,206,235%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x87CEEB)/rgb(135, 206, 235)
  String get skyBlue => _chalk.skyBlue(this);

  /// set background color to X11/CSS color skyBlue ![skyblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28135,206,235%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x87CEEB)/rgb(135, 206, 235)
  String get onSkyBlue => _chalk.onSkyBlue(this);

  /// set foreground color to X11/CSS color slateBlue ![slateblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28106,90,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x6A5ACD)/rgb(106, 90, 205)
  String get slateBlue => _chalk.slateBlue(this);

  /// set background color to X11/CSS color slateBlue ![slateblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28106,90,205%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x6A5ACD)/rgb(106, 90, 205)
  String get onSlateBlue => _chalk.onSlateBlue(this);

  /// set foreground color to X11/CSS color slateGray ![slategray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28112,128,144%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x708090)/rgb(112, 128, 144)
  String get slateGray => _chalk.slateGray(this);

  /// set background color to X11/CSS color slateGray ![slategray](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28112,128,144%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x708090)/rgb(112, 128, 144)
  String get onSlateGray => _chalk.onSlateGray(this);

  /// set foreground color to X11/CSS color slateGrey ![slategrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28112,128,144%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x708090)/rgb(112, 128, 144)
  String get slateGrey => _chalk.slateGrey(this);

  /// set background color to X11/CSS color slateGrey ![slategrey](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28112,128,144%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x708090)/rgb(112, 128, 144)
  String get onSlateGrey => _chalk.onSlateGrey(this);

  /// set foreground color to X11/CSS color snow ![snow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,250,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFAFA)/rgb(255, 250, 250)
  String get snow => _chalk.snow(this);

  /// set background color to X11/CSS color snow ![snow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,250,250%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFAFA)/rgb(255, 250, 250)
  String get onSnow => _chalk.onSnow(this);

  /// set foreground color to X11/CSS color springGreen ![springgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,127%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FF7F)/rgb(0, 255, 127)
  String get springGreen => _chalk.springGreen(this);

  /// set background color to X11/CSS color springGreen ![springgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,255,127%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x00FF7F)/rgb(0, 255, 127)
  String get onSpringGreen => _chalk.onSpringGreen(this);

  /// set foreground color to X11/CSS color steelBlue ![steelblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2870,130,180%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x4682B4)/rgb(70, 130, 180)
  String get steelBlue => _chalk.steelBlue(this);

  /// set background color to X11/CSS color steelBlue ![steelblue](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2870,130,180%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x4682B4)/rgb(70, 130, 180)
  String get onSteelBlue => _chalk.onSteelBlue(this);

  /// set foreground color to X11/CSS color tan ![tan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28210,180,140%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD2B48C)/rgb(210, 180, 140)
  String get tan => _chalk.tan(this);

  /// set background color to X11/CSS color tan ![tan](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28210,180,140%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD2B48C)/rgb(210, 180, 140)
  String get onTan => _chalk.onTan(this);

  /// set foreground color to X11/CSS color teal ![teal](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x008080)/rgb(0, 128, 128)
  String get teal => _chalk.teal(this);

  /// set background color to X11/CSS color teal ![teal](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%280,128,128%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x008080)/rgb(0, 128, 128)
  String get onTeal => _chalk.onTeal(this);

  /// set foreground color to X11/CSS color thistle ![thistle](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28216,191,216%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD8BFD8)/rgb(216, 191, 216)
  String get thistle => _chalk.thistle(this);

  /// set background color to X11/CSS color thistle ![thistle](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28216,191,216%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xD8BFD8)/rgb(216, 191, 216)
  String get onThistle => _chalk.onThistle(this);

  /// set foreground color to X11/CSS color tomato ![tomato](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,99,71%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF6347)/rgb(255, 99, 71)
  String get tomato => _chalk.tomato(this);

  /// set background color to X11/CSS color tomato ![tomato](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,99,71%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFF6347)/rgb(255, 99, 71)
  String get onTomato => _chalk.onTomato(this);

  /// set foreground color to X11/CSS color turquoise ![turquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2864,224,208%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x40E0D0)/rgb(64, 224, 208)
  String get turquoise => _chalk.turquoise(this);

  /// set background color to X11/CSS color turquoise ![turquoise](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%2864,224,208%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x40E0D0)/rgb(64, 224, 208)
  String get onTurquoise => _chalk.onTurquoise(this);

  /// set foreground color to X11/CSS color violet ![violet](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28238,130,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xEE82EE)/rgb(238, 130, 238)
  String get violet => _chalk.violet(this);

  /// set background color to X11/CSS color violet ![violet](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28238,130,238%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xEE82EE)/rgb(238, 130, 238)
  String get onViolet => _chalk.onViolet(this);

  /// set foreground color to X11/CSS color wheat ![wheat](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,222,179%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5DEB3)/rgb(245, 222, 179)
  String get wheat => _chalk.wheat(this);

  /// set background color to X11/CSS color wheat ![wheat](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,222,179%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5DEB3)/rgb(245, 222, 179)
  String get onWheat => _chalk.onWheat(this);

  /// set foreground color to X11/CSS color whiteX11 ![white](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFFFF)/rgb(255, 255, 255)
  String get whiteX11 => _chalk.whiteX11(this);

  /// set background color to X11/CSS color whiteX11 ![white](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,255%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFFFF)/rgb(255, 255, 255)
  String get onWhiteX11 => _chalk.onWhiteX11(this);

  /// set foreground color to X11/CSS color whiteSmoke ![whitesmoke](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,245,245%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5F5F5)/rgb(245, 245, 245)
  String get whiteSmoke => _chalk.whiteSmoke(this);

  /// set background color to X11/CSS color whiteSmoke ![whitesmoke](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28245,245,245%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xF5F5F5)/rgb(245, 245, 245)
  String get onWhiteSmoke => _chalk.onWhiteSmoke(this);

  /// set foreground color to X11/CSS color yellowX11 ![yellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFF00)/rgb(255, 255, 0)
  String get yellowX11 => _chalk.yellowX11(this);

  /// set background color to X11/CSS color yellowX11 ![yellow](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28255,255,0%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0xFFFF00)/rgb(255, 255, 0)
  String get onYellowX11 => _chalk.onYellowX11(this);

  /// set foreground color to X11/CSS color yellowGreen ![yellowgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28154,205,50%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9ACD32)/rgb(154, 205, 50)
  String get yellowGreen => _chalk.yellowGreen(this);

  /// set background color to X11/CSS color yellowGreen ![yellowgreen](data:image/svg+xml,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20width='32'%20height='32'%3E%3Crect%20width='32'%20height='32'%20fill='rgb%28154,205,50%29'%20stroke='black'%20stroke-width='2'/%3E%3C/svg%3E|width=32,height=32) (0x9ACD32)/rgb(154, 205, 50)
  String get onYellowGreen => _chalk.onYellowGreen(this);
}

// END GENERATED CODE - DO NOT MODIFY BY HAND - generating code => /examples/makeX11EntryPoints.dart
