package com.yogeshpaliyal.deepr.backup

import com.opencsv.CSVWriter
import com.yogeshpaliyal.deepr.ListDeeprWithTagsAsc
import com.yogeshpaliyal.deepr.util.Constants
import java.io.OutputStream

class CsvWriter {
    fun writeToCsv(
        outputStream: OutputStream,
        data: List<ListDeeprWithTagsAsc>,
    ) {
        outputStream.bufferedWriter().use { writer ->
            // Write Header
            CSVWriter(writer).use { csvWriter ->
                // Write Header
                csvWriter.writeNext(
                    arrayOf(
                        Constants.Header.LINK,
                        Constants.Header.CREATED_AT,
                        Constants.Header.OPENED_COUNT,
                        Constants.Header.NAME,
                        Constants.Header.NOTES,
                        Constants.Header.TAGS,
                        Constants.Header.THUMBNAIL,
                        Constants.Header.IS_FAVOURITE,
                    ),
                )
                // Write Data
                data.forEach { item ->
                    csvWriter.writeNext(
                        arrayOf(
                            item.link,
                            item.createdAt,
                            item.openedCount.toString(),
                            item.name,
                            item.notes,
                            item.tagsNames ?: "",
                            item.thumbnail,
                            item.isFavourite.toString(),
                        ),
                    )
                }
            }
        }
    }
}
