# Prayer mode

<p align="center">
<img src="./icon.png" alt="Prayer mode Logo" width="200"/>
</p>

<p align="center">
<strong>A free, open-source, and privacy-focused Android app for accurate Muslim prayer times and automatic silent prayer periods.</strong>
</p>

<p align="center">
  <a href="https://github.com/prayermode/prayermode/blob/master/LICENSE">
    <img src="https://img.shields.io/badge/License-GPLv3-blue.svg" alt="GPLv3 License" />
  </a>
</p>

## 📋 Table of Contents
- [Features](#-features)
- [Permissions Explained](#-permissions-explained)
- [Privacy Policy](#-privacy-policy)
- [Building from Source](#-building-from-source)
- [Contributing](#-contributing)
- [Donations](#-donations)
- [License](#-license)
- [Contact](#-contact)

## ✨ Features

Set it once, the app does the rest! It works automatically in the background, keeping you informed via notifications.

**Customize Your Prayer Settings:**
*   **Calculation Methods:** Access 23 Prayer Calculation Methods powered by aladhan.com API.
*   **The Five Daily Prayers:** Adjust silent duration for all prayers.
*   **Friday Prayer:** Set silent periods before and after Adhan.
*   **Ramadan Nights:** Customizable durations for Taraweeh and Tahajjud.
*   **Eid Prayers:** Customizable time and silent duration for Eid al-Fitr and Eid al-Adha.
*   **Smart Location Detection:** Automatically adjusts prayer times based on your precise location and reschedule DND mode for the next prayers.

**Notifications:**
*   Alerts for Do Not Disturb activation and deactivation at each prayer.
*   Notification of time adjustments when travelling.
*   Reminder for Fajr time, Dhuhr on Friday, and the start of Imsak during Ramadan.

**Design & Usability:**
*   Comfortable and user-friendly interface with Light and Dark modes.
*   Prayer mode Quick Settings Tile for faster access.
*   Accurate Prayer Times calculated using the reliable Aladhan.com API.
*   Open Source & Transparent: Every line of code is public for full transparency and trust.
*   Privacy First: No tracking, no ads, no data collection. Your location and data never leave your device.
*   Lightweight: Minimal battery and data usage.

## 🔐 Permissions Explained

This app requests the following permissions **only for its core functionality**. We believe in transparency and privacy: no data is collected, stored, or transmitted from your device.

*   **Location (Precise & Background)**
    To calculate accurate prayer times based on your exact location. This includes background access to keep prayer times updated. *Processed solely on your device; never stored or shared.*

*   **Do Not Disturb (DND) Access**
    To automatically and respectfully silence notifications during prayer times, helping you focus. *We do not access or read your notification content.*

*   **Notifications**
    To deliver important and timely alerts, such as prayer time reminders, DND status changes, and travel alerts.

*   **Alarms & Reminders**
    To set and trigger precise alerts for prayer times on your device.

*   **Internet Access**
    Used only to fetch calculation data from the trusted [Aladhan.com API](https://aladhan.com/). *No personal data is sent.*

**We do not collect, store, or transmit any personal data.** For more details, please read our full [Privacy Policy](https://prayermode.github.io/prayermode/privacy.html).

## 🛠 Building from Source

If you are a developer and want to build the app yourself:

1.  Clone this repository:
    ```bash
    git clone https://github.com/prayermode/prayermode.git
    ```
2.  Open the project in **Android Studio**.
3.  Build and run the project on your device or emulator.

## 🤝 Contributing

Contributions are welcome and greatly appreciated! Prayer mode is built by the community, for the community.

You can help by:
*   Reporting bugs or suggesting new features by [opening an issue](https://github.com/prayermode/prayermode/issues).
*   Submitting code fixes or new translations via a Pull Request.
*   Helping to translate the app into more languages.

Please read our [Contributing Guidelines](CONTRIBUTING.md) for details.

## ❤️ Donations

Prayer mode is completely free and open source. Developing and maintaining it requires time and effort.

If you find this app valuable and would like to support its continued development, consider making a voluntary donation. All donations are greatly appreciated and will help ensure the app remains free and updated for everyone.

**Donations are voluntary and non-refundable.**

| Platform | Link |
| :--- | :--- |
| **PayPal** | [https://www.paypal.me/prayermode](https://www.paypal.me/prayermode) |
| **GitHub Sponsors** | [https://github.com/sponsors/prayermode](https://github.com/sponsors/prayermode) |

## 📄 License

This project is licensed under the **GNU General Public License v3.0**. See the [LICENSE](LICENSE) file for full details.

This means you are free to use, modify, and distribute this software, but any derivative works must also be open-sourced under the same license.

## 📞 Contact

For questions, support, or to report a bug, please:

1.  First check the [existing issues](https://github.com/prayermode/prayermode/issues).
2.  If your issue is new, you can open a new issue on GitHub.

3.  You can also email us at: [prayer.mode@outlook.com](mailto:prayer.mode@outlook.com)


