# Contributing to Prayer Mode

First off, thank you for considering contributing to Prayer mode! It's people like you that make this app better for everyone.

## How Can I Help?

There are several ways you can contribute:

*   **Report a Bug:** Open an issue to let us know about something that's not working.
*   **Suggest a Feature:** Have an idea to make the app better? Open an issue and let's discuss it.
*   **Write Code:** Fix a bug or implement a new feature yourself.
*   **Translate:** Help translate the app into more languages.

## How to Contribute

1.  **Fork the Project:** Click the 'Fork' button at the top of this repository to create your own copy.
2.  **Create a Branch:** Create a new branch for your feature or fix (`git checkout -b feature/AmazingFeature`).
3.  **Make Your Changes:** Write your code or add your translations.
4.  **Test Your Changes:** Ensure your changes work correctly.
5.  **Commit Your Changes:** Write a clear commit message (`git commit -m 'Add some AmazingFeature'`).
6.  **Push to the Branch:** Push your changes to your forked repository (`git push origin feature/AmazingFeature`).
7.  **Open a Pull Request:** Go to the original repository and open a Pull Request. Describe your changes clearly.

## Code Guidelines

*   Please try to follow the existing code style you see in the project.
*   Keep your changes focused. A Pull Request should ideally address one specific thing.

## Reporting Bugs

When reporting an issue, please include:
*   Your device model and Android version.
*   Steps to reproduce the bug.
*   What you expected to happen.
*   What actually happened.

## Translating

Translations are managed in the app's `res/values-*` directories. Please submit a Pull Request with the new or updated strings.

Thanks again for your help!