/*
 * Copyright (C) 2019, 2023 Axel Paetzold
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.yacgroup.yacguide.network

import com.yacgroup.yacguide.ClimbingObjectUId

enum class RequestType {
    COUNTRY_DATA,
    REGION_DATA,
    SECTOR_DATA,
    ROCK_DATA,
    ROUTE_DATA,
    REGION_COMMENTS,
    SECTOR_COMMENTS
}

data class NetworkRequest(
    val uid: ClimbingObjectUId,
    val type: RequestType,
    val url: String
)
