# Release Process

The release process is based on Git tags and necessary for publishing
the app in the [F-Droid] and [Google Play] store.

The [F-Droid] server checks for new tags in the repo on a regular
basis. If there is new matching tag, the server starts the build and
signing process and makes the app available in the app store with a
delay of around four days.

The actual deployment of the app to the [Google Play] store is done by
the CI, if a matching release tag is pushed to the GitHub repository.
The version will be available in the store with a delay of around one
day.

To create a release tag, do the following steps:

1. Change into the `master` branch and sync your branch with the
   remote repository.
2. For a **stable** release, add/update file `vX.Y.Z.md` in directory
   [release notes directory](_release-notes). Summarize the changes in
   **German** made since the last release and reference
   the corresponding issue or pull request, as shown in the example
   below:
   ```markdown
   ## Neuigkeiten und Änderungen

   * Zeige alternative Sektor- und and Wegnamen ([#167](https://github.com/YacGroup/yacguide/issues/167))
   * Zeige den Fortschritt während eines Datenbank-Updates ([#106](https://github.com/YacGroup/yacguide/issues/106))

   ## Behobene Fehler

   * Crash während des Tourenbuch-Imports und Benutzung von Android 10 ([#166](https://github.com/YacGroup/yacguide/issues/166))
   * Falsche Formatierung der Wegbeschreibung ([#153](https://github.com/YacGroup/yacguide/issues/153))
   ```
3. The release notes are not compiled into the app but a link to the
   GitHub website is added. However, important notes can directly be
   shown during the app start when placing a Markdown file with the
   release tag name into the corresponding asserts directory
   `app/app/src/{main|dev}/assets/release-notes`.
4. Make sure that your Git status is clean, e.g. that you have no
   uncommitted or untracked items.
5. Run one of the following commands to create either a development or
   stable release and follow the instruction of the script output.
   ```shell
   scripts/make release --type dev [--version YYYYMMDD]
   scripts/make release --type stable --version X.Y.Z
   ```
6. Wait that the CI passes.
7. The release notes for the **development** release are handled on
   the [GitHub releases] page. A draft version is automatically
   assembled by the [Releases Drafter] GitHub Action, if a pull
   request is merged into the master. Therefore review the notes,
   rename the draft title accordingly and assign the correct tag name.
8. For completeness, the **English** version of change log is also
   published on the [GitHub releases] page. However, it can be
   pre-generated by creating a release and hitting the button
   `auto-generate release notes`. Afterwards summarize the notes and
   publish the release.

[F-Droid]: https://f-droid.org
[Google Play]: https://play.google.com
[GitHub releases]: https://github.com/yacgroup/yacguide/releases
[Releases Drafter]: https://github.com/release-drafter/release-drafter
