package com.xinto.mauth.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

val SkyCyanLight = lightColorScheme(
    primary = Color(0xFF006A6A),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF9CF1F0),
    onPrimaryContainer = Color(0xFF002020),
    secondary = Color(0xFF4A6363),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFFCCE8E7),
    onSecondaryContainer = Color(0xFF051F1F),
    tertiary = Color(0xFF4B607C),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFFD3E4FF),
    onTertiaryContainer = Color(0xFF041C35),
    error = Color(0xFFBA1A1A),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFFFDAD6),
    onErrorContainer = Color(0xFF410002),
    background = Color(0xFFF4FBFA),
    onBackground = Color(0xFF161D1D),
    surface = Color(0xFFF4FBFA),
    onSurface = Color(0xFF161D1D),
    surfaceVariant = Color(0xFFDAE5E4),
    onSurfaceVariant = Color(0xFF3F4948),
    outline = Color(0xFF6F7979),
    outlineVariant = Color(0xFFBEC9C8),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2B3231),
    inverseOnSurface = Color(0xFFECF2F1),
    inversePrimary = Color(0xFF80D5D4),
    surfaceDim = Color(0xFFD5DBDA),
    surfaceBright = Color(0xFFF4FBFA),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFEFF5F4),
    surfaceContainer = Color(0xFFE9EFEE),
    surfaceContainerHigh = Color(0xFFE3E9E9),
    surfaceContainerHighest = Color(0xFFDDE4E3),
)

val SkyCyanLightMediumContrast = lightColorScheme(
    primary = Color(0xFF004B4B),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF238181),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF2E4747),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF5F7979),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF2F445F),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF617693),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF8C0009),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFDA342E),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFF4FBFA),
    onBackground = Color(0xFF161D1D),
    surface = Color(0xFFF4FBFA),
    onSurface = Color(0xFF161D1D),
    surfaceVariant = Color(0xFFDAE5E4),
    onSurfaceVariant = Color(0xFF3B4544),
    outline = Color(0xFF576161),
    outlineVariant = Color(0xFF737D7C),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2B3231),
    inverseOnSurface = Color(0xFFECF2F1),
    inversePrimary = Color(0xFF80D5D4),
    surfaceDim = Color(0xFFD5DBDA),
    surfaceBright = Color(0xFFF4FBFA),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFEFF5F4),
    surfaceContainer = Color(0xFFE9EFEE),
    surfaceContainerHigh = Color(0xFFE3E9E9),
    surfaceContainerHighest = Color(0xFFDDE4E3),
)

val SkyCyanLightHighContrast = lightColorScheme(
    primary = Color(0xFF002727),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF004B4B),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF0C2626),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF2E4747),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF0C233C),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF2F445F),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF4E0002),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFF8C0009),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFF4FBFA),
    onBackground = Color(0xFF161D1D),
    surface = Color(0xFFF4FBFA),
    onSurface = Color(0xFF000000),
    surfaceVariant = Color(0xFFDAE5E4),
    onSurfaceVariant = Color(0xFF1C2625),
    outline = Color(0xFF3B4544),
    outlineVariant = Color(0xFF3B4544),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2B3231),
    inverseOnSurface = Color(0xFFFFFFFF),
    inversePrimary = Color(0xFFA6FBFA),
    surfaceDim = Color(0xFFD5DBDA),
    surfaceBright = Color(0xFFF4FBFA),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFEFF5F4),
    surfaceContainer = Color(0xFFE9EFEE),
    surfaceContainerHigh = Color(0xFFE3E9E9),
    surfaceContainerHighest = Color(0xFFDDE4E3),
)

val SkyCyanDark = darkColorScheme(
    primary = Color(0xFF80D5D4),
    onPrimary = Color(0xFF003737),
    primaryContainer = Color(0xFF004F4F),
    onPrimaryContainer = Color(0xFF9CF1F0),
    secondary = Color(0xFFB0CCCB),
    onSecondary = Color(0xFF1B3534),
    secondaryContainer = Color(0xFF324B4B),
    onSecondaryContainer = Color(0xFFCCE8E7),
    tertiary = Color(0xFFB3C8E8),
    onTertiary = Color(0xFF1C314B),
    tertiaryContainer = Color(0xFF334863),
    onTertiaryContainer = Color(0xFFD3E4FF),
    error = Color(0xFFFFB4AB),
    onError = Color(0xFF690005),
    errorContainer = Color(0xFF93000A),
    onErrorContainer = Color(0xFFFFDAD6),
    background = Color(0xFF0E1514),
    onBackground = Color(0xFFDDE4E3),
    surface = Color(0xFF0E1514),
    onSurface = Color(0xFFDDE4E3),
    surfaceVariant = Color(0xFF3F4948),
    onSurfaceVariant = Color(0xFFBEC9C8),
    outline = Color(0xFF889392),
    outlineVariant = Color(0xFF3F4948),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFDDE4E3),
    inverseOnSurface = Color(0xFF2B3231),
    inversePrimary = Color(0xFF006A6A),
    surfaceDim = Color(0xFF0E1514),
    surfaceBright = Color(0xFF343A3A),
    surfaceContainerLowest = Color(0xFF090F0F),
    surfaceContainerLow = Color(0xFF161D1D),
    surfaceContainer = Color(0xFF1A2121),
    surfaceContainerHigh = Color(0xFF252B2B),
    surfaceContainerHighest = Color(0xFF2F3636),
)

val SkyCyanDarkMediumContrast = darkColorScheme(
    primary = Color(0xFF84D9D8),
    onPrimary = Color(0xFF001A1A),
    primaryContainer = Color(0xFF479E9D),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFB5D0CF),
    onSecondary = Color(0xFF001A1A),
    secondaryContainer = Color(0xFF7B9695),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFB7CCED),
    onTertiary = Color(0xFF00172F),
    tertiaryContainer = Color(0xFF7D92B1),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFBAB1),
    onError = Color(0xFF370001),
    errorContainer = Color(0xFFFF5449),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF0E1514),
    onBackground = Color(0xFFDDE4E3),
    surface = Color(0xFF0E1514),
    onSurface = Color(0xFFF6FCFB),
    surfaceVariant = Color(0xFF3F4948),
    onSurfaceVariant = Color(0xFFC2CDCC),
    outline = Color(0xFF9BA5A4),
    outlineVariant = Color(0xFF7B8585),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFDDE4E3),
    inverseOnSurface = Color(0xFF252B2B),
    inversePrimary = Color(0xFF005151),
    surfaceDim = Color(0xFF0E1514),
    surfaceBright = Color(0xFF343A3A),
    surfaceContainerLowest = Color(0xFF090F0F),
    surfaceContainerLow = Color(0xFF161D1D),
    surfaceContainer = Color(0xFF1A2121),
    surfaceContainerHigh = Color(0xFF252B2B),
    surfaceContainerHighest = Color(0xFF2F3636),
)

val SkyCyanDarkHighContrast = darkColorScheme(
    primary = Color(0xFFEAFFFE),
    onPrimary = Color(0xFF000000),
    primaryContainer = Color(0xFF84D9D8),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFEAFFFE),
    onSecondary = Color(0xFF000000),
    secondaryContainer = Color(0xFFB5D0CF),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFFAFAFF),
    onTertiary = Color(0xFF000000),
    tertiaryContainer = Color(0xFFB7CCED),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFF9F9),
    onError = Color(0xFF000000),
    errorContainer = Color(0xFFFFBAB1),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF0E1514),
    onBackground = Color(0xFFDDE4E3),
    surface = Color(0xFF0E1514),
    onSurface = Color(0xFFFFFFFF),
    surfaceVariant = Color(0xFF3F4948),
    onSurfaceVariant = Color(0xFFF3FDFC),
    outline = Color(0xFFC2CDCC),
    outlineVariant = Color(0xFFC2CDCC),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFDDE4E3),
    inverseOnSurface = Color(0xFF000000),
    inversePrimary = Color(0xFF003030),
    surfaceDim = Color(0xFF0E1514),
    surfaceBright = Color(0xFF343A3A),
    surfaceContainerLowest = Color(0xFF090F0F),
    surfaceContainerLow = Color(0xFF161D1D),
    surfaceContainer = Color(0xFF1A2121),
    surfaceContainerHigh = Color(0xFF252B2B),
    surfaceContainerHighest = Color(0xFF2F3636),
)

val SkyCyan = Color(0xFF00FFFF)