package com.xinto.mauth.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

val LimeGreenLight = lightColorScheme(
    primary = Color(0xFF406836),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFFC0EFB0),
    onPrimaryContainer = Color(0xFF002200),
    secondary = Color(0xFF54634D),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFFD7E8CD),
    onSecondaryContainer = Color(0xFF121F0E),
    tertiary = Color(0xFF386568),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFFBCEBEE),
    onTertiaryContainer = Color(0xFF002022),
    error = Color(0xFFBA1A1A),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFFFDAD6),
    onErrorContainer = Color(0xFF410002),
    background = Color(0xFFF8FBF1),
    onBackground = Color(0xFF191D17),
    surface = Color(0xFFF8FBF1),
    onSurface = Color(0xFF191D17),
    surfaceVariant = Color(0xFFDFE4D7),
    onSurfaceVariant = Color(0xFF43483F),
    outline = Color(0xFF73796E),
    outlineVariant = Color(0xFFC3C8BC),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2E322B),
    inverseOnSurface = Color(0xFFEFF2E8),
    inversePrimary = Color(0xFFA5D395),
    surfaceDim = Color(0xFFD8DBD2),
    surfaceBright = Color(0xFFF8FBF1),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF2F5EB),
    surfaceContainer = Color(0xFFECEFE5),
    surfaceContainerHigh = Color(0xFFE6E9E0),
    surfaceContainerHighest = Color(0xFFE1E4DA),
)

val LimeGreenLightMediumContrast = lightColorScheme(
    primary = Color(0xFF244B1D),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF557F4A),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF394733),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF6A7963),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF19494C),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF4F7C7F),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF8C0009),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFDA342E),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFF8FBF1),
    onBackground = Color(0xFF191D17),
    surface = Color(0xFFF8FBF1),
    onSurface = Color(0xFF191D17),
    surfaceVariant = Color(0xFFDFE4D7),
    onSurfaceVariant = Color(0xFF3F453B),
    outline = Color(0xFF5B6157),
    outlineVariant = Color(0xFF777D72),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2E322B),
    inverseOnSurface = Color(0xFFEFF2E8),
    inversePrimary = Color(0xFFA5D395),
    surfaceDim = Color(0xFFD8DBD2),
    surfaceBright = Color(0xFFF8FBF1),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF2F5EB),
    surfaceContainer = Color(0xFFECEFE5),
    surfaceContainerHigh = Color(0xFFE6E9E0),
    surfaceContainerHighest = Color(0xFFE1E4DA),
)

val LimeGreenLightHighContrast = lightColorScheme(
    primary = Color(0xFF022901),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF244B1D),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF182614),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF394733),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF002729),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF19494C),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF4E0002),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFF8C0009),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFF8FBF1),
    onBackground = Color(0xFF191D17),
    surface = Color(0xFFF8FBF1),
    onSurface = Color(0xFF000000),
    surfaceVariant = Color(0xFFDFE4D7),
    onSurfaceVariant = Color(0xFF20251D),
    outline = Color(0xFF3F453B),
    outlineVariant = Color(0xFF3F453B),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2E322B),
    inverseOnSurface = Color(0xFFFFFFFF),
    inversePrimary = Color(0xFFCAF9B8),
    surfaceDim = Color(0xFFD8DBD2),
    surfaceBright = Color(0xFFF8FBF1),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF2F5EB),
    surfaceContainer = Color(0xFFECEFE5),
    surfaceContainerHigh = Color(0xFFE6E9E0),
    surfaceContainerHighest = Color(0xFFE1E4DA),
)

val LimeGreenDark = darkColorScheme(
    primary = Color(0xFFA5D395),
    onPrimary = Color(0xFF11380B),
    primaryContainer = Color(0xFF285020),
    onPrimaryContainer = Color(0xFFC0EFB0),
    secondary = Color(0xFFBBCBB2),
    onSecondary = Color(0xFF263422),
    secondaryContainer = Color(0xFF3C4B37),
    onSecondaryContainer = Color(0xFFD7E8CD),
    tertiary = Color(0xFFA0CFD2),
    onTertiary = Color(0xFF003739),
    tertiaryContainer = Color(0xFF1E4D50),
    onTertiaryContainer = Color(0xFFBCEBEE),
    error = Color(0xFFFFB4AB),
    onError = Color(0xFF690005),
    errorContainer = Color(0xFF93000A),
    onErrorContainer = Color(0xFFFFDAD6),
    background = Color(0xFF11140F),
    onBackground = Color(0xFFE1E4DA),
    surface = Color(0xFF11140F),
    onSurface = Color(0xFFE1E4DA),
    surfaceVariant = Color(0xFF43483F),
    onSurfaceVariant = Color(0xFFC3C8BC),
    outline = Color(0xFF8D9387),
    outlineVariant = Color(0xFF43483F),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE1E4DA),
    inverseOnSurface = Color(0xFF2E322B),
    inversePrimary = Color(0xFF406836),
    surfaceDim = Color(0xFF11140F),
    surfaceBright = Color(0xFF363A34),
    surfaceContainerLowest = Color(0xFF0C0F0A),
    surfaceContainerLow = Color(0xFF191D17),
    surfaceContainer = Color(0xFF1D211B),
    surfaceContainerHigh = Color(0xFF272B25),
    surfaceContainerHighest = Color(0xFF32362F),
)

val LimeGreenDarkMediumContrast = darkColorScheme(
    primary = Color(0xFFA9D799),
    onPrimary = Color(0xFF001C00),
    primaryContainer = Color(0xFF719C64),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFBFD0B6),
    onSecondary = Color(0xFF0D1909),
    secondaryContainer = Color(0xFF86957E),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFA4D3D6),
    onTertiary = Color(0xFF001A1B),
    tertiaryContainer = Color(0xFF6B989B),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFBAB1),
    onError = Color(0xFF370001),
    errorContainer = Color(0xFFFF5449),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF11140F),
    onBackground = Color(0xFFE1E4DA),
    surface = Color(0xFF11140F),
    onSurface = Color(0xFFF9FCF2),
    surfaceVariant = Color(0xFF43483F),
    onSurfaceVariant = Color(0xFFC7CDC0),
    outline = Color(0xFF9FA599),
    outlineVariant = Color(0xFF7F857A),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE1E4DA),
    inverseOnSurface = Color(0xFF272B25),
    inversePrimary = Color(0xFF2A5121),
    surfaceDim = Color(0xFF11140F),
    surfaceBright = Color(0xFF363A34),
    surfaceContainerLowest = Color(0xFF0C0F0A),
    surfaceContainerLow = Color(0xFF191D17),
    surfaceContainer = Color(0xFF1D211B),
    surfaceContainerHigh = Color(0xFF272B25),
    surfaceContainerHighest = Color(0xFF32362F),
)

val LimeGreenDarkHighContrast = darkColorScheme(
    primary = Color(0xFFF2FFE7),
    onPrimary = Color(0xFF000000),
    primaryContainer = Color(0xFFA9D799),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFF2FFE7),
    onSecondary = Color(0xFF000000),
    secondaryContainer = Color(0xFFBFD0B6),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFECFEFF),
    onTertiary = Color(0xFF000000),
    tertiaryContainer = Color(0xFFA4D3D6),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFF9F9),
    onError = Color(0xFF000000),
    errorContainer = Color(0xFFFFBAB1),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF11140F),
    onBackground = Color(0xFFE1E4DA),
    surface = Color(0xFF11140F),
    onSurface = Color(0xFFFFFFFF),
    surfaceVariant = Color(0xFF43483F),
    onSurfaceVariant = Color(0xFFF7FDEF),
    outline = Color(0xFFC7CDC0),
    outlineVariant = Color(0xFFC7CDC0),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE1E4DA),
    inverseOnSurface = Color(0xFF000000),
    inversePrimary = Color(0xFF0A3105),
    surfaceDim = Color(0xFF11140F),
    surfaceBright = Color(0xFF363A34),
    surfaceContainerLowest = Color(0xFF0C0F0A),
    surfaceContainerLow = Color(0xFF191D17),
    surfaceContainer = Color(0xFF1D211B),
    surfaceContainerHigh = Color(0xFF272B25),
    surfaceContainerHighest = Color(0xFF32362F),
)

val LimeGreen = Color(0xFF00FF00)