package com.xinto.mauth.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

val LemonYellowLight = lightColorScheme(
    primary = Color(0xFF616118),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFFE8E78F),
    onPrimaryContainer = Color(0xFF1D1D00),
    secondary = Color(0xFF606043),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFFE7E4BF),
    onSecondaryContainer = Color(0xFF1D1D06),
    tertiary = Color(0xFF3D6657),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFFBFECD8),
    onTertiaryContainer = Color(0xFF002117),
    error = Color(0xFFBA1A1A),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFFFDAD6),
    onErrorContainer = Color(0xFF410002),
    background = Color(0xFFFDF9EC),
    onBackground = Color(0xFF1C1C14),
    surface = Color(0xFFFDF9EC),
    onSurface = Color(0xFF1C1C14),
    surfaceVariant = Color(0xFFE6E3D1),
    onSurfaceVariant = Color(0xFF48473A),
    outline = Color(0xFF797869),
    outlineVariant = Color(0xFFCAC7B6),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF313128),
    inverseOnSurface = Color(0xFFF4F1E3),
    inversePrimary = Color(0xFFCBCB76),
    surfaceDim = Color(0xFFDDDACD),
    surfaceBright = Color(0xFFFDF9EC),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF7F4E6),
    surfaceContainer = Color(0xFFF1EEE0),
    surfaceContainerHigh = Color(0xFFECE8DB),
    surfaceContainerHighest = Color(0xFFE6E3D5),
)

val LemonYellowLightMediumContrast = lightColorScheme(
    primary = Color(0xFF454500),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF78782D),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF454429),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF777657),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF214A3C),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF537D6C),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF8C0009),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFDA342E),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFFDF9EC),
    onBackground = Color(0xFF1C1C14),
    surface = Color(0xFFFDF9EC),
    onSurface = Color(0xFF1C1C14),
    surfaceVariant = Color(0xFFE6E3D1),
    onSurfaceVariant = Color(0xFF444336),
    outline = Color(0xFF616052),
    outlineVariant = Color(0xFF7D7B6C),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF313128),
    inverseOnSurface = Color(0xFFF4F1E3),
    inversePrimary = Color(0xFFCBCB76),
    surfaceDim = Color(0xFFDDDACD),
    surfaceBright = Color(0xFFFDF9EC),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF7F4E6),
    surfaceContainer = Color(0xFFF1EEE0),
    surfaceContainerHigh = Color(0xFFECE8DB),
    surfaceContainerHighest = Color(0xFFE6E3D5),
)

val LemonYellowLightHighContrast = lightColorScheme(
    primary = Color(0xFF242400),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF454500),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF23230B),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF454429),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF00281C),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF214A3C),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF4E0002),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFF8C0009),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFFDF9EC),
    onBackground = Color(0xFF1C1C14),
    surface = Color(0xFFFDF9EC),
    onSurface = Color(0xFF000000),
    surfaceVariant = Color(0xFFE6E3D1),
    onSurfaceVariant = Color(0xFF252419),
    outline = Color(0xFF444336),
    outlineVariant = Color(0xFF444336),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF313128),
    inverseOnSurface = Color(0xFFFFFFFF),
    inversePrimary = Color(0xFFF2F198),
    surfaceDim = Color(0xFFDDDACD),
    surfaceBright = Color(0xFFFDF9EC),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF7F4E6),
    surfaceContainer = Color(0xFFF1EEE0),
    surfaceContainerHigh = Color(0xFFECE8DB),
    surfaceContainerHighest = Color(0xFFE6E3D5),
)

val LemonYellowDark = darkColorScheme(
    primary = Color(0xFFCBCB76),
    onPrimary = Color(0xFF323200),
    primaryContainer = Color(0xFF494900),
    onPrimaryContainer = Color(0xFFE8E78F),
    secondary = Color(0xFFCAC8A5),
    onSecondary = Color(0xFF323218),
    secondaryContainer = Color(0xFF49482D),
    onSecondaryContainer = Color(0xFFE7E4BF),
    tertiary = Color(0xFFA4D0BD),
    onTertiary = Color(0xFF0B372A),
    tertiaryContainer = Color(0xFF254E40),
    onTertiaryContainer = Color(0xFFBFECD8),
    error = Color(0xFFFFB4AB),
    onError = Color(0xFF690005),
    errorContainer = Color(0xFF93000A),
    onErrorContainer = Color(0xFFFFDAD6),
    background = Color(0xFF14140C),
    onBackground = Color(0xFFE6E3D5),
    surface = Color(0xFF14140C),
    onSurface = Color(0xFFE6E3D5),
    surfaceVariant = Color(0xFF48473A),
    onSurfaceVariant = Color(0xFFCAC7B6),
    outline = Color(0xFF939182),
    outlineVariant = Color(0xFF48473A),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE6E3D5),
    inverseOnSurface = Color(0xFF313128),
    inversePrimary = Color(0xFF616118),
    surfaceDim = Color(0xFF14140C),
    surfaceBright = Color(0xFF3A3A30),
    surfaceContainerLowest = Color(0xFF0F0F07),
    surfaceContainerLow = Color(0xFF1C1C14),
    surfaceContainer = Color(0xFF202018),
    surfaceContainerHigh = Color(0xFF2B2A22),
    surfaceContainerHighest = Color(0xFF36352C),
)

val LemonYellowDarkMediumContrast = darkColorScheme(
    primary = Color(0xFFD0CF7A),
    onPrimary = Color(0xFF171700),
    primaryContainer = Color(0xFF959446),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFCECCA9),
    onSecondary = Color(0xFF171703),
    secondaryContainer = Color(0xFF949272),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFA8D4C1),
    onTertiary = Color(0xFF001B12),
    tertiaryContainer = Color(0xFF6F9A88),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFBAB1),
    onError = Color(0xFF370001),
    errorContainer = Color(0xFFFF5449),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF14140C),
    onBackground = Color(0xFFE6E3D5),
    surface = Color(0xFF14140C),
    onSurface = Color(0xFFFEFBED),
    surfaceVariant = Color(0xFF48473A),
    onSurfaceVariant = Color(0xFFCECBBA),
    outline = Color(0xFFA5A393),
    outlineVariant = Color(0xFF858474),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE6E3D5),
    inverseOnSurface = Color(0xFF2B2A22),
    inversePrimary = Color(0xFF4B4B00),
    surfaceDim = Color(0xFF14140C),
    surfaceBright = Color(0xFF3A3A30),
    surfaceContainerLowest = Color(0xFF0F0F07),
    surfaceContainerLow = Color(0xFF1C1C14),
    surfaceContainer = Color(0xFF202018),
    surfaceContainerHigh = Color(0xFF2B2A22),
    surfaceContainerHighest = Color(0xFF36352C),
)

val LemonYellowDarkHighContrast = darkColorScheme(
    primary = Color(0xFFFFFCDC),
    onPrimary = Color(0xFF000000),
    primaryContainer = Color(0xFFD0CF7A),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFFFFCDC),
    onSecondary = Color(0xFF000000),
    secondaryContainer = Color(0xFFCECCA9),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFEDFFF5),
    onTertiary = Color(0xFF000000),
    tertiaryContainer = Color(0xFFA8D4C1),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFF9F9),
    onError = Color(0xFF000000),
    errorContainer = Color(0xFFFFBAB1),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF14140C),
    onBackground = Color(0xFFE6E3D5),
    surface = Color(0xFF14140C),
    onSurface = Color(0xFFFFFFFF),
    surfaceVariant = Color(0xFF48473A),
    onSurfaceVariant = Color(0xFFFFFBE9),
    outline = Color(0xFFCECBBA),
    outlineVariant = Color(0xFFCECBBA),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE6E3D5),
    inverseOnSurface = Color(0xFF000000),
    inversePrimary = Color(0xFF2C2C00),
    surfaceDim = Color(0xFF14140C),
    surfaceBright = Color(0xFF3A3A30),
    surfaceContainerLowest = Color(0xFF0F0F07),
    surfaceContainerLow = Color(0xFF1C1C14),
    surfaceContainer = Color(0xFF202018),
    surfaceContainerHigh = Color(0xFF2B2A22),
    surfaceContainerHighest = Color(0xFF36352C),
)

val LemonYellow = Color(0xFFFFFF00)