package com.xinto.mauth.ui.theme.color

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

val BlueberryBlueLight = lightColorScheme(
    primary = Color(0xFF475D92),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFFD9E2FF),
    onPrimaryContainer = Color(0xFF001945),
    secondary = Color(0xFF575E71),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFFDCE2F9),
    onSecondaryContainer = Color(0xFF141B2C),
    tertiary = Color(0xFF725572),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFFFDD7FA),
    onTertiaryContainer = Color(0xFF2A132C),
    error = Color(0xFFBA1A1A),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFFFDAD6),
    onErrorContainer = Color(0xFF410002),
    background = Color(0xFFFAF8FF),
    onBackground = Color(0xFF1A1B20),
    surface = Color(0xFFFAF8FF),
    onSurface = Color(0xFF1A1B20),
    surfaceVariant = Color(0xFFE1E2EC),
    onSurfaceVariant = Color(0xFF44464F),
    outline = Color(0xFF757780),
    outlineVariant = Color(0xFFC5C6D0),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2F3036),
    inverseOnSurface = Color(0xFFF1F0F7),
    inversePrimary = Color(0xFFB0C6FF),
    surfaceDim = Color(0xFFDAD9E0),
    surfaceBright = Color(0xFFFAF8FF),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF4F3FA),
    surfaceContainer = Color(0xFFEEEDF4),
    surfaceContainerHigh = Color(0xFFE8E7EF),
    surfaceContainerHighest = Color(0xFFE2E2E9),
)

val BlueberryBlueLightMediumContrast = lightColorScheme(
    primary = Color(0xFF2A4174),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF5D73A9),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF3C4255),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF6E7488),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF553A55),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF8A6A89),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF8C0009),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFFDA342E),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFFAF8FF),
    onBackground = Color(0xFF1A1B20),
    surface = Color(0xFFFAF8FF),
    onSurface = Color(0xFF1A1B20),
    surfaceVariant = Color(0xFFE1E2EC),
    onSurfaceVariant = Color(0xFF40434B),
    outline = Color(0xFF5D5F67),
    outlineVariant = Color(0xFF797A83),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2F3036),
    inverseOnSurface = Color(0xFFF1F0F7),
    inversePrimary = Color(0xFFB0C6FF),
    surfaceDim = Color(0xFFDAD9E0),
    surfaceBright = Color(0xFFFAF8FF),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF4F3FA),
    surfaceContainer = Color(0xFFEEEDF4),
    surfaceContainerHigh = Color(0xFFE8E7EF),
    surfaceContainerHighest = Color(0xFFE2E2E9),
)

val BlueberryBlueLightHighContrast = lightColorScheme(
    primary = Color(0xFF011F51),
    onPrimary = Color(0xFFFFFFFF),
    primaryContainer = Color(0xFF2A4174),
    onPrimaryContainer = Color(0xFFFFFFFF),
    secondary = Color(0xFF1B2233),
    onSecondary = Color(0xFFFFFFFF),
    secondaryContainer = Color(0xFF3C4255),
    onSecondaryContainer = Color(0xFFFFFFFF),
    tertiary = Color(0xFF311933),
    onTertiary = Color(0xFFFFFFFF),
    tertiaryContainer = Color(0xFF553A55),
    onTertiaryContainer = Color(0xFFFFFFFF),
    error = Color(0xFF4E0002),
    onError = Color(0xFFFFFFFF),
    errorContainer = Color(0xFF8C0009),
    onErrorContainer = Color(0xFFFFFFFF),
    background = Color(0xFFFAF8FF),
    onBackground = Color(0xFF1A1B20),
    surface = Color(0xFFFAF8FF),
    onSurface = Color(0xFF000000),
    surfaceVariant = Color(0xFFE1E2EC),
    onSurfaceVariant = Color(0xFF21242B),
    outline = Color(0xFF40434B),
    outlineVariant = Color(0xFF40434B),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFF2F3036),
    inverseOnSurface = Color(0xFFFFFFFF),
    inversePrimary = Color(0xFFE7EBFF),
    surfaceDim = Color(0xFFDAD9E0),
    surfaceBright = Color(0xFFFAF8FF),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF4F3FA),
    surfaceContainer = Color(0xFFEEEDF4),
    surfaceContainerHigh = Color(0xFFE8E7EF),
    surfaceContainerHighest = Color(0xFFE2E2E9),
)

val BlueberryBlueDark = darkColorScheme(

    primary = Color(0xFFB0C6FF),
    onPrimary = Color(0xFF152E60),
    primaryContainer = Color(0xFF2E4578),
    onPrimaryContainer = Color(0xFFD9E2FF),
    secondary = Color(0xFFC0C6DC),
    onSecondary = Color(0xFF293042),
    secondaryContainer = Color(0xFF404659),
    onSecondaryContainer = Color(0xFFDCE2F9),
    tertiary = Color(0xFFE0BBDD),
    onTertiary = Color(0xFF412742),
    tertiaryContainer = Color(0xFF593D5A),
    onTertiaryContainer = Color(0xFFFDD7FA),
    error = Color(0xFFFFB4AB),
    onError = Color(0xFF690005),
    errorContainer = Color(0xFF93000A),
    onErrorContainer = Color(0xFFFFDAD6),
    background = Color(0xFF121318),
    onBackground = Color(0xFFE2E2E9),
    surface = Color(0xFF121318),
    onSurface = Color(0xFFE2E2E9),
    surfaceVariant = Color(0xFF44464F),
    onSurfaceVariant = Color(0xFFC5C6D0),
    outline = Color(0xFF8F9099),
    outlineVariant = Color(0xFF44464F),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE2E2E9),
    inverseOnSurface = Color(0xFF2F3036),
    inversePrimary = Color(0xFF475D92),
    surfaceDim = Color(0xFF121318),
    surfaceBright = Color(0xFF38393F),
    surfaceContainerLowest = Color(0xFF0C0E13),
    surfaceContainerLow = Color(0xFF1A1B20),
    surfaceContainer = Color(0xFF1E1F25),
    surfaceContainerHigh = Color(0xFF282A2F),
    surfaceContainerHighest = Color(0xFF33353A),
)

val DarkBlueberryBlueMediumContrast = darkColorScheme(
    primary = Color(0xFFB6CAFF),
    onPrimary = Color(0xFF00143A),
    primaryContainer = Color(0xFF7A90C8),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFC4CAE1),
    onSecondary = Color(0xFF0F1626),
    secondaryContainer = Color(0xFF8A90A5),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFE4BFE2),
    onTertiary = Color(0xFF240D27),
    tertiaryContainer = Color(0xFFA786A6),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFBAB1),
    onError = Color(0xFF370001),
    errorContainer = Color(0xFFFF5449),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF121318),
    onBackground = Color(0xFFE2E2E9),
    surface = Color(0xFF121318),
    onSurface = Color(0xFFFCFAFF),
    surfaceVariant = Color(0xFF44464F),
    onSurfaceVariant = Color(0xFFC9CAD4),
    outline = Color(0xFFA1A2AC),
    outlineVariant = Color(0xFF81838C),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE2E2E9),
    inverseOnSurface = Color(0xFF282A2F),
    inversePrimary = Color(0xFF304679),
    surfaceDim = Color(0xFF121318),
    surfaceBright = Color(0xFF38393F),
    surfaceContainerLowest = Color(0xFF0C0E13),
    surfaceContainerLow = Color(0xFF1A1B20),
    surfaceContainer = Color(0xFF1E1F25),
    surfaceContainerHigh = Color(0xFF282A2F),
    surfaceContainerHighest = Color(0xFF33353A),
)

val DarkBlueberryBlueHighContrast = darkColorScheme(
    primary = Color(0xFFFCFAFF),
    onPrimary = Color(0xFF000000),
    primaryContainer = Color(0xFFB6CAFF),
    onPrimaryContainer = Color(0xFF000000),
    secondary = Color(0xFFFCFAFF),
    onSecondary = Color(0xFF000000),
    secondaryContainer = Color(0xFFC4CAE1),
    onSecondaryContainer = Color(0xFF000000),
    tertiary = Color(0xFFFFF9FA),
    onTertiary = Color(0xFF000000),
    tertiaryContainer = Color(0xFFE4BFE2),
    onTertiaryContainer = Color(0xFF000000),
    error = Color(0xFFFFF9F9),
    onError = Color(0xFF000000),
    errorContainer = Color(0xFFFFBAB1),
    onErrorContainer = Color(0xFF000000),
    background = Color(0xFF121318),
    onBackground = Color(0xFFE2E2E9),
    surface = Color(0xFF121318),
    onSurface = Color(0xFFFFFFFF),
    surfaceVariant = Color(0xFF44464F),
    onSurfaceVariant = Color(0xFFFCFAFF),
    outline = Color(0xFFC9CAD4),
    outlineVariant = Color(0xFFC9CAD4),
    scrim = Color(0xFF000000),
    inverseSurface = Color(0xFFE2E2E9),
    inverseOnSurface = Color(0xFF000000),
    inversePrimary = Color(0xFF0C2859),
    surfaceDim = Color(0xFF121318),
    surfaceBright = Color(0xFF38393F),
    surfaceContainerLowest = Color(0xFF0C0E13),
    surfaceContainerLow = Color(0xFF1A1B20),
    surfaceContainer = Color(0xFF1E1F25),
    surfaceContainerHigh = Color(0xFF282A2F),
    surfaceContainerHighest = Color(0xFF33353A),
)

val BlueberryBlue = Color(0xFF4f86f7)