<img align="left" width="80" height="80" src="github/mauth.png"
alt="App icon">

# Mauth

[![CI](https://img.shields.io/github/actions/workflow/status/X1nto/Mauth/build.yml?branch=master&color=blue&style=for-the-badge)](https://github.com/X1nto/Mauth/actions?query=branch%3Amaster)
[![F-Droid](https://img.shields.io/f-droid/v/com.xinto.mauth.svg?logo=F-Droid&color=green&style=for-the-badge)](https://f-droid.org/en/packages/com.xinto.mauth)
[![Releases](https://img.shields.io/github/release/X1nto/Mauth.svg?logo=github&color=171515&style=for-the-badge)](https://github.com/X1nto/Mauth/releases)

Mauth (pronounced Moth) is a Two-Factor Authentication app with support for TOTP and HOTP. It is also fully compatible with Google Authenticator.

Logo by [@wingio](https://github.com/wingio)

# Inspiration
While there are many 2FA authenticator apps out there, most of them come with an outdated UI/UX and functionality. Mauth aims to be as intuitive and feature-rich as possible, while also providing a beautiful Material You UI.

# Features
- [x] Compatibility with Google Authenticator
- Security
  - [x] Biometrics
  - [x] PIN
- Ways to add your accounts
  - [x] Scanning a QR code
    - [x] Using a camera
    - [x] From an image
  - [x] Manually
  - [x] Deeplinks
- Algorithms
  - [x] TOTP
  - [x] HOTP
- Organization
  - [ ] Search
  - [x] Sorting
  - [ ] Grouping
  - [x] Editing
  - [x] Deletion
- Exporting
  - [ ] Plain text
  - [ ] Encrypted data
- Importing
  - [ ] Google Authenticator
  - [ ] Authy
  - [ ] Aegis
  - [ ] Microsoft Authenticator

# Screenshots
<img width=200 alt="Auth screen" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png?raw=true">
<img width=200 alt="Home screen empty" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png?raw=true">
<img width=200 alt="Add account dialog" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png?raw=true">
<img width=200 alt="Add account screen" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png?raw=true">
<img width=200 alt="Home screen with accounts" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.png?raw=true">
<img width=200 alt="Edit account screen" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.png?raw=true">
<img width=200 alt="Sort options" 
src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.png?raw=true">
<img width=200 alt="Account selection"
src="fastlane/metadata/android/en-US/images/phoneScreenshots/8.png?raw=true">
<img width=200 alt="Settings screen"
src="fastlane/metadata/android/en-US/images/phoneScreenshots/9.png?raw=true">
<img width=200 alt="About screen"
src="fastlane/metadata/android/en-US/images/phoneScreenshots/10.png?raw=true">

# Download
Mauth is available on F-Droid and GitHub Releases page.  
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" height="75">](https://f-droid.org/en/packages/com.xinto.mauth)
[<img src="github/get_it_on_github.png" height="75">](https://github.com/X1nto/Mauth/releases)

# License
```
Mauth is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.
```