package com.wmstein.transektcount.database

import android.annotation.SuppressLint
import android.content.ContentValues
import android.content.Context
import android.database.Cursor
import android.database.sqlite.SQLiteDatabase

/**********************************
 * Created by milo on 2014-05-05
 * changed by wmstein on 2016-02-18
 * last edited in Java on 2022-04-26,
 * converted to Kotlin on 2023-06-26,
 * last edited on 2025-11-21
 */
class AlertDataSource(context: Context) {
    // Database fields
    private var database: SQLiteDatabase? = null
    private val dbHelper: DbHelper = DbHelper(context)
    private val allColumns = arrayOf(
        DbHelper.A_ID,
        DbHelper.A_COUNT_ID,
        DbHelper.A_ALERT,
        DbHelper.A_ALERT_TEXT
    )

    fun open() {
        database = dbHelper.writableDatabase
    }

    fun close() {
        dbHelper.close()
    }

    fun createAlert(countId: Int, alertValue: Int, alertText: String?) {
        val values = ContentValues()
        values.put(DbHelper.A_COUNT_ID, countId)
        values.put(DbHelper.A_ALERT, alertValue)
        values.put(DbHelper.A_ALERT_TEXT, alertText)
        val insertId = database!!.insert(DbHelper.ALERT_TABLE, null, values).toInt()
        val cursor = database!!.query(
            DbHelper.ALERT_TABLE,
            allColumns, DbHelper.A_ID + " = " + insertId, null,
            null, null, null
        )
        cursor.close()
    }

    @SuppressLint("Range")
    private fun cursorToAlert(cursor: Cursor): Alert {
        val newalert = Alert()
        newalert.id = cursor.getInt(cursor.getColumnIndex(DbHelper.A_ID))
        newalert.count_id = cursor.getInt(cursor.getColumnIndex(DbHelper.A_COUNT_ID))
        newalert.alert = cursor.getInt(cursor.getColumnIndex(DbHelper.A_ALERT))
        newalert.alert_text = cursor.getString(cursor.getColumnIndex(DbHelper.A_ALERT_TEXT))
        return newalert
    }

    fun deleteAlertById(id: Int) {
        database!!.delete(DbHelper.ALERT_TABLE, DbHelper.A_ID + " = " + id, null)
    }

    fun deleteAlerts() {
        database!!.delete(DbHelper.ALERT_TABLE, null, null)
    }

    fun saveAlert(alertId: Int, alertValue: Int, alertText: String?) {
        val dataToInsert = ContentValues()
        dataToInsert.put(DbHelper.A_ALERT, alertValue)
        dataToInsert.put(DbHelper.A_ALERT_TEXT, alertText)
        val where = DbHelper.A_ID + " = ?"
        val whereArgs = arrayOf(alertId.toString())
        database!!.update(DbHelper.ALERT_TABLE, dataToInsert, where, whereArgs)
    }

    fun getAllAlertsForCount(countId: Int): List<Alert> {
        val alerts: MutableList<Alert> = ArrayList()
        val cursor = database!!.query(
            DbHelper.ALERT_TABLE, allColumns,
            DbHelper.A_COUNT_ID + " = " + countId, null, null, null, null
        )
        cursor.moveToFirst()
        while (!cursor.isAfterLast) {
            val alert = cursorToAlert(cursor)
            alerts.add(alert)
            cursor.moveToNext()
        }
        cursor.close()
        return alerts
    }
}