/*
 * Wire
 * Copyright (C) 2024 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */

package com.wire.kalium.logic.data.prekey

import com.wire.kalium.cryptography.PreKeyCrypto
import com.wire.kalium.network.api.authenticated.prekey.PreKeyDTO
import io.mockative.Mockable

@Mockable
interface PreKeyMapper {
    fun fromPreKeyDTO(preyKeyDTO: PreKeyDTO): PreKeyCrypto
    fun toPreKeyDTO(preKey: PreKeyCrypto): PreKeyDTO
}

class PreKeyMapperImpl : PreKeyMapper {
    override fun fromPreKeyDTO(preyKeyDTO: PreKeyDTO): PreKeyCrypto =
        PreKeyCrypto(id = preyKeyDTO.id, pkb = preyKeyDTO.key)

    override fun toPreKeyDTO(preKey: PreKeyCrypto): PreKeyDTO = PreKeyDTO(id = preKey.id, key = preKey.pkb)
}
