/*
 * Wire
 * Copyright (C) 2025 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */
package com.wire.android.ui.common.button

import androidx.compose.material3.SelectableChipColors
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import com.wire.android.ui.common.colorsScheme

@Composable
fun wireChipColors() = SelectableChipColors(
    containerColor = colorsScheme().surface,
    labelColor = colorsScheme().onBackground,
    leadingIconColor = colorsScheme().onBackground,
    trailingIconColor = colorsScheme().onBackground,
    disabledContainerColor = Color.Transparent.copy(alpha = 0.5f),
    disabledLabelColor = colorsScheme().onPrimaryVariant.copy(alpha = 0.5f),
    disabledLeadingIconColor = colorsScheme().onPrimaryVariant.copy(alpha = 0.5f),
    disabledTrailingIconColor = colorsScheme().onPrimaryVariant.copy(alpha = 0.5f),
    disabledSelectedContainerColor = colorsScheme().primary.copy(alpha = 0.5f),
    selectedContainerColor = colorsScheme().primaryVariant,
    selectedLabelColor = colorsScheme().primary,
    selectedLeadingIconColor = colorsScheme().primary,
    selectedTrailingIconColor = colorsScheme().primary,
)
