/*
 * Wire
 * Copyright (C) 2025 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */
package com.wire.android.emm

import com.wire.android.util.isValidWebUrl
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.Transient

@Serializable
data class ManagedServerConfig(
    @SerialName("title")
    val title: String,
    @SerialName("endpoints")
    val endpoints: ManagedServerLinks
)

@Serializable
data class ManagedServerLinks(
    val accountsURL: String,
    val backendURL: String,
    val backendWSURL: String,
    val blackListURL: String,
    val teamsURL: String,
    val websiteURL: String
) {

    @Transient
    val isValid: Boolean = accountsURL.isValidWebUrl() &&
            backendURL.isValidWebUrl() &&
            backendWSURL.isValidWebUrl() &&
            blackListURL.isValidWebUrl() &&
            teamsURL.isValidWebUrl() &&
            websiteURL.isValidWebUrl()
}
