/*
 * Wire
 * Copyright (C) 2024 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */

package com.wire.android.ui.theme

import androidx.compose.runtime.Stable
import androidx.compose.ui.graphics.Color
import io.github.esentsov.PackagePrivate

@PackagePrivate
@Suppress("MagicNumber")
object WireColorPalette {

    @Stable
    val LightBlue50 = Color(0xFFE7F0FA)
    @Stable
    val LightBlue100 = Color(0xFFCDE1F4)
    @Stable
    val LightBlue200 = Color(0xFF9BC2E9)
    @Stable
    val LightBlue300 = Color(0xFF6AA4DE)
    @Stable
    val LightBlue400 = Color(0xFF3885D3)
    @Stable
    val LightBlue500 = Color(0xFF0667C8)
    @Stable
    val LightBlue600 = Color(0xFF0552A0)
    @Stable
    val LightBlue700 = Color(0xFF043E78)
    @Stable
    val LightBlue800 = Color(0xFF022950)
    @Stable
    val LightBlue900 = Color(0xFF021F3C)

    @Stable
    val LightGreen50 = Color(0xFFE9F2EB)
    @Stable
    val LightGreen100 = Color(0xFFD2E5D7)
    @Stable
    val LightGreen200 = Color(0xFFA6CBAF)
    @Stable
    val LightGreen300 = Color(0xFF79B087)
    @Stable
    val LightGreen400 = Color(0xFF4D965F)
    @Stable
    val LightGreen500 = Color(0xFF207C37)
    @Stable
    val LightGreen550 = Color(0xFF1D7833)
    @Stable
    val LightGreen600 = Color(0xFF1A632C)
    @Stable
    val LightGreen700 = Color(0xFF134A21)
    @Stable
    val LightGreen800 = Color(0xFF0D3216)
    @Stable
    val LightGreen900 = Color(0xFF0A2511)

    @Stable
    val LightPetrol50 = Color(0xFFE6F3F6)
    @Stable
    val LightPetrol100 = Color(0xFFCCE6EB)
    @Stable
    val LightPetrol200 = Color(0xFF99CDD8)
    @Stable
    val LightPetrol300 = Color(0xFF67B3C4)
    @Stable
    val LightPetrol400 = Color(0xFF349AB1)
    @Stable
    val LightPetrol500 = Color(0xFF01819D)
    @Stable
    val LightPetrol600 = Color(0xFF01677E)
    @Stable
    val LightPetrol700 = Color(0xFF014D5E)
    @Stable
    val LightPetrol800 = Color(0xFF00343F)
    @Stable
    val LightPetrol900 = Color(0xFF00272F)

    @Stable
    val LightPurple50 = Color(0xFFF4EDF7)
    @Stable
    val LightPurple100 = Color(0xFFE7DAEE)
    @Stable
    val LightPurple200 = Color(0xFFD0B4DD)
    @Stable
    val LightPurple300 = Color(0xFFB88FCD)
    @Stable
    val LightPurple400 = Color(0xFFA169BC)
    @Stable
    val LightPurple500 = Color(0xFF8944AB)
    @Stable
    val LightPurple600 = Color(0xFF6E3689)
    @Stable
    val LightPurple700 = Color(0xFF522967)
    @Stable
    val LightPurple800 = Color(0xFF371B44)
    @Stable
    val LightPurple900 = Color(0xFF291433)

    @Stable
    val LightRed50 = Color(0xFFF9E6E8)
    @Stable
    val LightRed100 = Color(0xFFF3CCD0)
    @Stable
    val LightRed200 = Color(0xFFE799A1)
    @Stable
    val LightRed300 = Color(0xFFDA6671)
    @Stable
    val LightRed400 = Color(0xFFCE3342)
    @Stable
    val LightRed500 = Color(0xFFC20013)
    @Stable
    val LightRed600 = Color(0xFF9B000F)
    @Stable
    val LightRed700 = Color(0xFF74000B)
    @Stable
    val LightRed800 = Color(0xFF4E0008)
    @Stable
    val LightRed900 = Color(0xFF3A0006)

    @Stable
    val LightAmber50 = Color(0xFFF3F0ED)
    @Stable
    val LightAmber100 = Color(0xFFE5E0DA)
    @Stable
    val LightAmber200 = Color(0xFFCCC1B5)
    @Stable
    val LightAmber300 = Color(0xFFB2A38F)
    @Stable
    val LightAmber400 = Color(0xFF99846A)
    @Stable
    val LightAmber500 = Color(0xFF7F6545)
    @Stable
    val LightAmber600 = Color(0xFF665137)
    @Stable
    val LightAmber700 = Color(0xFF4C3D29)
    @Stable
    val LightAmber800 = Color(0xFF4C3D29)
    @Stable
    val LightAmber900 = Color(0xFF261E15)

    @Stable
    val DarkBlue50 = Color(0xFFEEF7FF)
    @Stable
    val DarkBlue100 = Color(0xFFDDEDFF)
    @Stable
    val DarkBlue200 = Color(0xFFBBDBFF)
    @Stable
    val DarkBlue300 = Color(0xFF98CAFF)
    @Stable
    val DarkBlue400 = Color(0xFF76B8FF)
    @Stable
    val DarkBlue500 = Color(0xFF54A6FF)
    @Stable
    val DarkBlue600 = Color(0xFF4385CC)
    @Stable
    val DarkBlue700 = Color(0xFF326499)
    @Stable
    val DarkBlue800 = Color(0xFF224266)
    @Stable
    val DarkBlue900 = Color(0xFF19324D)

    @Stable
    val DarkGreen50 = Color(0xFFEBFCEF)
    @Stable
    val DarkGreen100 = Color(0xFFD6F8DE)
    @Stable
    val DarkGreen200 = Color(0xFFACF1BD)
    @Stable
    val DarkGreen300 = Color(0xFF83E99D)
    @Stable
    val DarkGreen400 = Color(0xFF59E27C)
    @Stable
    val DarkGreen500 = Color(0xFF30DB5B)
    val DarkGreen550 = Color(0xFF1D7833)
    @Stable
    val DarkGreen600 = Color(0xFF26AF49)
    @Stable
    val DarkGreen700 = Color(0xFF1D8337)
    @Stable
    val DarkGreen800 = Color(0xFF135824)
    @Stable
    val DarkGreen900 = Color(0xFF0E421B)

    @Stable
    val DarkPetrol50 = Color(0xFFEFFDFF)
    @Stable
    val DarkPetrol100 = Color(0xFFDFFAFF)
    @Stable
    val DarkPetrol200 = Color(0xFFBEF5FF)
    @Stable
    val DarkPetrol300 = Color(0xFF9EF0FF)
    @Stable
    val DarkPetrol400 = Color(0xFF7DEBFF)
    @Stable
    val DarkPetrol500 = Color(0xFF5DE6FF)
    @Stable
    val DarkPetrol600 = Color(0xFF4AB8CC)
    @Stable
    val DarkPetrol700 = Color(0xFF388A99)
    @Stable
    val DarkPetrol800 = Color(0xFF255C66)
    @Stable
    val DarkPetrol900 = Color(0xFF1C454D)

    @Stable
    val DarkPurple50 = Color(0xFFFCF4FF)
    @Stable
    val DarkPurple100 = Color(0xFFF8E9FF)
    @Stable
    val DarkPurple200 = Color(0xFFF0D2FF)
    @Stable
    val DarkPurple300 = Color(0xFFE9BCFF)
    @Stable
    val DarkPurple400 = Color(0xFFE1A5FF)
    @Stable
    val DarkPurple500 = Color(0xFFDA8FFF)
    @Stable
    val DarkPurple600 = Color(0xFFAE72CC)
    @Stable
    val DarkPurple700 = Color(0xFF835699)
    @Stable
    val DarkPurple800 = Color(0xFF573966)
    @Stable
    val DarkPurple900 = Color(0xFF412B4D)

    @Stable
    val DarkRed50 = Color(0xFFFFF2F1)
    @Stable
    val DarkRed100 = Color(0xFFFFE4E2)
    @Stable
    val DarkRed200 = Color(0xFFFFC9C6)
    @Stable
    val DarkRed300 = Color(0xFFFFADA9)
    @Stable
    val DarkRed400 = Color(0xFFFF928D)
    @Stable
    val DarkRed500 = Color(0xFFFF7770)
    @Stable
    val DarkRed600 = Color(0xFFCC5F5A)
    @Stable
    val DarkRed700 = Color(0xFF994743)
    @Stable
    val DarkRed800 = Color(0xFF66302D)
    @Stable
    val DarkRed900 = Color(0xFF4D2422)

    @Stable
    val DarkAmber50 = Color(0xFFFFFBEA)
    @Stable
    val DarkAmber100 = Color(0xFFFFF6D4)
    @Stable
    val DarkAmber200 = Color(0xFFFFEEA8)
    @Stable
    val DarkAmber300 = Color(0xFFFFE57D)
    @Stable
    val DarkAmber400 = Color(0xFFFFDD51)
    @Stable
    val DarkAmber500 = Color(0xFFFFD426)
    @Stable
    val DarkAmber600 = Color(0xFFCCAA1E)
    @Stable
    val DarkAmber700 = Color(0xFF997F17)
    @Stable
    val DarkAmber800 = Color(0xFF66550F)
    @Stable
    val DarkAmber900 = Color(0xFF4D400B)

    @Stable
    val Gray10 = Color(0xFFFAFAFA)
    @Stable
    val Gray20 = Color(0xFFEDEFF0)
    @Stable
    val Gray30 = Color(0xFFE5E8EA)
    @Stable
    val Gray40 = Color(0xFFDCE0E3)
    @Stable
    val Gray50 = Color(0xFFCBCED1)
    @Stable
    val Gray60 = Color(0xFF9FA1A7)
    @Stable
    val Gray70 = Color(0xFF676B71)
    @Stable
    val Gray80 = Color(0xFF54585F)
    @Stable
    val Gray90 = Color(0xFF34373D)
    @Stable
    val Gray95 = Color(0xFF26272C)
    @Stable
    val Gray100 = Color(0xFF17181A)

    @Stable
    val BlackAlpha55 = Color(0x8C000000)

    @Stable
    val Brown = Color(0xFFA25915)
    @Stable
    val Chocolate = Color(0xFF622F00)
    @Stable
    val Orange = Color(0xFFFD8312)
    @Stable
    val Pink = Color(0xFFEB239B)
    @Stable
    val Turquoise = Color(0xFF01718E)
}
