/*
 * Wire
 * Copyright (C) 2024 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */

package com.wire.android.ui.common

import androidx.annotation.StringRes
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.wire.android.R
import com.wire.android.ui.common.button.WireButtonState
import com.wire.android.ui.common.button.WireSecondaryIconButton

@Composable
fun CopyButton(
    onCopyClicked: () -> Unit,
    modifier: Modifier = Modifier,
    @StringRes contentDescription: Int = R.string.content_description_copy,
    state: WireButtonState = WireButtonState.Default
) {
    WireSecondaryIconButton(
        onButtonClicked = onCopyClicked,
        iconResource = R.drawable.ic_copy,
        contentDescription = contentDescription,
        state = state,
        modifier = modifier
    )
}
