/*
 * Copyright (C) 2019 Andreas Steffen
 * Copyright (C) 2015 Martin Willi
 *
 * Copyright (C) secunet Security Networks AG
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the Licenseor (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be usefulbut
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <crypto/crypto_tester.h>

/**
 * Test vectors from RFC5114
 */

ke_test_vector_t ecp192 = {
	.method = ECP_192_BIT,
	.seed = chunk_from_chars(
		0x32, 0x3f, 0xa3, 0x16, 0x9d, 0x8e, 0x9c, 0x65, 0x93, 0xf5,
		0x94, 0x76, 0xbc, 0x14, 0x20, 0x00, 0xab, 0x5b, 0xe0, 0xe2,
		0x49, 0xc4, 0x34, 0x26, /* - */
		0x63, 0x1f, 0x95, 0xbb, 0x4a, 0x67, 0x63, 0x2c, 0x9c, 0x47,
		0x6e, 0xee, 0x9a, 0xb6, 0x95, 0xab, 0x24, 0x0a, 0x04, 0x99,
		0x30, 0x7f, 0xcf, 0x62),
	.pub_i = chunk_from_chars(
		0xcd, 0x46, 0x48, 0x9e, 0xcf, 0xd6, 0xc1, 0x05, 0xe7, 0xb3,
		0xd3, 0x25, 0x66, 0xe2, 0xb1, 0x22, 0xe2, 0x49, 0xab, 0xaa,
		0xdd, 0x87, 0x06, 0x12, 0x68, 0x88, 0x7b, 0x48, 0x77, 0xdf,
		0x51, 0xdd, 0x4d, 0xc3, 0xd6, 0xfd, 0x11, 0xf0, 0xa2, 0x6f,
		0x8f, 0xd3, 0x84, 0x43, 0x17, 0x91, 0x6e, 0x9a),
	.pub_r = chunk_from_chars(
		0x51, 0x9a, 0x12, 0x16, 0x80, 0xe0, 0x04, 0x54, 0x66, 0xba,
		0x21, 0xdf, 0x2e, 0xee, 0x47, 0xf5, 0x97, 0x3b, 0x50, 0x05,
		0x77, 0xef, 0x13, 0xd5, 0xff, 0x61, 0x3a, 0xb4, 0xd6, 0x4c,
		0xee, 0x3a, 0x20, 0x87, 0x5b, 0xdb, 0x10, 0xf9, 0x53, 0xf6,
		0xb3, 0x0c, 0xa0, 0x72, 0xc6, 0x0a, 0xa5, 0x7f),
	.shared = chunk_from_chars(
		0xad, 0x42, 0x01, 0x82, 0x63, 0x3f, 0x85, 0x26, 0xbf, 0xe9,
		0x54, 0xac, 0xda, 0x37, 0x6f, 0x05, 0xe5, 0xff, 0x4f, 0x83,
		0x7f, 0x54, 0xfe, 0xbe)
};

ke_test_vector_t ecp224 = {
	.method = ECP_224_BIT,
	.seed = chunk_from_chars(
		0xb5, 0x58, 0xeb, 0x6c, 0x28, 0x8d, 0xa7, 0x07, 0xbb, 0xb4,
		0xf8, 0xfb, 0xae, 0x2a, 0xb9, 0xe9, 0xcb, 0x62, 0xe3, 0xbc,
		0x5c, 0x75, 0x73, 0xe2, 0x2e, 0x26, 0xd3, 0x7f, /* - */
		0xac, 0x3b, 0x1a, 0xdd, 0x3d, 0x97, 0x70, 0xe6, 0xf6, 0xa7,
		0x08, 0xee, 0x9f, 0x3b, 0x8e, 0x0a, 0xb3, 0xb4, 0x80, 0xe9,
		0xf2, 0x7f, 0x85, 0xc8, 0x8b, 0x5e, 0x6d, 0x18),
	.pub_i = chunk_from_chars(
		0x49, 0xdf, 0xef, 0x30, 0x9f, 0x81, 0x48, 0x8c, 0x30, 0x4c,
		0xff, 0x5a, 0xb3, 0xee, 0x5a, 0x21, 0x54, 0x36, 0x7d, 0xc7,
		0x83, 0x31, 0x50, 0xe0, 0xa5, 0x1f, 0x3e, 0xeb, 0x4f, 0x2b,
		0x5e, 0xe4, 0x57, 0x62, 0xc4, 0xf6, 0x54, 0xc1, 0xa0, 0xc6,
		0x7f, 0x54, 0xcf, 0x88, 0xb0, 0x16, 0xb5, 0x1b, 0xce, 0x3d,
		0x7c, 0x22, 0x8d, 0x57, 0xad, 0xb4),
	.pub_r = chunk_from_chars(
		0x6b, 0x3a, 0xc9, 0x6a, 0x8d, 0x0c, 0xde, 0x6a, 0x55, 0x99,
		0xbe, 0x80, 0x32, 0xed, 0xf1, 0x0c, 0x16, 0x2d, 0x0a, 0x8a,
		0xd2, 0x19, 0x50, 0x6d, 0xcd, 0x42, 0xa2, 0x07, 0xd4, 0x91,
		0xbe, 0x99, 0xc2, 0x13, 0xa7, 0xd1, 0xca, 0x37, 0x06, 0xde,
		0xbf, 0xe3, 0x05, 0xf3, 0x61, 0xaf, 0xcb, 0xb3, 0x3e, 0x26,
		0x09, 0xc8, 0xb1, 0x61, 0x8a, 0xd5),
	.shared = chunk_from_chars(
		0x52, 0x27, 0x2f, 0x50, 0xf4, 0x6f, 0x4e, 0xdc, 0x91, 0x51,
		0x56, 0x90, 0x92, 0xf4, 0x6d, 0xf2, 0xd9, 0x6e, 0xcc, 0x3b,
		0x6d, 0xc1, 0x71, 0x4a, 0x4e, 0xa9, 0x49, 0xfa)
};

ke_test_vector_t ecp256 = {
	.method = ECP_256_BIT,
	.seed = chunk_from_chars(
		0x81, 0x42, 0x64, 0x14, 0x5f, 0x2f, 0x56, 0xf2, 0xe9, 0x6a,
		0x8e, 0x33, 0x7a, 0x12, 0x84, 0x99, 0x3f, 0xaf, 0x43, 0x2a,
		0x5a, 0xbc, 0xe5, 0x9e, 0x86, 0x7b, 0x72, 0x91, 0xd5, 0x07,
		0xa3, 0xaf, /* - */
		0x2c, 0xe1, 0x78, 0x8e, 0xc1, 0x97, 0xe0, 0x96, 0xdb, 0x95,
		0xa2, 0x00, 0xcc, 0x0a, 0xb2, 0x6a, 0x19, 0xce, 0x6b, 0xcc,
		0xad, 0x56, 0x2b, 0x8e, 0xee, 0x1b, 0x59, 0x37, 0x61, 0xcf,
		0x7f, 0x41),
	.pub_i = chunk_from_chars(
		0x2a, 0xf5, 0x02, 0xf3, 0xbe, 0x89, 0x52, 0xf2, 0xc9, 0xb5,
		0xa8, 0xd4, 0x16, 0x0d, 0x09, 0xe9, 0x71, 0x65, 0xbe, 0x50,
		0xbc, 0x42, 0xae, 0x4a, 0x5e, 0x8d, 0x3b, 0x4b, 0xa8, 0x3a,
		0xeb, 0x15, 0xeb, 0x0f, 0xaf, 0x4c, 0xa9, 0x86, 0xc4, 0xd3,
		0x86, 0x81, 0xa0, 0xf9, 0x87, 0x2d, 0x79, 0xd5, 0x67, 0x95,
		0xbd, 0x4b, 0xff, 0x6e, 0x6d, 0xe3, 0xc0, 0xf5, 0x01, 0x5e,
		0xce, 0x5e, 0xfd, 0x85),
	.pub_r = chunk_from_chars(
		0xb1, 0x20, 0xde, 0x4a, 0xa3, 0x64, 0x92, 0x79, 0x53, 0x46,
		0xe8, 0xde, 0x6c, 0x2c, 0x86, 0x46, 0xae, 0x06, 0xaa, 0xea,
		0x27, 0x9f, 0xa7, 0x75, 0xb3, 0xab, 0x07, 0x15, 0xf6, 0xce,
		0x51, 0xb0, 0x9f, 0x1b, 0x7e, 0xec, 0xe2, 0x0d, 0x7b, 0x5e,
		0xd8, 0xec, 0x68, 0x5f, 0xa3, 0xf0, 0x71, 0xd8, 0x37, 0x27,
		0x02, 0x70, 0x92, 0xa8, 0x41, 0x13, 0x85, 0xc3, 0x4d, 0xde,
		0x57, 0x08, 0xb2, 0xb6),
	.shared = chunk_from_chars(
		0xdd, 0x0f, 0x53, 0x96, 0x21, 0x9d, 0x1e, 0xa3, 0x93, 0x31,
		0x04, 0x12, 0xd1, 0x9a, 0x08, 0xf1, 0xf5, 0x81, 0x1e, 0x9d,
		0xc8, 0xec, 0x8e, 0xea, 0x7f, 0x80, 0xd2, 0x1c, 0x82, 0x0c,
		0x27, 0x88)
};

ke_test_vector_t ecp384 = {
	.method = ECP_384_BIT,
	.seed = chunk_from_chars(
		0xd2, 0x73, 0x35, 0xea, 0x71, 0x66, 0x4a, 0xf2, 0x44, 0xdd,
		0x14, 0xe9, 0xfd, 0x12, 0x60, 0x71, 0x5d, 0xfd, 0x8a, 0x79,
		0x65, 0x57, 0x1c, 0x48, 0xd7, 0x09, 0xee, 0x7a, 0x79, 0x62,
		0xa1, 0x56, 0xd7, 0x06, 0xa9, 0x0c, 0xbc, 0xb5, 0xdf, 0x29,
		0x86, 0xf0, 0x5f, 0xea, 0xdb, 0x93, 0x76, 0xf1, /* - */
		0x52, 0xd1, 0x79, 0x1f, 0xdb, 0x4b, 0x70, 0xf8, 0x9c, 0x0f,
		0x00, 0xd4, 0x56, 0xc2, 0xf7, 0x02, 0x3b, 0x61, 0x25, 0x26,
		0x2c, 0x36, 0xa7, 0xdf, 0x1f, 0x80, 0x23, 0x11, 0x21, 0xcc,
		0xe3, 0xd3, 0x9b, 0xe5, 0x2e, 0x00, 0xc1, 0x94, 0xa4, 0x13,
		0x2c, 0x4a, 0x6c, 0x76, 0x8b, 0xcd, 0x94, 0xd2),
	.pub_i = chunk_from_chars(
		0x79, 0x31, 0x48, 0xf1, 0x78, 0x76, 0x34, 0xd5, 0xda, 0x4c,
		0x6d, 0x90, 0x74, 0x41, 0x7d, 0x05, 0xe0, 0x57, 0xab, 0x62,
		0xf8, 0x20, 0x54, 0xd1, 0x0e, 0xe6, 0xb0, 0x40, 0x3d, 0x62,
		0x79, 0x54, 0x7e, 0x6a, 0x8e, 0xa9, 0xd1, 0xfd, 0x77, 0x42,
		0x7d, 0x01, 0x6f, 0xe2, 0x7a, 0x8b, 0x8c, 0x66, 0xc6, 0xc4,
		0x12, 0x94, 0x33, 0x1d, 0x23, 0xe6, 0xf4, 0x80, 0xf4, 0xfb,
		0x4c, 0xd4, 0x05, 0x04, 0xc9, 0x47, 0x39, 0x2e, 0x94, 0xf4,
		0xc3, 0xf0, 0x6b, 0x8f, 0x39, 0x8b, 0xb2, 0x9e, 0x42, 0x36,
		0x8f, 0x7a, 0x68, 0x59, 0x23, 0xde, 0x3b, 0x67, 0xba, 0xce,
		0xd2, 0x14, 0xa1, 0xa1, 0xd1, 0x28),
	.pub_r = chunk_from_chars(
		0x5c, 0xd4, 0x2a, 0xb9, 0xc4, 0x1b, 0x53, 0x47, 0xf7, 0x4b,
		0x8d, 0x4e, 0xfb, 0x70, 0x8b, 0x3d, 0x5b, 0x36, 0xdb, 0x65,
		0x91, 0x53, 0x59, 0xb4, 0x4a, 0xbc, 0x17, 0x64, 0x7b, 0x6b,
		0x99, 0x99, 0x78, 0x9d, 0x72, 0xa8, 0x48, 0x65, 0xae, 0x2f,
		0x22, 0x3f, 0x12, 0xb5, 0xa1, 0xab, 0xc1, 0x20, 0xe1, 0x71,
		0x45, 0x8f, 0xea, 0xa9, 0x39, 0xaa, 0xa3, 0xa8, 0xbf, 0xac,
		0x46, 0xb4, 0x04, 0xbd, 0x8f, 0x6d, 0x5b, 0x34, 0x8c, 0x0f,
		0xa4, 0xd8, 0x0c, 0xec, 0xa1, 0x63, 0x56, 0xca, 0x93, 0x32,
		0x40, 0xbd, 0xe8, 0x72, 0x34, 0x15, 0xa8, 0xec, 0xe0, 0x35,
		0xb0, 0xed, 0xf3, 0x67, 0x55, 0xde),
	.shared = chunk_from_chars(
		0x5e, 0xa1, 0xfc, 0x4a, 0xf7, 0x25, 0x6d, 0x20, 0x55, 0x98,
		0x1b, 0x11, 0x05, 0x75, 0xe0, 0xa8, 0xca, 0xe5, 0x31, 0x60,
		0x13, 0x7d, 0x90, 0x4c, 0x59, 0xd9, 0x26, 0xeb, 0x1b, 0x84,
		0x56, 0xe4, 0x27, 0xaa, 0x8a, 0x45, 0x40, 0x88, 0x4c, 0x37,
		0xde, 0x15, 0x9a, 0x58, 0x02, 0x8a, 0xbc, 0x0e)
};

ke_test_vector_t ecp521 = {
	.method = ECP_521_BIT,
	.seed = chunk_from_chars(
		0x01, 0x13, 0xf8, 0x2d, 0xa8, 0x25, 0x73, 0x5e, 0x3d, 0x97,
		0x27, 0x66, 0x83, 0xb2, 0xb7, 0x42, 0x77, 0xba, 0xd2, 0x73,
		0x35, 0xea, 0x71, 0x66, 0x4a, 0xf2, 0x43, 0x0c, 0xc4, 0xf3,
		0x34, 0x59, 0xb9, 0x66, 0x9e, 0xe7, 0x8b, 0x3f, 0xfb, 0x9b,
		0x86, 0x83, 0x01, 0x5d, 0x34, 0x4d, 0xcb, 0xfe, 0xf6, 0xfb,
		0x9a, 0xf4, 0xc6, 0xc4, 0x70, 0xbe, 0x25, 0x45, 0x16, 0xcd,
		0x3c, 0x1a, 0x1f, 0xb4, 0x73, 0x62, /* - */
		0x00, 0xce, 0xe3, 0x48, 0x0d, 0x86, 0x45, 0xa1, 0x7d, 0x24,
		0x9f, 0x27, 0x76, 0xd2, 0x8b, 0xae, 0x61, 0x69, 0x52, 0xd1,
		0x79, 0x1f, 0xdb, 0x4b, 0x70, 0xf7, 0xc3, 0x37, 0x87, 0x32,
		0xaa, 0x1b, 0x22, 0x92, 0x84, 0x48, 0xbc, 0xd1, 0xdc, 0x24,
		0x96, 0xd4, 0x35, 0xb0, 0x10, 0x48, 0x06, 0x6e, 0xbe, 0x4f,
		0x72, 0x90, 0x3c, 0x36, 0x1b, 0x1a, 0x9d, 0xc1, 0x19, 0x3d,
		0xc2, 0xc9, 0xd0, 0x89, 0x1b, 0x96),
	.pub_i = chunk_from_chars(
		0x01, 0xeb, 0xb3, 0x4d, 0xd7, 0x57, 0x21, 0xab, 0xf8, 0xad,
		0xc9, 0xdb, 0xed, 0x17, 0x88, 0x9c, 0xbb, 0x97, 0x65, 0xd9,
		0x0a, 0x7c, 0x60, 0xf2, 0xce, 0xf0, 0x07, 0xbb, 0x0f, 0x2b,
		0x26, 0xe1, 0x48, 0x81, 0xfd, 0x44, 0x42, 0xe6, 0x89, 0xd6,
		0x1c, 0xb2, 0xdd, 0x04, 0x6e, 0xe3, 0x0e, 0x3f, 0xfd, 0x20,
		0xf9, 0xa4, 0x5b, 0xbd, 0xf6, 0x41, 0x3d, 0x58, 0x3a, 0x2d,
		0xbf, 0x59, 0x92, 0x4f, 0xd3, 0x5c, 0x00, 0xf6, 0xb6, 0x32,
		0xd1, 0x94, 0xc0, 0x38, 0x8e, 0x22, 0xd8, 0x43, 0x7e, 0x55,
		0x8c, 0x55, 0x2a, 0xe1, 0x95, 0xad, 0xfd, 0x15, 0x3f, 0x92,
		0xd7, 0x49, 0x08, 0x35, 0x1b, 0x2f, 0x8c, 0x4e, 0xda, 0x94, /* 100 */
		0xed, 0xb0, 0x91, 0x6d, 0x1b, 0x53, 0xc0, 0x20, 0xb5, 0xee,
		0xca, 0xed, 0x1a, 0x5f, 0xc3, 0x8a, 0x23, 0x3e, 0x48, 0x30,
		0x58, 0x7b, 0xb2, 0xee, 0x34, 0x89, 0xb3, 0xb4, 0x2a, 0x5a,
		0x86, 0xa4),
	.pub_r = chunk_from_chars(
		0x01, 0x0e, 0xbf, 0xaf, 0xc6, 0xe8, 0x5e, 0x08, 0xd2, 0x4b,
		0xff, 0xfc, 0xc1, 0xa4, 0x51, 0x1d, 0xb0, 0xe6, 0x34, 0xbe,
		0xeb, 0x1b, 0x6d, 0xec, 0x8c, 0x59, 0x39, 0xae, 0x44, 0x76,
		0x62, 0x01, 0xaf, 0x62, 0x00, 0x43, 0x0b, 0xa9, 0x7c, 0x8a,
		0xc6, 0xa0, 0xe9, 0xf0, 0x8b, 0x33, 0xce, 0x7e, 0x9f, 0xee,
		0xb5, 0xba, 0x4e, 0xe5, 0xe0, 0xd8, 0x15, 0x10, 0xc2, 0x42,
		0x95, 0xb8, 0xa0, 0x8d, 0x02, 0x35, 0x00, 0xa4, 0xa6, 0xec,
		0x30, 0x0d, 0xf9, 0xe2, 0x57, 0xb0, 0x37, 0x2b, 0x5e, 0x7a,
		0xbf, 0xef, 0x09, 0x34, 0x36, 0x71, 0x9a, 0x77, 0x88, 0x7e,
		0xbb, 0x0b, 0x18, 0xcf, 0x80, 0x99, 0xb9, 0xf4, 0x21, 0x2b, /* 100 */
		0x6e, 0x30, 0xa1, 0x41, 0x9c, 0x18, 0xe0, 0x29, 0xd3, 0x68,
		0x63, 0xcc, 0x9d, 0x44, 0x8f, 0x4d, 0xba, 0x4d, 0x2a, 0x0e,
		0x60, 0x71, 0x1b, 0xe5, 0x72, 0x91, 0x5f, 0xbd, 0x4f, 0xef,
		0x26, 0x95),
	.shared = chunk_from_chars(
		0x00, 0xcd, 0xea, 0x89, 0x62, 0x1c, 0xfa, 0x46, 0xb1, 0x32,
		0xf9, 0xe4, 0xcf, 0xe2, 0x26, 0x1c, 0xde, 0x2d, 0x43, 0x68,
		0xeb, 0x56, 0x56, 0x63, 0x4c, 0x7c, 0xc9, 0x8c, 0x7a, 0x00,
		0xcd, 0xe5, 0x4e, 0xd1, 0x86, 0x6a, 0x0d, 0xd3, 0xe6, 0x12,
		0x6c, 0x9d, 0x2f, 0x84, 0x5d, 0xaf, 0xf8, 0x2c, 0xeb, 0x1d,
		0xa0, 0x8f, 0x5d, 0x87, 0x52, 0x1b, 0xb0, 0xeb, 0xec, 0xa7,
		0x79, 0x11, 0x16, 0x9c, 0x20, 0xcc)
};
