/*
 * Copyright (C) 2019 Andreas Steffen
 * Copyright (C) 2015 Martin Willi
 *
 * Copyright (C) secunet Security Networks AG
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the Licenseor (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be usefulbut
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <crypto/crypto_tester.h>

/**
 * Test vectors from RFC5114
 */

ke_test_vector_t modp1024_160 = {
	.method = MODP_1024_160,
	.seed = chunk_from_chars(
		0xB9, 0xA3, 0xB3, 0xAE, 0x8F, 0xEF, 0xC1, 0xA2, 0x93, 0x04,
		0x96, 0x50, 0x70, 0x86, 0xF8, 0x45, 0x5D, 0x48, 0x94, 0x3E, /* - */
		0x93, 0x92, 0xC9, 0xF9, 0xEB, 0x6A, 0x7A, 0x6A, 0x90, 0x22,
		0xF7, 0xD8, 0x3E, 0x72, 0x23, 0xC6, 0x83, 0x5B, 0xBD, 0xDA),
	.pub_i = chunk_from_chars(
		0x2A, 0x85, 0x3B, 0x3D, 0x92, 0x19, 0x75, 0x01, 0xB9, 0x01,
		0x5B, 0x2D, 0xEB, 0x3E, 0xD8, 0x4F, 0x5E, 0x02, 0x1D, 0xCC,
		0x3E, 0x52, 0xF1, 0x09, 0xD3, 0x27, 0x3D, 0x2B, 0x75, 0x21,
		0x28, 0x1C, 0xBA, 0xBE, 0x0E, 0x76, 0xFF, 0x57, 0x27, 0xFA,
		0x8A, 0xCC, 0xE2, 0x69, 0x56, 0xBA, 0x9A, 0x1F, 0xCA, 0x26,
		0xF2, 0x02, 0x28, 0xD8, 0x69, 0x3F, 0xEB, 0x10, 0x84, 0x1D,
		0x84, 0xA7, 0x36, 0x00, 0x54, 0xEC, 0xE5, 0xA7, 0xF5, 0xB7,
		0xA6, 0x1A, 0xD3, 0xDF, 0xB3, 0xC6, 0x0D, 0x2E, 0x43, 0x10,
		0x6D, 0x87, 0x27, 0xDA, 0x37, 0xDF, 0x9C, 0xCE, 0x95, 0xB4,
		0x78, 0x75, 0x5D, 0x06, 0xBC, 0xEA, 0x8F, 0x9D, 0x45, 0x96, /* 100 */
		0x5F, 0x75, 0xA5, 0xF3, 0xD1, 0xDF, 0x37, 0x01, 0x16, 0x5F,
		0xC9, 0xE5, 0x0C, 0x42, 0x79, 0xCE, 0xB0, 0x7F, 0x98, 0x95,
		0x40, 0xAE, 0x96, 0xD5, 0xD8, 0x8E, 0xD7, 0x76),
	.pub_r = chunk_from_chars(
		0x71, 0x7A, 0x6C, 0xB0, 0x53, 0x37, 0x1F, 0xF4, 0xA3, 0xB9,
		0x32, 0x94, 0x1C, 0x1E, 0x56, 0x63, 0xF8, 0x61, 0xA1, 0xD6,
		0xAD, 0x34, 0xAE, 0x66, 0x57, 0x6D, 0xFB, 0x98, 0xF6, 0xC6,
		0xCB, 0xF9, 0xDD, 0xD5, 0xA5, 0x6C, 0x78, 0x33, 0xF6, 0xBC,
		0xFD, 0xFF, 0x09, 0x55, 0x82, 0xAD, 0x86, 0x8E, 0x44, 0x0E,
		0x8D, 0x09, 0xFD, 0x76, 0x9E, 0x3C, 0xEC, 0xCD, 0xC3, 0xD3,
		0xB1, 0xE4, 0xCF, 0xA0, 0x57, 0x77, 0x6C, 0xAA, 0xF9, 0x73,
		0x9B, 0x6A, 0x9F, 0xEE, 0x8E, 0x74, 0x11, 0xF8, 0xD6, 0xDA,
		0xC0, 0x9D, 0x6A, 0x4E, 0xDB, 0x46, 0xCC, 0x2B, 0x5D, 0x52,
		0x03, 0x09, 0x0E, 0xAE, 0x61, 0x26, 0x31, 0x1E, 0x53, 0xFD, /* 100 */
		0x2C, 0x14, 0xB5, 0x74, 0xE6, 0xA3, 0x10, 0x9A, 0x3D, 0xA1,
		0xBE, 0x41, 0xBD, 0xCE, 0xAA, 0x18, 0x6F, 0x5C, 0xE0, 0x67,
		0x16, 0xA2, 0xB6, 0xA0, 0x7B, 0x3C, 0x33, 0xFE),
	.shared = chunk_from_chars(
		0x5C, 0x80, 0x4F, 0x45, 0x4D, 0x30, 0xD9, 0xC4, 0xDF, 0x85,
		0x27, 0x1F, 0x93, 0x52, 0x8C, 0x91, 0xDF, 0x6B, 0x48, 0xAB,
		0x5F, 0x80, 0xB3, 0xB5, 0x9C, 0xAA, 0xC1, 0xB2, 0x8F, 0x8A,
		0xCB, 0xA9, 0xCD, 0x3E, 0x39, 0xF3, 0xCB, 0x61, 0x45, 0x25,
		0xD9, 0x52, 0x1D, 0x2E, 0x64, 0x4C, 0x53, 0xB8, 0x07, 0xB8,
		0x10, 0xF3, 0x40, 0x06, 0x2F, 0x25, 0x7D, 0x7D, 0x6F, 0xBF,
		0xE8, 0xD5, 0xE8, 0xF0, 0x72, 0xE9, 0xB6, 0xE9, 0xAF, 0xDA,
		0x94, 0x13, 0xEA, 0xFB, 0x2E, 0x8B, 0x06, 0x99, 0xB1, 0xFB,
		0x5A, 0x0C, 0xAC, 0xED, 0xDE, 0xAE, 0xAD, 0x7E, 0x9C, 0xFB,
		0xB3, 0x6A, 0xE2, 0xB4, 0x20, 0x83, 0x5B, 0xD8, 0x3A, 0x19, /* 100 */
		0xFB, 0x0B, 0x5E, 0x96, 0xBF, 0x8F, 0xA4, 0xD0, 0x9E, 0x34,
		0x55, 0x25, 0x16, 0x7E, 0xCD, 0x91, 0x55, 0x41, 0x6F, 0x46,
		0xF4, 0x08, 0xED, 0x31, 0xB6, 0x3C, 0x6E, 0x6D)
};

ke_test_vector_t modp2048_224 = {
	.method = MODP_2048_224,
	.seed = chunk_from_chars(
		0x22, 0xe6, 0x26, 0x01, 0xdb, 0xff, 0xd0, 0x67, 0x08, 0xa6,
		0x80, 0xf7, 0x47, 0xf3, 0x61, 0xf7, 0x6d, 0x8f, 0x4f, 0x72,
		0x1a, 0x05, 0x48, 0xe4, 0x83, 0x29, 0x4b, 0x0c, /* - */
		0x4f, 0xf3, 0xbc, 0x96, 0xc7, 0xfc, 0x6a, 0x6d, 0x71, 0xd3,
		0xb3, 0x63, 0x80, 0x0a, 0x7c, 0xdf, 0xef, 0x6f, 0xc4, 0x1b,
		0x44, 0x17, 0xea, 0x15, 0x35, 0x3b, 0x75, 0x90),
	.pub_i = chunk_from_chars(
		0x1b, 0x3a, 0x63, 0x45, 0x1b, 0xd8, 0x86, 0xe6, 0x99, 0xe6,
		0x7b, 0x49, 0x4e, 0x28, 0x8b, 0xd7, 0xf8, 0xe0, 0xd3, 0x70,
		0xba, 0xdd, 0xa7, 0xa0, 0xef, 0xd2, 0xfd, 0xe7, 0xd8, 0xf6,
		0x61, 0x45, 0xcc, 0x9f, 0x28, 0x04, 0x19, 0x97, 0x5e, 0xb8,
		0x08, 0x87, 0x7c, 0x8a, 0x4c, 0x0c, 0x8e, 0x0b, 0xd4, 0x8d,
		0x4a, 0x54, 0x01, 0xeb, 0x1e, 0x87, 0x76, 0xbf, 0xee, 0xe1,
		0x34, 0xc0, 0x38, 0x31, 0xac, 0x27, 0x3c, 0xd9, 0xd6, 0x35,
		0xab, 0x0c, 0xe0, 0x06, 0xa4, 0x2a, 0x88, 0x7e, 0x3f, 0x52,
		0xfb, 0x87, 0x66, 0xb6, 0x50, 0xf3, 0x80, 0x78, 0xbc, 0x8e,
		0xe8, 0x58, 0x0c, 0xef, 0xe2, 0x43, 0x96, 0x8c, 0xfc, 0x4f, /* 100 */
		0x8d, 0xc3, 0xdb, 0x08, 0x45, 0x54, 0x17, 0x1d, 0x41, 0xbf,
		0x2e, 0x86, 0x1b, 0x7b, 0xb4, 0xd6, 0x9d, 0xd0, 0xe0, 0x1e,
		0xa3, 0x87, 0xcb, 0xaa, 0x5c, 0xa6, 0x72, 0xaf, 0xcb, 0xe8,
		0xbd, 0xb9, 0xd6, 0x2d, 0x4c, 0xe1, 0x5f, 0x17, 0xdd, 0x36,
		0xf9, 0x1e, 0xd1, 0xee, 0xdd, 0x65, 0xca, 0x4a, 0x06, 0x45,
		0x5c, 0xb9, 0x4c, 0xd4, 0x0a, 0x52, 0xec, 0x36, 0x0e, 0x84,
		0xb3, 0xc9, 0x26, 0xe2, 0x2c, 0x43, 0x80, 0xa3, 0xbf, 0x30,
		0x9d, 0x56, 0x84, 0x97, 0x68, 0xb7, 0xf5, 0x2c, 0xfd, 0xf6,
		0x55, 0xfd, 0x05, 0x3a, 0x7e, 0xf7, 0x06, 0x97, 0x9e, 0x7e,
		0x58, 0x06, 0xb1, 0x7d, 0xfa, 0xe5, 0x3a, 0xd2, 0xa5, 0xbc, /* 200 */
		0x56, 0x8e, 0xbb, 0x52, 0x9a, 0x7a, 0x61, 0xd6, 0x8d, 0x25,
		0x6f, 0x8f, 0xc9, 0x7c, 0x07, 0x4a, 0x86, 0x1d, 0x82, 0x7e,
		0x2e, 0xbc, 0x8c, 0x61, 0x34, 0x55, 0x31, 0x15, 0xb7, 0x0e,
		0x71, 0x03, 0x92, 0x0a, 0xa1, 0x6d, 0x85, 0xe5, 0x2b, 0xcb,
		0xab, 0x8d, 0x78, 0x6a, 0x68, 0x17, 0x8f, 0xa8, 0xff, 0x7c,
		0x2f, 0x5c, 0x71, 0x64, 0x8d, 0x6f),
	.pub_r = chunk_from_chars(
		0x4d, 0xce, 0xe9, 0x92, 0xa9, 0x76, 0x2a, 0x13, 0xf2, 0xf8,
		0x38, 0x44, 0xad, 0x3d, 0x77, 0xee, 0x0e, 0x31, 0xc9, 0x71,
		0x8b, 0x3d, 0xb6, 0xc2, 0x03, 0x5d, 0x39, 0x61, 0x18, 0x2c,
		0x3e, 0x0b, 0xa2, 0x47, 0xec, 0x41, 0x82, 0xd7, 0x60, 0xcd,
		0x48, 0xd9, 0x95, 0x99, 0x97, 0x06, 0x22, 0xa1, 0x88, 0x1b,
		0xba, 0x2d, 0xc8, 0x22, 0x93, 0x9c, 0x78, 0xc3, 0x91, 0x2c,
		0x66, 0x61, 0xfa, 0x54, 0x38, 0xb2, 0x07, 0x66, 0x22, 0x2b,
		0x75, 0xe2, 0x4c, 0x2e, 0x3a, 0xd0, 0xc7, 0x28, 0x72, 0x36,
		0x12, 0x95, 0x25, 0xee, 0x15, 0xb5, 0xdd, 0x79, 0x98, 0xaa,
		0x04, 0xc4, 0xa9, 0x69, 0x6c, 0xac, 0xd7, 0x17, 0x20, 0x83, /* 100 */
		0xa9, 0x7a, 0x81, 0x66, 0x4e, 0xad, 0x2c, 0x47, 0x9e, 0x44,
		0x4e, 0x4c, 0x06, 0x54, 0xcc, 0x19, 0xe2, 0x8d, 0x77, 0x03,
		0xce, 0xe8, 0xda, 0xcd, 0x61, 0x26, 0xf5, 0xd6, 0x65, 0xec,
		0x52, 0xc6, 0x72, 0x55, 0xdb, 0x92, 0x01, 0x4b, 0x03, 0x7e,
		0xb6, 0x21, 0xa2, 0xac, 0x8e, 0x36, 0x5d, 0xe0, 0x71, 0xff,
		0xc1, 0x40, 0x0a, 0xcf, 0x07, 0x7a, 0x12, 0x91, 0x3d, 0xd8,
		0xde, 0x89, 0x47, 0x34, 0x37, 0xab, 0x7b, 0xa3, 0x46, 0x74,
		0x3c, 0x1b, 0x21, 0x5d, 0xd9, 0xc1, 0x21, 0x64, 0xa7, 0xe4,
		0x05, 0x31, 0x18, 0xd1, 0x99, 0xbe, 0xc8, 0xef, 0x6f, 0xc5,
		0x61, 0x17, 0x0c, 0x84, 0xc8, 0x7d, 0x10, 0xee, 0x9a, 0x67, /* 200 */
		0x4a, 0x1f, 0xa8, 0xff, 0xe1, 0x3b, 0xdf, 0xba, 0x1d, 0x44,
		0xde, 0x48, 0x94, 0x6d, 0x68, 0xdc, 0x0c, 0xdd, 0x77, 0x76,
		0x35, 0xa7, 0xab, 0x5b, 0xfb, 0x1e, 0x4b, 0xb7, 0xb8, 0x56,
		0xf9, 0x68, 0x27, 0x73, 0x4c, 0x18, 0x41, 0x38, 0xe9, 0x15,
		0xd9, 0xc3, 0x00, 0x2e, 0xbc, 0xe5, 0x31, 0x20, 0x54, 0x6a,
		0x7e, 0x20, 0x02, 0x14, 0x2b, 0x6c),
	.shared = chunk_from_chars(
		0x34, 0xd9, 0xbd, 0xdc, 0x1b, 0x42, 0x17, 0x6c, 0x31, 0x3f,
		0xea, 0x03, 0x4c, 0x21, 0x03, 0x4d, 0x07, 0x4a, 0x63, 0x13,
		0xbb, 0x4e, 0xcd, 0xb3, 0x70, 0x3f, 0xff, 0x42, 0x45, 0x67,
		0xa4, 0x6b, 0xdf, 0x75, 0x53, 0x0e, 0xde, 0x0a, 0x9d, 0xa5,
		0x22, 0x9d, 0xe7, 0xd7, 0x67, 0x32, 0x28, 0x6c, 0xbc, 0x0f,
		0x91, 0xda, 0x4c, 0x3c, 0x85, 0x2f, 0xc0, 0x99, 0xc6, 0x79,
		0x53, 0x1d, 0x94, 0xc7, 0x8a, 0xb0, 0x3d, 0x9d, 0xec, 0xb0,
		0xa4, 0xe4, 0xca, 0x8b, 0x2b, 0xb4, 0x59, 0x1c, 0x40, 0x21,
		0xcf, 0x8c, 0xe3, 0xa2, 0x0a, 0x54, 0x1d, 0x33, 0x99, 0x40,
		0x17, 0xd0, 0x20, 0x0a, 0xe2, 0xc9, 0x51, 0x6e, 0x2f, 0xf5, /* 100 */
		0x14, 0x57, 0x79, 0x26, 0x9e, 0x86, 0x2b, 0x0f, 0xb4, 0x74,
		0xa2, 0xd5, 0x6d, 0xc3, 0x1e, 0xd5, 0x69, 0xa7, 0x70, 0x0b,
		0x4c, 0x4a, 0xb1, 0x6b, 0x22, 0xa4, 0x55, 0x13, 0x53, 0x1e,
		0xf5, 0x23, 0xd7, 0x12, 0x12, 0x07, 0x7b, 0x5a, 0x16, 0x9b,
		0xde, 0xff, 0xad, 0x7a, 0xd9, 0x60, 0x82, 0x84, 0xc7, 0x79,
		0x5b, 0x6d, 0x5a, 0x51, 0x83, 0xb8, 0x70, 0x66, 0xde, 0x17,
		0xd8, 0xd6, 0x71, 0xc9, 0xeb, 0xd8, 0xec, 0x89, 0x54, 0x4d,
		0x45, 0xec, 0x06, 0x15, 0x93, 0xd4, 0x42, 0xc6, 0x2a, 0xb9,
		0xce, 0x3b, 0x1c, 0xb9, 0x94, 0x3a, 0x1d, 0x23, 0xa5, 0xea,
		0x3b, 0xcf, 0x21, 0xa0, 0x14, 0x71, 0xe6, 0x7e, 0x00, 0x3e, /* 200 */
		0x7f, 0x8a, 0x69, 0xc7, 0x28, 0xbe, 0x49, 0x0b, 0x2f, 0xc8,
		0x8c, 0xfe, 0xb9, 0x2d, 0xb6, 0xa2, 0x15, 0xe5, 0xd0, 0x3c,
		0x17, 0xc4, 0x64, 0xc9, 0xac, 0x1a, 0x46, 0xe2, 0x03, 0xe1,
		0x3f, 0x95, 0x29, 0x95, 0xfb, 0x03, 0xc6, 0x9d, 0x3c, 0xc4,
		0x7f, 0xcb, 0x51, 0x0b, 0x69, 0x98, 0xff, 0xd3, 0xaa, 0x6d,
		0xe7, 0x3c, 0xf9, 0xf6, 0x38, 0x69)
};

ke_test_vector_t modp2048_256 = {
	.method = MODP_2048_256,
	.seed = chunk_from_chars(
		0x08, 0x81, 0x38, 0x2c, 0xdb, 0x87, 0x66, 0x0c, 0x6d, 0xc1,
		0x3e, 0x61, 0x49, 0x38, 0xd5, 0xb9, 0xc8, 0xb2, 0xf2, 0x48,
		0x58, 0x1c, 0xc5, 0xe3, 0x1b, 0x35, 0x45, 0x43, 0x97, 0xfc,
		0xe5, 0x0e, /* - */
		0x7d, 0x62, 0xa7, 0xe3, 0xef, 0x36, 0xde, 0x61, 0x7b, 0x13,
		0xd1, 0xaf, 0xb8, 0x2c, 0x78, 0x0d, 0x83, 0xa2, 0x3b, 0xd4,
		0xee, 0x67, 0x05, 0x64, 0x51, 0x21, 0xf3, 0x71, 0xf5, 0x46,
		0xa5, 0x3d),
	.pub_i = chunk_from_chars(
		0x2e, 0x93, 0x80, 0xc8, 0x32, 0x3a, 0xf9, 0x75, 0x45, 0xbc,
		0x49, 0x41, 0xde, 0xb0, 0xec, 0x37, 0x42, 0xc6, 0x2f, 0xe0,
		0xec, 0xe8, 0x24, 0xa6, 0xab, 0xdb, 0xe6, 0x6c, 0x59, 0xbe,
		0xe0, 0x24, 0x29, 0x11, 0xbf, 0xb9, 0x67, 0x23, 0x5c, 0xeb,
		0xa3, 0x5a, 0xe1, 0x3e, 0x4e, 0xc7, 0x52, 0xbe, 0x63, 0x0b,
		0x92, 0xdc, 0x4b, 0xde, 0x28, 0x47, 0xa9, 0xc6, 0x2c, 0xb8,
		0x15, 0x27, 0x45, 0x42, 0x1f, 0xb7, 0xeb, 0x60, 0xa6, 0x3c,
		0x0f, 0xe9, 0x15, 0x9f, 0xcc, 0xe7, 0x26, 0xce, 0x7c, 0xd8,
		0x52, 0x3d, 0x74, 0x50, 0x66, 0x7e, 0xf8, 0x40, 0xe4, 0x91,
		0x91, 0x21, 0xeb, 0x5f, 0x01, 0xc8, 0xc9, 0xb0, 0xd3, 0xd6, /* 100 */
		0x48, 0xa9, 0x3b, 0xfb, 0x75, 0x68, 0x9e, 0x82, 0x44, 0xac,
		0x13, 0x4a, 0xf5, 0x44, 0x71, 0x1c, 0xe7, 0x9a, 0x02, 0xdc,
		0xc3, 0x42, 0x26, 0x68, 0x47, 0x80, 0xdd, 0xdc, 0xb4, 0x98,
		0x59, 0x41, 0x06, 0xc3, 0x7f, 0x5b, 0xc7, 0x98, 0x56, 0x48,
		0x7a, 0xf5, 0xab, 0x02, 0x2a, 0x2e, 0x5e, 0x42, 0xf0, 0x98,
		0x97, 0xc1, 0xa8, 0x5a, 0x11, 0xea, 0x02, 0x12, 0xaf, 0x04,
		0xd9, 0xb4, 0xce, 0xbc, 0x93, 0x7c, 0x3c, 0x1a, 0x3e, 0x15,
		0xa8, 0xa0, 0x34, 0x2e, 0x33, 0x76, 0x15, 0xc8, 0x4e, 0x7f,
		0xe3, 0xb8, 0xb9, 0xb8, 0x7f, 0xb1, 0xe7, 0x3a, 0x15, 0xaf,
		0x12, 0xa3, 0x0d, 0x74, 0x6e, 0x06, 0xdf, 0xc3, 0x4f, 0x29, /* 200 */
		0x0d, 0x79, 0x7c, 0xe5, 0x1a, 0xa1, 0x3a, 0xa7, 0x85, 0xbf,
		0x66, 0x58, 0xaf, 0xf5, 0xe4, 0xb0, 0x93, 0x00, 0x3c, 0xbe,
		0xaf, 0x66, 0x5b, 0x3c, 0x2e, 0x11, 0x3a, 0x3a, 0x4e, 0x90,
		0x52, 0x69, 0x34, 0x1d, 0xc0, 0x71, 0x14, 0x26, 0x68, 0x5f,
		0x4e, 0xf3, 0x7e, 0x86, 0x8a, 0x81, 0x26, 0xff, 0x3f, 0x22,
		0x79, 0xb5, 0x7c, 0xa6, 0x7e, 0x29),
	.pub_r = chunk_from_chars(
		0x57, 0x5f, 0x03, 0x51, 0xbd, 0x2b, 0x1b, 0x81, 0x74, 0x48,
		0xbd, 0xf8, 0x7a, 0x6c, 0x36, 0x2c, 0x1e, 0x28, 0x9d, 0x39,
		0x03, 0xa3, 0x0b, 0x98, 0x32, 0xc5, 0x74, 0x1f, 0xa2, 0x50,
		0x36, 0x3e, 0x7a, 0xcb, 0xc7, 0xf7, 0x7f, 0x3d, 0xac, 0xbc,
		0x1f, 0x13, 0x1a, 0xdd, 0x8e, 0x03, 0x36, 0x7e, 0xff, 0x8f,
		0xbb, 0xb3, 0xe1, 0xc5, 0x78, 0x44, 0x24, 0x80, 0x9b, 0x25,
		0xaf, 0xe4, 0xd2, 0x26, 0x2a, 0x1a, 0x6f, 0xd2, 0xfa, 0xb6,
		0x41, 0x05, 0xca, 0x30, 0xa6, 0x74, 0xe0, 0x7f, 0x78, 0x09,
		0x85, 0x20, 0x88, 0x63, 0x2f, 0xc0, 0x49, 0x23, 0x37, 0x91,
		0xad, 0x4e, 0xdd, 0x08, 0x3a, 0x97, 0x8b, 0x88, 0x3e, 0xe6, /* 100 */
		0x18, 0xbc, 0x5e, 0x0d, 0xd0, 0x47, 0x41, 0x5f, 0x2d, 0x95,
		0xe6, 0x83, 0xcf, 0x14, 0x82, 0x6b, 0x5f, 0xbe, 0x10, 0xd3,
		0xce, 0x41, 0xc6, 0xc1, 0x20, 0xc7, 0x8a, 0xb2, 0x00, 0x08,
		0xc6, 0x98, 0xbf, 0x7f, 0x0b, 0xca, 0xb9, 0xd7, 0xf4, 0x07,
		0xbe, 0xd0, 0xf4, 0x3a, 0xfb, 0x29, 0x70, 0xf5, 0x7f, 0x8d,
		0x12, 0x04, 0x39, 0x63, 0xe6, 0x6d, 0xdd, 0x32, 0x0d, 0x59,
		0x9a, 0xd9, 0x93, 0x6c, 0x8f, 0x44, 0x13, 0x7c, 0x08, 0xb1,
		0x80, 0xec, 0x5e, 0x98, 0x5c, 0xeb, 0xe1, 0x86, 0xf3, 0xd5,
		0x49, 0x67, 0x7e, 0x80, 0x60, 0x73, 0x31, 0xee, 0x17, 0xaf,
		0x33, 0x80, 0xa7, 0x25, 0xb0, 0x78, 0x23, 0x17, 0xd7, 0xdd, /* 200 */
		0x43, 0xf5, 0x9d, 0x7a, 0xf9, 0x56, 0x8a, 0x9b, 0xb6, 0x3a,
		0x84, 0xd3, 0x65, 0xf9, 0x22, 0x44, 0xed, 0x12, 0x09, 0x88,
		0x21, 0x93, 0x02, 0xf4, 0x29, 0x24, 0xc7, 0xca, 0x90, 0xb8,
		0x9d, 0x24, 0xf7, 0x1b, 0x0a, 0xb6, 0x97, 0x82, 0x3d, 0x7d,
		0xeb, 0x1a, 0xff, 0x5b, 0x0e, 0x8e, 0x4a, 0x45, 0xd4, 0x9f,
		0x7f, 0x53, 0x75, 0x7e, 0x19, 0x13),
	.shared = chunk_from_chars(
		0x86, 0xc7, 0x0b, 0xf8, 0xd0, 0xbb, 0x81, 0xbb, 0x01, 0x07,
		0x8a, 0x17, 0x21, 0x9c, 0xb7, 0xd2, 0x72, 0x03, 0xdb, 0x2a,
		0x19, 0xc8, 0x77, 0xf1, 0xd1, 0xf1, 0x9f, 0xd7, 0xd7, 0x7e,
		0xf2, 0x25, 0x46, 0xa6, 0x8f, 0x00, 0x5a, 0xd5, 0x2d, 0xc8,
		0x45, 0x53, 0xb7, 0x8f, 0xc6, 0x03, 0x30, 0xbe, 0x51, 0xea,
		0x7c, 0x06, 0x72, 0xca, 0xc1, 0x51, 0x5e, 0x4b, 0x35, 0xc0,
		0x47, 0xb9, 0xa5, 0x51, 0xb8, 0x8f, 0x39, 0xdc, 0x26, 0xda,
		0x14, 0xa0, 0x9e, 0xf7, 0x47, 0x74, 0xd4, 0x7c, 0x76, 0x2d,
		0xd1, 0x77, 0xf9, 0xed, 0x5b, 0xc2, 0xf1, 0x1e, 0x52, 0xc8,
		0x79, 0xbd, 0x95, 0x09, 0x85, 0x04, 0xcd, 0x9e, 0xec, 0xd8, /* 100 */
		0xa8, 0xf9, 0xb3, 0xef, 0xbd, 0x1f, 0x00, 0x8a, 0xc5, 0x85,
		0x30, 0x97, 0xd9, 0xd1, 0x83, 0x7f, 0x2b, 0x18, 0xf7, 0x7c,
		0xd7, 0xbe, 0x01, 0xaf, 0x80, 0xa7, 0xc7, 0xb5, 0xea, 0x3c,
		0xa5, 0x4c, 0xc0, 0x2d, 0x0c, 0x11, 0x6f, 0xee, 0x3f, 0x95,
		0xbb, 0x87, 0x39, 0x93, 0x85, 0x87, 0x5d, 0x7e, 0x86, 0x74,
		0x7e, 0x67, 0x6e, 0x72, 0x89, 0x38, 0xac, 0xbf, 0xf7, 0x09,
		0x8e, 0x05, 0xbe, 0x4d, 0xcf, 0xb2, 0x40, 0x52, 0xb8, 0x3a,
		0xef, 0xfb, 0x14, 0x78, 0x3f, 0x02, 0x9a, 0xdb, 0xde, 0x7f,
		0x53, 0xfa, 0xe9, 0x20, 0x84, 0x22, 0x40, 0x90, 0xe0, 0x07,
		0xce, 0xe9, 0x4d, 0x4b, 0xf2, 0xba, 0xce, 0x9f, 0xfd, 0x4b, /* 200 */
		0x57, 0xd2, 0xaf, 0x7c, 0x72, 0x4d, 0x0c, 0xaa, 0x19, 0xbf,
		0x05, 0x01, 0xf6, 0xf1, 0x7b, 0x4a, 0xa1, 0x0f, 0x42, 0x5e,
		0x3e, 0xa7, 0x60, 0x80, 0xb4, 0xb9, 0xd6, 0xb3, 0xce, 0xfe,
		0xa1, 0x15, 0xb2, 0xce, 0xb8, 0x78, 0x9b, 0xb8, 0xa3, 0xb0,
		0xea, 0x87, 0xfe, 0xbe, 0x63, 0xb6, 0xc8, 0xf8, 0x46, 0xec,
		0x6d, 0xb0, 0xc2, 0x6c, 0x5d, 0x7c)
};
