package com.windscribe.mobile.ui.nav

sealed class Screen(val route: String) {
    object Start : Screen("start")
    object Login : Screen("login")
    object Signup : Screen("signup")
    object Home : Screen("home")
    object NoEmailAttention : Screen("no_email_attention")
    object Newsfeed : Screen("newsfeed")
    object EmergencyConnect : Screen("emergency_connect")
    object PowerWhitelist : Screen("power_whitelist")
    object ShareLink : Screen("share_link")
    object AccountStatus : Screen("account_status")
    object LocationUnderMaintenance : Screen("location_under_maintenance")
    object EditCustomConfig : Screen("edit_custom_config")
    object ConnectionChange : Screen("connection_change")
    object ConnectionFailure : Screen("connection_failure")
    object SetupPreferredProtocol : Screen("setup_preferred_protocol")
    object DebugLogSent : Screen("debug_log_sent")
    object AllProtocolFailed : Screen("all_protocol_failed")
    object OverlayDialog: Screen("overlay_dialog")
    object MainMenu: Screen("main_menu")
    object General: Screen("general")
    object Account: Screen("account")
    object Connection: Screen("connection")
    object Robert: Screen("robert")
    object LookAndFeel: Screen("look_and_feel")
    object HelpMe: Screen("help_me")
    object About: Screen("about")
    object Ticket: Screen("ticket")
    object Debug: Screen("debug")
    object Advance: Screen("advance")
    object NetworkOptions : Screen("network_options")
    object NetworkDetails : Screen("network_details")
    object SplitTunnel : Screen("split_tunnel")
    object ExtraDataUseWarning: Screen("extra_data_use_warning")
    object GpsSpoofing: Screen("gps_spoofing")
    object AddEmail: Screen("add_email")
    object ConfirmEmail: Screen("confirm_email")
    
    object AllProtocolFailedDialog: Screen("all_protocol_failed_dialog")
}