package com.w2sv.filenavigator.ui.navigation

import androidx.compose.animation.core.CubicBezierEasing
import androidx.compose.animation.core.FiniteAnimationSpec
import androidx.compose.animation.core.LinearEasing
import androidx.compose.animation.core.LinearOutSlowInEasing
import androidx.compose.animation.core.tween
import androidx.compose.animation.fadeIn
import androidx.compose.animation.fadeOut
import androidx.compose.animation.slideInHorizontally
import androidx.compose.animation.slideOutHorizontally
import androidx.compose.ui.unit.IntOffset
import com.w2sv.kotlinutils.threadUnsafeLazy

private const val ANIMATION_DURATION = 300

object NavAnimation {

    private val easing by threadUnsafeLazy { CubicBezierEasing(0.2f, 0.0f, 0.0f, 1.0f) }

    object NonPop {

        fun enter() =
            slideInHorizontally(
                initialOffsetX = { it / 2 },
                animationSpec = slideAnimationSpec
            ) + fadeIn(animationSpec = fadeAnimationSpec)

        fun exit() =
            slideOutHorizontally(
                targetOffsetX = { -it },
                animationSpec = slideAnimationSpec
            ) + fadeOut(
                animationSpec = fadeAnimationSpec,
                targetAlpha = 0.55f
            )

        private val slideAnimationSpec: FiniteAnimationSpec<IntOffset> by threadUnsafeLazy {
            tween(
                durationMillis = (ANIMATION_DURATION * 1.5).toInt(),
                easing = easing
            )
        }

        private val fadeAnimationSpec: FiniteAnimationSpec<Float> by threadUnsafeLazy {
            tween(
                durationMillis = ANIMATION_DURATION,
                delayMillis = ANIMATION_DURATION / 4,
                easing = LinearOutSlowInEasing
            )
        }
    }

    object Pop {

        fun enter() =
            slideInHorizontally(
                initialOffsetX = { -it / 2 },
                animationSpec = slideAnimationSpec
            ) + fadeIn(animationSpec = fadeAnimationSpec)

        fun exit() =
            slideOutHorizontally(
                targetOffsetX = { it },
                animationSpec = slideAnimationSpec
            ) + fadeOut(
                animationSpec = fadeAnimationSpec,
                targetAlpha = 0.65f
            )

        private val slideAnimationSpec: FiniteAnimationSpec<IntOffset> by threadUnsafeLazy {
            tween(
                durationMillis = (ANIMATION_DURATION * 1.2).toInt(),
                easing = easing
            )
        }

        private val fadeAnimationSpec: FiniteAnimationSpec<Float> by threadUnsafeLazy {
            tween(
                durationMillis = ANIMATION_DURATION / 2,
                delayMillis = ANIMATION_DURATION / 4,
                easing = LinearEasing
            )
        }
    }
}
