/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.crypto.modes;

import org.gudy.bouncycastle.crypto.BlockCipher;
import org.gudy.bouncycastle.crypto.CipherParameters;
import org.gudy.bouncycastle.crypto.DataLengthException;
import org.gudy.bouncycastle.crypto.params.ParametersWithIV;

public class SICBlockCipher
implements BlockCipher {
    private BlockCipher cipher = null;
    private int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private boolean encrypting;

    public SICBlockCipher(BlockCipher c) {
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.encrypting = forEncryption;
        if (params instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)params;
            byte[] iv = ivParam.getIV();
            System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
            this.reset();
            this.cipher.init(true, ivParam.getParameters());
        }
    }

    @Override
    public String getAlgorithmName() {
        return String.valueOf(this.cipher.getAlgorithmName()) + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        int i = 0;
        while (i < this.counterOut.length) {
            out[outOff + i] = (byte)(this.counterOut[i] ^ in[inOff + i]);
            ++i;
        }
        int carry = 1;
        int i2 = this.counter.length - 1;
        while (i2 >= 0) {
            int x = (this.counter[i2] & 0xFF) + carry;
            carry = x > 255 ? 1 : 0;
            this.counter[i2] = (byte)x;
            --i2;
        }
        return this.counter.length;
    }

    @Override
    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
    }
}

