/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.gudy.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.gudy.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.gudy.bouncycastle.crypto.KeyGenerationParameters;
import org.gudy.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.gudy.bouncycastle.crypto.params.DHParameters;
import org.gudy.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.gudy.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int qLength = this.param.getStrength() - 1;
        DHParameters dhParams = this.param.getParameters();
        BigInteger p = dhParams.getP();
        BigInteger g = dhParams.getG();
        BigInteger x = new BigInteger(qLength, this.param.getRandom());
        BigInteger y = g.modPow(x, p);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhParams), new DHPrivateKeyParameters(x, dhParams));
    }
}

