/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.multiuser;

import com.aelitis.azureus.core.AzureusCore;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.UserProfile;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;
import org.gudy.azureus2.ui.console.multiuser.commands.Show;

public class MultiUserConsoleInput
extends ConsoleInput {
    private List adminCommands;
    private List userCommands;

    public MultiUserConsoleInput(String con, AzureusCore _azureus_core, Reader _in, PrintStream _out, Boolean _controlling, UserProfile profile) {
        super(con, _azureus_core, _in, _out, _controlling, profile);
    }

    @Override
    protected void initialise() {
        this.adminCommands = new ArrayList();
        this.adminCommands.add("quit");
        this.adminCommands.add("share");
        this.adminCommands.add("user");
        this.adminCommands.add("move");
        this.adminCommands.add("log");
        this.adminCommands.add("ui");
        this.userCommands = new ArrayList();
        this.userCommands.add("set");
        this.userCommands.add("alias");
        this.userCommands.add("add");
        super.initialise();
    }

    @Override
    protected void registerCommands() {
        super.registerCommands();
        this.registerCommand(new Show());
    }

    @Override
    public void registerCommand(IConsoleCommand command) {
        if (!"admin".equals(this.getUserProfile().getUserType())) {
            Set commandNames = command.getCommandNames();
            for (String cmdName : commandNames) {
                if (this.adminCommands.contains(cmdName)) {
                    return;
                }
                if ("user".equals(this.getUserProfile().getUserType()) || !this.userCommands.contains(cmdName)) continue;
                return;
            }
        }
        super.registerCommand(command);
    }
}

