/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import com.aelitis.azureus.core.AzureusCoreException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.download.DownloadManager;

public class TorrentFilter {
    private static final Pattern rangePattern = Pattern.compile("([0-9]+)\\s*((-)|(-\\s*([0-9]+)))?");

    private List matchRange(List torrents, String filter2) {
        Matcher matcher = rangePattern.matcher(filter2);
        ArrayList list = new ArrayList();
        if (matcher.matches()) {
            int minId = Integer.parseInt(matcher.group(1));
            if (minId == 0) {
                throw new AzureusCoreException("lower range must be greater than 0");
            }
            if (minId > torrents.size()) {
                throw new AzureusCoreException("lower range specified (" + minId + ") is outside number of torrents (" + torrents.size() + ")");
            }
            if (matcher.group(2) == null) {
                list.add(torrents.get(minId - 1));
                return list;
            }
            int maxId = matcher.group(3) == null ? Integer.parseInt(matcher.group(5)) : torrents.size();
            if (minId > maxId) {
                throw new AzureusCoreException("when specifying a range, the max value must be greater than or equal to the min value");
            }
            int i = minId - 1;
            while (i < maxId && i < torrents.size()) {
                list.add(torrents.get(i));
                ++i;
            }
        }
        return list;
    }

    private List matchWildcard(List torrents, String filter2) {
        Pattern pattern = Pattern.compile(this.wildcardToPattern(filter2), 2);
        ArrayList<DownloadManager> list = new ArrayList<DownloadManager>();
        for (DownloadManager dm : torrents) {
            if (!pattern.matcher(dm.getDisplayName()).matches()) continue;
            list.add(dm);
        }
        return list;
    }

    private String wildcardToPattern(String wild) {
        if (wild == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = wild.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '*') {
                buffer.append(".*");
            } else if (chars[i] == '?') {
                buffer.append(".");
            } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString().toLowerCase();
    }

    public List getTorrents(List torrentsToMatch, String filter2) {
        ArrayList torrents = new ArrayList();
        torrents.addAll(this.matchRange(torrentsToMatch, filter2));
        torrents.addAll(this.matchWildcard(torrentsToMatch, filter2));
        return torrents;
    }

    public List getTorrents(List torrentsToMatch, List args) {
        StringBuffer allArgs = new StringBuffer();
        boolean first = true;
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            if (!first) {
                allArgs.append(",");
            } else {
                first = false;
            }
            allArgs.append(iter.next());
        }
        List torrents = this.matchWildcard(torrentsToMatch, allArgs.toString());
        if (torrents.size() > 0) {
            return torrents;
        }
        torrents = this.matchRange(torrentsToMatch, allArgs.toString());
        if (torrents.size() > 0) {
            return torrents;
        }
        Iterator iter2 = args.iterator();
        while (iter2.hasNext()) {
            torrents.addAll(this.getTorrents(torrentsToMatch, (String)iter2.next()));
        }
        return torrents;
    }
}

