/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.console.ConsoleInput;

public abstract class IConsoleCommand {
    private String main_name;
    private String short_name;
    private HashSet commands = new HashSet();

    public IConsoleCommand(String main_name) {
        this(main_name, null);
    }

    public IConsoleCommand(String main_name, String short_name) {
        this.main_name = main_name;
        this.short_name = short_name;
        if (main_name != null) {
            this.commands.add(main_name);
        }
        if (short_name != null) {
            this.commands.add(short_name);
        }
    }

    public abstract void execute(String var1, ConsoleInput var2, List<String> var3);

    public abstract String getCommandDescriptions();

    public final void printHelp(PrintStream out, List<String> args) {
        out.println(this.getCommandDescriptions());
        this.printHelpExtra(out, args);
    }

    public void printHelpExtra(PrintStream out, List<String> args) {
    }

    protected final void printHelp(PrintStream out, String arg) {
        ArrayList<String> args;
        if (arg != null) {
            args = new ArrayList<String>();
            args.add(arg);
        } else {
            args = Collections.EMPTY_LIST;
        }
        this.printHelp(out, args);
    }

    public Set getCommandNames() {
        return Collections.unmodifiableSet(this.commands);
    }

    public final String getCommandName() {
        return this.main_name;
    }

    public final String getShortCommandName() {
        return this.short_name;
    }

    protected String getTorrentSummary(DownloadManager dm) {
        StringBuffer tstate = new StringBuffer();
        String summaryFormat = this.getDefaultSummaryFormat();
        int lastch = 48;
        char[] summaryChars = summaryFormat.toCharArray();
        int i = 0;
        while (i < summaryChars.length) {
            int ch = summaryChars[i];
            if (ch == 37 && lastch != 92) {
                if (++i >= summaryChars.length) {
                    tstate.append('%');
                } else {
                    tstate.append(this.expandVariable(summaryChars[i], dm));
                }
            } else {
                tstate.append((char)ch);
            }
            lastch = ch;
            ++i;
        }
        return tstate.toString();
    }

    protected String expandVariable(char variable, DownloadManager dm) {
        switch (variable) {
            case 'a': {
                return IConsoleCommand.getShortStateString(dm.getState());
            }
            case 'c': {
                DecimalFormat df = new DecimalFormat("000.0%");
                return df.format((double)dm.getStats().getCompleted() / 1000.0);
            }
            case 't': {
                if (dm.getState() == 100) {
                    return dm.getErrorDetails();
                }
                if (dm.getDisplayName() == null) {
                    return "?";
                }
                return dm.getDisplayName();
            }
            case 'z': {
                return DisplayFormatters.formatByteCountToKiBEtc(dm.getSize());
            }
            case 'e': {
                return DisplayFormatters.formatETA(dm.getStats().getSmoothedETA());
            }
            case 'r': {
                DiskManagerFileInfo[] files;
                long to = 0L;
                long tot = 0L;
                if (dm.getDiskManager() != null && (files = dm.getDiskManager().getFiles()) != null && files.length > 1) {
                    int c = 0;
                    int i = 0;
                    while (i < files.length) {
                        if (files[i] != null && !files[i].isSkipped()) {
                            ++c;
                            tot += files[i].getLength();
                            to += files[i].getDownloaded();
                        }
                        ++i;
                    }
                    if (c == files.length) {
                        tot = 0L;
                    }
                }
                DecimalFormat df1 = new DecimalFormat("000.0%");
                if (tot > 0L) {
                    return "      (" + df1.format((double)to * 1.0 / (double)tot) + ")";
                }
                return "\t";
            }
            case 'd': {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(dm.getStats().getDataReceiveRate());
            }
            case 'u': {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(dm.getStats().getDataSendRate());
            }
            case 'D': {
                return DisplayFormatters.formatDownloaded(dm.getStats());
            }
            case 'U': {
                return DisplayFormatters.formatByteCountToKiBEtc(dm.getStats().getTotalDataBytesSent());
            }
            case 's': {
                return Integer.toString(dm.getNbSeeds());
            }
            case 'p': {
                return Integer.toString(dm.getNbPeers());
            }
            case 'v': {
                return Integer.toString(dm.getMaxUploads());
            }
            case 'I': {
                int downloadSpeed = dm.getStats().getDownloadRateLimitBytesPerSecond();
                if (downloadSpeed <= 0) {
                    return "";
                }
                return "(max " + DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadSpeed) + ")";
            }
            case 'O': {
                int uploadSpeed = dm.getStats().getUploadRateLimitBytesPerSecond();
                if (uploadSpeed <= 0) {
                    return "";
                }
                return "(max " + DisplayFormatters.formatByteCountToKiBEtcPerSec(uploadSpeed) + ")";
            }
            case 'P': 
            case 'S': {
                TRTrackerScraperResponse hd = dm.getTrackerScrapeResponse();
                if (hd == null || !hd.isValid()) {
                    return "?";
                }
                if (variable == 'S') {
                    return Integer.toString(hd.getSeeds());
                }
                return Integer.toString(hd.getPeers());
            }
        }
        return "??" + variable + "??";
    }

    protected String getDefaultSummaryFormat() {
        return "[%a] %c\t%t (%z) ETA: %e\r\n%r\tSpeed: %d%I / %u%O\tAmount: %D / %U\tConnections: %s(%S) / %p(%P)";
    }

    private static String getShortStateString(int dmstate) {
        switch (dmstate) {
            case 5: {
                return "I";
            }
            case 20: {
                return "A";
            }
            case 30: {
                return "C";
            }
            case 50: {
                return ">";
            }
            case 100: {
                return "E";
            }
            case 60: {
                return "*";
            }
            case 70: {
                return "!";
            }
            case 0: {
                return ".";
            }
            case 40: {
                return ":";
            }
            case 75: {
                return "-";
            }
        }
        return "?";
    }

    protected static final class TorrentComparator
    implements Comparator<DownloadManager> {
        protected TorrentComparator() {
        }

        @Override
        public final int compare(DownloadManager aDL, DownloadManager bDL) {
            boolean bIsComplete;
            boolean aIsComplete = aDL.getStats().getDownloadCompleted(false) == 1000;
            boolean bl = bIsComplete = bDL.getStats().getDownloadCompleted(false) == 1000;
            if (aIsComplete && !bIsComplete) {
                return 1;
            }
            if (!aIsComplete && bIsComplete) {
                return -1;
            }
            return aDL.getPosition() - bDL.getPosition();
        }
    }
}

