/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common;

import com.aelitis.azureus.core.impl.AzureusCoreSingleInstanceClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.common.Main;

public class StartServer
extends Thread {
    private ServerSocket socket;
    private int state;
    private boolean bContinue;
    public static final int STATE_FAULTY = 0;
    public static final int STATE_LISTENING = 1;

    public StartServer() {
        super("Start Server");
        int instance_port = Constants.INSTANCE_PORT;
        try {
            this.socket = new ServerSocket(instance_port, 50, InetAddress.getByName("127.0.0.1"));
            this.state = 1;
            Logger.getLogger("azureus2").info("StartServer: listening on 127.0.0.1:" + instance_port + " for passed torrent info");
        }
        catch (Exception e) {
            this.state = 0;
            System.out.println("StartServer ERROR: unable to bind to 127.0.0.1:" + instance_port + " for passed torrent info");
        }
    }

    @Override
    public void run() {
        this.bContinue = true;
        while (this.bContinue) {
            BufferedReader br = null;
            try {
                try {
                    String line;
                    Socket sck = this.socket.accept();
                    AzureusCoreSingleInstanceClient.sendReply(sck);
                    String address = sck.getInetAddress().getHostAddress();
                    if ((address.equals("localhost") || address.equals("127.0.0.1")) && (line = (br = new BufferedReader(new InputStreamReader(sck.getInputStream()))).readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, ";");
                        ArrayList<String> argsList = new ArrayList<String>();
                        while (st.hasMoreElements()) {
                            argsList.add(st.nextToken().replaceAll("&;", ";").replaceAll("&&", "&"));
                        }
                        if (argsList.size() > 1) {
                            String checker = (String)argsList.remove(0);
                            if (checker.equals("Azureus Start Server Access")) {
                                if (argsList.get(0).equals("args")) {
                                    argsList.remove(0);
                                    String[] newargs = new String[argsList.size()];
                                    argsList.toArray(newargs);
                                    Main.processArgs(newargs, null, null);
                                } else {
                                    Logger.getLogger("azureus2").error("Something strange was sent to the StartServer: " + line);
                                }
                            } else {
                                Logger.getLogger("azureus2").error("StartServer: Wrong access token.");
                            }
                        }
                    }
                    sck.close();
                }
                catch (Exception e) {
                    if (!(e instanceof SocketException)) {
                        e.printStackTrace();
                    }
                    this.bContinue = false;
                    try {
                        if (br == null) continue;
                        br.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (br == null) continue;
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopIt() {
        this.bContinue = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getServerState() {
        return this.state;
    }
}

