/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public abstract class ResourceDownloaderBaseImpl
implements ResourceDownloader {
    private static final String PR_PROPERTIES_SET = "!!!! properties set !!!!";
    private List listeners = new ArrayList();
    private boolean result_informed;
    private Object result_informed_data;
    private ResourceDownloaderBaseImpl parent;
    private List children = new ArrayList();
    private boolean download_cancelled;
    private Map lc_key_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("ResourceDownloader");

    protected ResourceDownloaderBaseImpl(ResourceDownloaderBaseImpl _parent) {
        this.parent = _parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    @Override
    public ResourceDownloader getClone() {
        return this.getClone(null);
    }

    public abstract ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl var1);

    protected abstract void setSize(long var1);

    public boolean getBooleanProperty(String key) throws ResourceDownloaderException {
        Object obj = this.getProperty(key);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public long getLongProperty(String key) throws ResourceDownloaderException {
        Object obj = this.getProperty(key);
        if (obj == null || !(obj instanceof Number)) {
            return -1L;
        }
        return ((Number)obj).longValue();
    }

    public String getStringProperty(String key) throws ResourceDownloaderException {
        Object obj = this.getProperty(key);
        if (obj == null || obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof List) {
            List l = (List)obj;
            if (l.size() == 0) {
                return null;
            }
            obj = l.get(0);
            if (obj instanceof String) {
                return (String)obj;
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String name) throws ResourceDownloaderException {
        Object res = this.getPropertySupport(name);
        if (res != null || this.getPropertySupport(PR_PROPERTIES_SET) != null || name.equalsIgnoreCase("URL_Connection") || name.equalsIgnoreCase("URL_Connect_Timeout") || name.equalsIgnoreCase("URL_Read_Timeout") || name.equalsIgnoreCase("URL_Trust_Content_Length") || name.equalsIgnoreCase("URL_HTTP_VERB")) {
            return res;
        }
        this.getSize();
        return this.getPropertySupport(name);
    }

    protected Object getPropertySupport(String name) {
        return this.lc_key_properties.get(name.toLowerCase(MessageText.LOCALE_ENGLISH));
    }

    protected Map getLCKeyProperties() {
        return this.lc_key_properties;
    }

    protected String getStringPropertySupport(String name) {
        Object obj = this.lc_key_properties.get(name.toLowerCase(MessageText.LOCALE_ENGLISH));
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected void setPropertiesSet() throws ResourceDownloaderException {
        this.setProperty(PR_PROPERTIES_SET, "true");
    }

    protected void setPropertySupport(String name, Object value) {
        boolean already_set;
        boolean bl = already_set = this.lc_key_properties.put(name.toLowerCase(MessageText.LOCALE_ENGLISH), value) == value;
        if (this.parent != null && !already_set) {
            try {
                this.parent.setProperty(name, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void setProperties(ResourceDownloaderBaseImpl other) {
        Map p = other.lc_key_properties;
        for (String key : p.keySet()) {
            try {
                this.setProperty(key, p.get(key));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void setParent(ResourceDownloader _parent) {
        ResourceDownloaderBaseImpl old_parent = this.parent;
        this.parent = (ResourceDownloaderBaseImpl)_parent;
        if (old_parent != null) {
            old_parent.removeChild(this);
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    protected ResourceDownloaderBaseImpl getParent() {
        return this.parent;
    }

    protected void addChild(ResourceDownloaderBaseImpl kid) {
        this.children.add(kid);
    }

    protected void removeChild(ResourceDownloaderBaseImpl kid) {
        this.children.remove(kid);
    }

    protected List getChildren() {
        return this.children;
    }

    protected String getLogIndent() {
        String indent = "";
        ResourceDownloaderBaseImpl pos = this.parent;
        while (pos != null) {
            indent = String.valueOf(indent) + "  ";
            pos = pos.getParent();
        }
        return indent;
    }

    protected void addReportListener(ResourceDownloader rd) {
        rd.addListener(new ResourceDownloaderAdapter(){

            @Override
            public void reportActivity(ResourceDownloader downloader, String activity) {
                ResourceDownloaderBaseImpl.this.informActivity(activity);
            }

            @Override
            public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                ResourceDownloaderBaseImpl.this.informActivity(String.valueOf(downloader.getName()) + ":" + e.getMessage());
            }
        });
    }

    protected void informPercentDone(int percentage) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ResourceDownloaderListener)this.listeners.get(i)).reportPercentComplete(this, percentage);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void informAmountComplete(long amount) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ResourceDownloaderListener)this.listeners.get(i)).reportAmountComplete(this, amount);
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void reportActivity(String str) {
        this.informActivity(str);
    }

    protected void informActivity(String activity) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ResourceDownloaderListener)this.listeners.get(i)).reportActivity(this, activity);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected boolean informComplete(InputStream is) {
        if (!this.result_informed) {
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    if (!((ResourceDownloaderListener)this.listeners.get(i)).completed(this, is)) {
                        return false;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return false;
                }
                ++i;
            }
            this.result_informed = true;
            this.result_informed_data = is;
        }
        return true;
    }

    protected void informFailed(ResourceDownloaderException e) {
        if (!this.result_informed) {
            this.result_informed = true;
            this.result_informed_data = e;
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((ResourceDownloaderListener)this.listeners.get(i)).failed(this, e);
                }
                catch (Throwable f) {
                    Debug.printStackTrace(f);
                }
                ++i;
            }
        }
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.informActivity(activity);
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        this.informPercentDone(percentage);
    }

    public void reportAmountComplete(ResourceDownloader downloader, long amount) {
        this.informAmountComplete(amount);
    }

    protected void setCancelled() {
        this.download_cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.download_cancelled;
    }

    @Override
    public void addListener(ResourceDownloaderListener l) {
        this.listeners.add(l);
        if (this.result_informed) {
            if (this.result_informed_data instanceof InputStream) {
                l.completed(this, (InputStream)this.result_informed_data);
            } else {
                l.failed(this, (ResourceDownloaderException)this.result_informed_data);
            }
        }
    }

    @Override
    public void removeListener(ResourceDownloaderListener l) {
        this.listeners.remove(l);
    }
}

