/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.ui.config.ColorParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class ColorParameterImpl
extends ParameterImpl
implements ColorParameter {
    private int r;
    private int g;
    private int b;
    private final int orig_r;
    private final int orig_g;
    private final int orig_b;

    public ColorParameterImpl(PluginConfigImpl config, String key, String label, int _r, int _g, int _b) {
        super(config, key, label);
        config.notifyRGBParamExists(this.getKey());
        COConfigurationManager.setIntDefault(String.valueOf(this.getKey()) + ".red", this.r);
        COConfigurationManager.setIntDefault(String.valueOf(this.getKey()) + ".green", this.g);
        COConfigurationManager.setIntDefault(String.valueOf(this.getKey()) + ".blue", this.b);
        COConfigurationManager.setBooleanDefault(String.valueOf(this.getKey()) + ".override", false);
        this.orig_r = this.r = _r;
        this.orig_g = this.g = _g;
        this.orig_b = this.b = _b;
    }

    @Override
    public int getRedValue() {
        return this.r;
    }

    @Override
    public int getGreenValue() {
        return this.g;
    }

    @Override
    public int getBlueValue() {
        return this.b;
    }

    public void reloadParamDataFromConfig(boolean override) {
        int[] rgb = this.config.getUnsafeColorParameter(this.getKey());
        this.r = rgb[0];
        this.g = rgb[1];
        this.b = rgb[2];
        this.config.setUnsafeBooleanParameter(String.valueOf(this.getKey()) + ".override", override);
    }

    @Override
    public void setRGBValue(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.config.setUnsafeColorParameter(this.getKey(), new int[]{r, g, b}, true);
    }

    public void resetToDefault() {
        this.config.setUnsafeColorParameter(this.getKey(), new int[]{this.orig_r, this.orig_g, this.orig_b}, false);
    }

    public boolean isOverridden() {
        return this.config.getUnsafeBooleanParameter(String.valueOf(this.getKey()) + ".override");
    }
}

