/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentFile;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentFileImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class TorrentImpl
extends LogRelation
implements Torrent {
    private static MagnetPlugin magnet_plugin;
    private PluginInterface pi;
    private TOTorrent torrent;
    private LocaleUtilDecoder decoder;
    private boolean complete;

    public TorrentImpl(TOTorrent _torrent) {
        this(null, _torrent);
    }

    public TorrentImpl(PluginInterface _pi, TOTorrent _torrent) {
        this.pi = _pi;
        this.torrent = _torrent;
    }

    @Override
    public String getName() {
        String utf8Name = this.torrent.getUTF8Name();
        String name = utf8Name == null ? this.decode(this.torrent.getName()) : utf8Name;
        name = FileUtil.convertOSSpecificChars(name, false);
        return name;
    }

    @Override
    public URL getAnnounceURL() {
        return this.torrent.getAnnounceURL();
    }

    @Override
    public void setAnnounceURL(URL url) {
        this.torrent.setAnnounceURL(url);
        this.updated();
    }

    @Override
    public TorrentAnnounceURLList getAnnounceURLList() {
        return new TorrentAnnounceURLListImpl(this);
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public boolean isDecentralised() {
        return TorrentUtils.isDecentralised(this.torrent);
    }

    @Override
    public boolean isDecentralisedBackupEnabled() {
        return TorrentUtils.getDHTBackupEnabled(this.torrent);
    }

    @Override
    public void setDecentralisedBackupRequested(boolean requested) {
        TorrentUtils.setDHTBackupRequested(this.torrent, requested);
    }

    @Override
    public boolean isDecentralisedBackupRequested() {
        return TorrentUtils.isDHTBackupRequested(this.torrent);
    }

    @Override
    public boolean isPrivate() {
        return TorrentUtils.getPrivate(this.torrent);
    }

    @Override
    public void setPrivate(boolean priv) {
        TorrentUtils.setPrivate(this.torrent, priv);
    }

    @Override
    public boolean wasCreatedByUs() {
        return TorrentUtils.isCreatedTorrent(this.torrent);
    }

    @Override
    public URL getMagnetURI() throws TorrentException {
        PluginInterface magnet_pi;
        if (magnet_plugin == null && (magnet_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class)) != null) {
            magnet_plugin = (MagnetPlugin)magnet_pi.getPlugin();
        }
        if (magnet_plugin == null) {
            throw new TorrentException("MegnetPlugin unavailable");
        }
        try {
            URL res = magnet_plugin.getMagnetURL(this.torrent.getHash());
            return res;
        }
        catch (TOTorrentException e) {
            throw new TorrentException(e);
        }
    }

    @Override
    public byte[] getHash() {
        try {
            return this.torrent.getHash();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public long getSize() {
        return this.torrent.getSize();
    }

    @Override
    public String getComment() {
        return this.decode(this.torrent.getComment());
    }

    @Override
    public void setComment(String comment) {
        this.torrent.setComment(comment);
    }

    @Override
    public long getCreationDate() {
        return this.torrent.getCreationDate();
    }

    @Override
    public String getCreatedBy() {
        return this.decode(this.torrent.getCreatedBy());
    }

    @Override
    public long getPieceSize() {
        return this.torrent.getPieceLength();
    }

    @Override
    public long getPieceCount() {
        return this.torrent.getNumberOfPieces();
    }

    @Override
    public byte[][] getPieces() {
        try {
            return this.torrent.getPieces();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return new byte[0][0];
        }
    }

    @Override
    public TorrentFile[] getFiles() {
        TOTorrentFile[] files = this.torrent.getFiles();
        TorrentFile[] res = new TorrentFile[files.length];
        int i = 0;
        while (i < res.length) {
            TOTorrentFile tf = files[i];
            byte[][] comps = tf.getPathComponents();
            String name = "";
            int j = 0;
            while (j < comps.length) {
                String comp2 = this.decode(comps[j]);
                comp2 = FileUtil.convertOSSpecificChars(comp2, j != comps.length - 1);
                name = String.valueOf(name) + (j == 0 ? "" : File.separator) + comp2;
                ++j;
            }
            res[i] = new TorrentFileImpl(name, tf.getLength());
            ++i;
        }
        return res;
    }

    protected void getDecoder() {
        try {
            this.decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getEncoding() {
        this.getDecoder();
        if (this.decoder != null) {
            return this.decoder.getName();
        }
        return "UTF8";
    }

    @Override
    public void setEncoding(String encoding) throws TorrentEncodingException {
        try {
            LocaleTorrentUtil.setTorrentEncoding(this.torrent, encoding);
        }
        catch (LocaleUtilEncodingException e) {
            throw new TorrentEncodingException("Failed to set the encoding", e);
        }
    }

    @Override
    public void setDefaultEncoding() throws TorrentEncodingException {
        this.setEncoding("UTF8");
    }

    protected String decode(byte[] data) {
        this.getDecoder();
        if (data != null) {
            if (this.decoder != null) {
                try {
                    return this.decoder.decodeString(data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new String(data);
        }
        return "";
    }

    @Override
    public Object getAdditionalProperty(String name) {
        return this.torrent.getAdditionalProperty(name);
    }

    @Override
    public Torrent removeAdditionalProperties() {
        try {
            TOTorrent t = TOTorrentFactory.deserialiseFromMap(this.torrent.serialiseToMap());
            t.removeAdditionalProperties();
            return new TorrentImpl(t);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return this;
        }
    }

    @Override
    public void setPluginStringProperty(String name, String value) {
        PluginInterface p = this.pi;
        if (p == null) {
            p = UtilitiesImpl.getPluginThreadContext();
        }
        name = p == null ? "<internal>." + name : String.valueOf(p.getPluginID()) + "." + name;
        TorrentUtils.setPluginStringProperty(this.torrent, name, value);
    }

    @Override
    public String getPluginStringProperty(String name) {
        PluginInterface p = this.pi;
        if (p == null) {
            p = UtilitiesImpl.getPluginThreadContext();
        }
        name = p == null ? "<internal>." + name : String.valueOf(p.getPluginID()) + "." + name;
        return TorrentUtils.getPluginStringProperty(this.torrent, name);
    }

    @Override
    public void setMapProperty(String name, Map value) {
        TorrentUtils.setPluginMapProperty(this.torrent, name, value);
    }

    @Override
    public Map getMapProperty(String name) {
        return TorrentUtils.getPluginMapProperty(this.torrent, name);
    }

    @Override
    public Map writeToMap() throws TorrentException {
        try {
            return this.torrent.serialiseToMap();
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::writeToMap: fails", e);
        }
    }

    @Override
    public byte[] writeToBEncodedData() throws TorrentException {
        try {
            Map map = this.torrent.serialiseToMap();
            return BEncoder.encode(map);
        }
        catch (Throwable e) {
            throw new TorrentException("Torrent::writeToBEncodedData: fails", e);
        }
    }

    @Override
    public void writeToFile(File file) throws TorrentException {
        try {
            this.torrent.serialiseToBEncodedFile(file);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::writeToFile: fails", e);
        }
    }

    protected void updated() {
        try {
            DownloadImpl dm = (DownloadImpl)DownloadManagerImpl.getDownloadStatic(this.torrent);
            if (dm != null) {
                dm.torrentChanged();
            }
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
    }

    @Override
    public void save() throws TorrentException {
        try {
            TorrentUtils.writeToFile(this.torrent);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::save Fails", e);
        }
    }

    @Override
    public void setComplete(File data_dir) throws TorrentException {
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this.torrent);
            DownloadManagerState download_manager_state = DownloadManagerStateFactory.getDownloadState(this.torrent);
            TorrentUtils.setResumeDataCompletelyValid(download_manager_state);
            download_manager_state.save();
            this.complete = true;
        }
        catch (Throwable e) {
            throw new TorrentException("encoding selection fails", e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getRelationText() {
        return this.propogatedRelationText(this.torrent);
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.torrent};
    }

    @Override
    public boolean isSimpleTorrent() {
        return this.torrent.isSimpleTorrent();
    }

    @Override
    public Torrent getClone() throws TorrentException {
        try {
            return new TorrentImpl(TOTorrentFactory.deserialiseFromMap(this.torrent.serialiseToMap()));
        }
        catch (Throwable e) {
            throw new TorrentException("Cloning fails", e);
        }
    }
}

