/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLListSet;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListSetImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentAnnounceURLListImpl
implements TorrentAnnounceURLList {
    protected TorrentImpl torrent;

    protected TorrentAnnounceURLListImpl(TorrentImpl _torrent) {
        this.torrent = _torrent;
    }

    @Override
    public TorrentAnnounceURLListSet[] getSets() {
        TOTorrentAnnounceURLGroup group = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TorrentAnnounceURLListSet[] res = new TorrentAnnounceURLListSet[sets.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new TorrentAnnounceURLListSetImpl(this, sets[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void setSets(TorrentAnnounceURLListSet[] sets) {
        TOTorrentAnnounceURLGroup group = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] res = new TOTorrentAnnounceURLSet[sets.length];
        int i = 0;
        while (i < res.length) {
            res[i] = ((TorrentAnnounceURLListSetImpl)sets[i]).getSet();
            ++i;
        }
        group.setAnnounceURLSets(res);
        this.updated();
    }

    @Override
    public TorrentAnnounceURLListSet create(URL[] urls) {
        return new TorrentAnnounceURLListSetImpl(this, this.torrent.getTorrent().getAnnounceURLGroup().createAnnounceURLSet(urls));
    }

    @Override
    public void addSet(URL[] urls) {
        if (this.setAlreadyExists(urls)) {
            return;
        }
        TorrentUtils.announceGroupsInsertLast(this.torrent.getTorrent(), urls);
        this.updated();
    }

    @Override
    public void insertSetAtFront(URL[] urls) {
        if (this.setAlreadyExists(urls)) {
            return;
        }
        TorrentUtils.announceGroupsInsertFirst(this.torrent.getTorrent(), urls);
        this.updated();
    }

    protected boolean setAlreadyExists(URL[] urls) {
        TOTorrentAnnounceURLGroup group = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        int i = 0;
        while (i < sets.length) {
            URL[] u = sets[i].getAnnounceURLs();
            if (u.length == urls.length) {
                boolean all_found = true;
                int j = 0;
                while (j < urls.length) {
                    URL u1 = urls[j];
                    boolean this_found = false;
                    int k = 0;
                    while (k < u.length) {
                        URL u2 = u[k];
                        if (u1.toString().equals(u2.toString())) {
                            this_found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!this_found) {
                        all_found = false;
                        break;
                    }
                    ++j;
                }
                if (all_found) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected void updated() {
        this.torrent.updated();
    }
}

