/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceEvent;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareItemImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public abstract class ShareResourceImpl
implements ShareResource {
    protected static BrokenMd5Hasher hasher = new BrokenMd5Hasher();
    protected ShareManagerImpl manager;
    protected int type;
    protected ShareResourceDirContents parent;
    protected Map attributes = new HashMap();
    protected List change_listeners = new ArrayList();
    protected List deletion_listeners = new ArrayList();

    protected ShareResourceImpl(ShareManagerImpl _manager, int _type) {
        this.manager = _manager;
        this.type = _type;
    }

    protected ShareResourceImpl(ShareManagerImpl _manager, int _type, Map _map) {
        this.manager = _manager;
        this.type = _type;
        Map attrs = (Map)_map.get("attributes");
        if (attrs != null) {
            for (String key : attrs.keySet()) {
                try {
                    String value = new String((byte[])attrs.get(key), "UTF8");
                    TorrentAttribute ta = TorrentManagerImpl.getSingleton().getAttribute(key);
                    if (ta == null) {
                        Debug.out("Invalid attribute '" + key);
                        continue;
                    }
                    this.attributes.put(ta, value);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void serialiseResource(Map map) {
        Iterator it = this.attributes.keySet().iterator();
        HashMap<String, byte[]> attrs = new HashMap<String, byte[]>();
        map.put("attributes", attrs);
        while (it.hasNext()) {
            TorrentAttribute ta = (TorrentAttribute)it.next();
            String value = (String)this.attributes.get(ta);
            try {
                if (value == null) continue;
                attrs.put(ta.getName(), value.getBytes("UTF8"));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public ShareResourceDirContents getParent() {
        return this.parent;
    }

    protected void setParent(ShareResourceDirContents _parent) {
        this.parent = _parent;
    }

    public ShareResource[] getChildren() {
        return new ShareResource[0];
    }

    @Override
    public int getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setAttribute(final TorrentAttribute attribute, String value) {
        ShareConfigImpl config = this.manager.getShareConfig();
        try {
            config.suspendSaving();
            ShareResource[] kids = this.getChildren();
            int i = 0;
            while (i < kids.length) {
                kids[i].setAttribute(attribute, value);
                ++i;
            }
            String old_value = (String)this.attributes.get(attribute);
            if (old_value == null && value == null) {
                return;
            }
            if (old_value != null && value != null && old_value.equals(value)) {
                return;
            }
            this.attributes.put(attribute, value);
            try {
                config.saveConfig();
            }
            catch (ShareException e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            try {
                config.resumeSaving();
            }
            catch (ShareException e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < this.change_listeners.size()) {
            try {
                ((ShareResourceListener)this.change_listeners.get(i)).shareResourceChanged(this, new ShareResourceEvent(){

                    @Override
                    public int getType() {
                        return 1;
                    }

                    @Override
                    public Object getData() {
                        return attribute;
                    }
                });
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public String getAttribute(TorrentAttribute attribute) {
        return (String)this.attributes.get(attribute);
    }

    @Override
    public TorrentAttribute[] getAttributes() {
        TorrentAttribute[] res = new TorrentAttribute[this.attributes.size()];
        this.attributes.keySet().toArray(res);
        return res;
    }

    protected void inheritAttributes(ShareResourceImpl source) {
        TorrentAttribute[] attrs = source.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            this.setAttribute(attrs[i], source.getAttribute(attrs[i]));
            ++i;
        }
    }

    @Override
    public void delete() throws ShareException, ShareResourceDeletionVetoException {
        if (this.getParent() != null) {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }
        this.delete(false);
    }

    @Override
    public void delete(boolean force) throws ShareException, ShareResourceDeletionVetoException {
        this.delete(force, true);
    }

    public void delete(boolean force, boolean fire_listeners) throws ShareException, ShareResourceDeletionVetoException {
        if (!force) {
            this.canBeDeleted();
        }
        this.manager.delete(this, fire_listeners);
    }

    @Override
    public abstract boolean canBeDeleted() throws ShareResourceDeletionVetoException;

    @Override
    public boolean isPersistent() {
        Map<String, String> properties = this.getProperties();
        if (properties == null) {
            return false;
        }
        String persistent_str = properties.get("persistent");
        boolean persistent = persistent_str != null && persistent_str.equalsIgnoreCase("true");
        return persistent;
    }

    protected abstract void deleteInternal();

    protected byte[] getFingerPrint(File file) throws ShareException {
        try {
            StringBuffer buffer = new StringBuffer();
            this.getFingerPrintSupport(buffer, file, TorrentUtils.getIgnoreSet());
            return hasher.calculateHash(buffer.toString().getBytes());
        }
        catch (ShareException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ShareException("ShareResource::getFingerPrint: fails", e);
        }
    }

    protected void getFingerPrintSupport(StringBuffer buffer, File file, Set ignore_set) throws ShareException {
        block9: {
            try {
                if (file.isFile()) {
                    long mod = file.lastModified();
                    long size = file.length();
                    String file_name = file.getName();
                    if (!ignore_set.contains(file_name.toLowerCase())) {
                        buffer.append(file_name).append(":").append(mod).append(":").append(size);
                    }
                    break block9;
                }
                if (file.isDirectory()) {
                    File[] dir_file_list = file.listFiles();
                    ArrayList<File> file_list = new ArrayList<File>(Arrays.asList(dir_file_list));
                    Collections.sort(file_list);
                    int i = 0;
                    while (i < file_list.size()) {
                        File f = (File)file_list.get(i);
                        String file_name = f.getName();
                        if (!file_name.equals(".") && !file_name.equals("..")) {
                            StringBuffer sub_print = new StringBuffer();
                            this.getFingerPrintSupport(sub_print, f, ignore_set);
                            if (sub_print.length() > 0) {
                                buffer.append(":").append(sub_print);
                            }
                        }
                        ++i;
                    }
                    break block9;
                }
                throw new ShareException("ShareResource::getFingerPrint: '" + file.toString() + "' doesn't exist");
            }
            catch (Throwable e) {
                if (e instanceof ShareException) {
                    throw (ShareException)e;
                }
                Debug.printStackTrace(e);
                throw new ShareException("ShareResource::getFingerPrint: fails", e);
            }
        }
    }

    protected String getNewTorrentLocation() throws ShareException {
        return this.manager.getNewTorrentLocation();
    }

    protected void writeTorrent(ShareItemImpl item) throws ShareException {
        this.manager.writeTorrent(item);
    }

    protected void readTorrent(ShareItemImpl item) throws ShareException {
        this.manager.readTorrent(item);
    }

    protected void deleteTorrent(ShareItemImpl item) {
        this.manager.deleteTorrent(item);
    }

    public File getTorrentFile(ShareItemImpl item) {
        return this.manager.getTorrentFile(item);
    }

    protected abstract void checkConsistency() throws ShareException;

    @Override
    public void addChangeListener(ShareResourceListener l) {
        this.change_listeners.add(l);
    }

    @Override
    public void removeChangeListener(ShareResourceListener l) {
        this.change_listeners.remove(l);
    }

    @Override
    public void addDeletionListener(ShareResourceWillBeDeletedListener l) {
        this.deletion_listeners.add(l);
    }

    @Override
    public void removeDeletionListener(ShareResourceWillBeDeletedListener l) {
        this.deletion_listeners.remove(l);
    }
}

