/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;

public class PeerStatsImpl
implements PeerStats {
    private PeerManagerImpl peer_manager;
    private PEPeerManager manager;
    private PEPeerStats delegate;
    private Peer owner;

    public PeerStatsImpl(PeerManagerImpl _peer_manager, Peer _owner, PEPeerStats _delegate) {
        this.peer_manager = _peer_manager;
        this.manager = this.peer_manager.getDelegate();
        this.delegate = _delegate;
        this.owner = _owner;
    }

    public PEPeerStats getDelegate() {
        return this.delegate;
    }

    @Override
    public int getDownloadAverage() {
        return (int)this.delegate.getDataReceiveRate();
    }

    @Override
    public int getReception() {
        return (int)this.delegate.getSmoothDataReceiveRate();
    }

    @Override
    public int getUploadAverage() {
        return (int)this.delegate.getDataSendRate();
    }

    @Override
    public int getTotalAverage() {
        return (int)this.delegate.getEstimatedDownloadRateOfPeer();
    }

    @Override
    public long getTotalDiscarded() {
        return this.delegate.getTotalBytesDiscarded();
    }

    @Override
    public long getTotalSent() {
        return this.delegate.getTotalDataBytesSent();
    }

    @Override
    public long getTotalReceived() {
        return this.delegate.getTotalDataBytesReceived();
    }

    @Override
    public int getStatisticSentAverage() {
        return (int)this.delegate.getEstimatedUploadRateOfPeer();
    }

    @Override
    public int getPermittedBytesToReceive() {
        return this.delegate.getPermittedBytesToReceive();
    }

    @Override
    public void permittedReceiveBytesUsed(int bytes) {
        this.delegate.permittedReceiveBytesUsed(bytes);
        this.received(bytes);
    }

    @Override
    public int getPermittedBytesToSend() {
        return this.delegate.getPermittedBytesToSend();
    }

    @Override
    public void permittedSendBytesUsed(int bytes) {
        this.delegate.permittedSendBytesUsed(bytes);
        this.sent(bytes);
    }

    @Override
    public void received(int bytes) {
        this.delegate.dataBytesReceived(bytes);
        this.manager.dataBytesReceived(this.delegate.getPeer(), bytes);
    }

    @Override
    public void sent(int bytes) {
        this.delegate.dataBytesSent(bytes);
        this.manager.dataBytesSent(this.delegate.getPeer(), bytes);
    }

    @Override
    public void discarded(int bytes) {
        this.delegate.bytesDiscarded(bytes);
        this.manager.discarded(this.delegate.getPeer(), bytes);
    }

    @Override
    public long getTimeSinceConnectionEstablished() {
        return this.peer_manager.getTimeSinceConnectionEstablished(this.owner);
    }

    @Override
    public int getDownloadRateLimit() {
        return this.delegate.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void setDownloadRateLimit(int bytes) {
        this.delegate.setDownloadRateLimitBytesPerSecond(bytes);
    }

    @Override
    public int getUploadRateLimit() {
        return this.delegate.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public void setUploadRateLimit(int bytes) {
        this.delegate.setUploadRateLimitBytesPerSecond(bytes);
    }

    @Override
    public long getOverallBytesRemaining() {
        return this.delegate.getPeer().getBytesRemaining();
    }
}

