/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import java.net.InetSocketAddress;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;

public class GenericMessageEndpointImpl
implements GenericMessageEndpoint {
    private ConnectionEndpoint ce;

    public GenericMessageEndpointImpl(ConnectionEndpoint _ce) {
        this.ce = _ce;
    }

    public GenericMessageEndpointImpl(InetSocketAddress _ne) {
        this.ce = new ConnectionEndpoint(_ne);
    }

    @Override
    public InetSocketAddress getNotionalAddress() {
        return this.ce.getNotionalAddress();
    }

    protected ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    @Override
    public void addTCP(InetSocketAddress target) {
        this.ce.addProtocol(ProtocolEndpointFactory.createEndpoint(1, target));
    }

    @Override
    public InetSocketAddress getTCP() {
        ProtocolEndpoint[] pes = this.ce.getProtocols();
        int i = 0;
        while (i < pes.length) {
            if (pes[i] instanceof ProtocolEndpointTCP) {
                return ((ProtocolEndpointTCP)pes[i]).getAddress();
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addUDP(InetSocketAddress target) {
        this.ce.addProtocol(ProtocolEndpointFactory.createEndpoint(2, target));
    }

    @Override
    public InetSocketAddress getUDP() {
        ProtocolEndpoint[] pes = this.ce.getProtocols();
        int i = 0;
        while (i < pes.length) {
            if (pes[i] instanceof ProtocolEndpointUDP) {
                return ((ProtocolEndpointUDP)pes[i]).getAddress();
            }
            ++i;
        }
        return null;
    }
}

