/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import java.io.File;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRandomReadRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerRandomReadController;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo {
    protected DownloadImpl download;
    protected org.gudy.azureus2.core3.disk.DiskManagerFileInfo core;

    public DiskManagerFileInfoImpl(DownloadImpl _download, org.gudy.azureus2.core3.disk.DiskManagerFileInfo coreFileInfo) {
        this.core = coreFileInfo;
        this.download = _download;
    }

    @Override
    public void setPriority(boolean b) {
        this.core.setPriority(b ? 1 : 0);
    }

    @Override
    public void setSkipped(boolean b) {
        this.core.setSkipped(b);
    }

    @Override
    public int getNumericPriorty() {
        return this.core.getPriority();
    }

    @Override
    public int getNumericPriority() {
        return this.core.getPriority();
    }

    @Override
    public void setNumericPriority(int priority) {
        this.core.setPriority(priority);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDeleted(boolean b) {
        int target_st;
        int st = this.core.getStorageType();
        if (b) {
            if (st == 1) {
                target_st = 2;
            } else {
                if (st != 3) return;
                target_st = 4;
            }
        } else if (st == 2) {
            target_st = 1;
        } else {
            if (st != 4) return;
            target_st = 3;
        }
        this.core.setStorageType(target_st);
    }

    @Override
    public boolean isDeleted() {
        int st = this.core.getStorageType();
        return st == 2 || st == 4;
    }

    @Override
    public void setLink(File link_destination) {
        this.core.setLink(link_destination);
    }

    @Override
    public File getLink() {
        return this.core.getLink();
    }

    @Override
    public int getAccessMode() {
        return this.core.getAccessMode();
    }

    @Override
    public long getDownloaded() {
        return this.core.getDownloaded();
    }

    @Override
    public long getLength() {
        return this.core.getLength();
    }

    @Override
    public File getFile() {
        return this.core.getFile(false);
    }

    @Override
    public File getFile(boolean follow_link) {
        return this.core.getFile(follow_link);
    }

    @Override
    public int getFirstPieceNumber() {
        return this.core.getFirstPieceNumber();
    }

    @Override
    public long getPieceSize() {
        try {
            return this.getDownload().getTorrent().getPieceSize();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0L;
        }
    }

    @Override
    public int getNumPieces() {
        return this.core.getNbPieces();
    }

    @Override
    public boolean isPriority() {
        return this.core.getPriority() != 0;
    }

    @Override
    public boolean isSkipped() {
        return this.core.isSkipped();
    }

    @Override
    public int getIndex() {
        return this.core.getIndex();
    }

    @Override
    public byte[] getDownloadHash() throws DownloadException {
        return this.getDownload().getTorrent().getHash();
    }

    @Override
    public Download getDownload() throws DownloadException {
        if (this.download != null) {
            return this.download;
        }
        return DownloadManagerImpl.getDownloadStatic(this.core.getDownloadManager());
    }

    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        return new DiskManagerChannelImpl(this.download, this);
    }

    @Override
    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        return DiskManagerRandomReadController.createRequest(this.download, this, file_offset, length, reverse_order, listener);
    }

    public org.gudy.azureus2.core3.disk.DiskManagerFileInfo getCore() {
        return this.core;
    }
}

