/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.clientid;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.util.NetUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;

public class ClientIDManagerImpl
implements ClientIDManager {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected static ClientIDManagerImpl singleton = new ClientIDManagerImpl();
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private static final int connect_timeout;
    private static final int read_timeout;
    private ClientIDGenerator generator;
    private volatile boolean use_filter;
    private boolean filter_override;
    private ThreadPool thread_pool;
    private Object filter_lock = new Object();
    private int filter_port;

    static {
        String connect_timeout_str = System.getProperty("sun.net.client.defaultConnectTimeout");
        String read_timeout_str = System.getProperty("sun.net.client.defaultReadTimeout");
        int ct = 60000;
        int rt = 60000;
        try {
            ct = Integer.parseInt(connect_timeout_str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            rt = Integer.parseInt(read_timeout_str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        connect_timeout = ct;
        read_timeout = rt;
    }

    public static ClientIDManagerImpl getSingleton() {
        return singleton;
    }

    public void setGenerator(ClientIDGenerator _generator, boolean _use_filter) {
        this.generator = _generator;
        this.use_filter = _use_filter;
        if (!this.use_filter) {
            String http_proxy = System.getProperty("http.proxyHost");
            String socks_proxy = System.getProperty("socksProxyHost");
            NetworkAdmin network_admin = NetworkAdmin.getSingleton();
            if (network_admin.mustBind()) {
                this.filter_override = true;
                this.use_filter = true;
            } else {
                InetAddress bindIP = network_admin.getSingleHomedServiceBindAddress();
                if (!(http_proxy != null && http_proxy.trim().length() != 0 || socks_proxy != null && socks_proxy.trim().length() != 0 || bindIP == null || bindIP.isAnyLocalAddress())) {
                    int ips = 0;
                    try {
                        List<NetworkInterface> x = NetUtils.getNetworkInterfaces();
                        for (NetworkInterface network_interface : x) {
                            Enumeration<InetAddress> addresses = network_interface.getInetAddresses();
                            while (addresses.hasMoreElements()) {
                                InetAddress address = addresses.nextElement();
                                if (address.isLoopbackAddress()) continue;
                                ++ips;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LOGID, "", e));
                    }
                    if (ips > 1) {
                        this.filter_override = true;
                        this.use_filter = true;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "ClientIDManager: overriding filter option to support local bind IP"));
                        }
                    }
                }
            }
        }
        this.setupFilter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFilter(boolean force) {
        Object object = this.filter_lock;
        synchronized (object) {
            if (!this.use_filter) {
                if (force) {
                    this.use_filter = true;
                } else {
                    return;
                }
            }
            if (this.filter_port != 0) {
                return;
            }
            try {
                this.thread_pool = new ThreadPool("ClientIDManager", 32);
                int timeout = connect_timeout + read_timeout;
                this.thread_pool.setExecutionLimit(timeout);
                final ServerSocket ss = new ServerSocket(0, 1024, InetAddress.getByName("127.0.0.1"));
                this.filter_port = ss.getLocalPort();
                ss.setReuseAddress(true);
                new AEThread2("ClientIDManager::filterloop"){

                    @Override
                    public void run() {
                        long failed_accepts = 0L;
                        while (true) {
                            try {
                                while (true) {
                                    Socket socket = ss.accept();
                                    failed_accepts = 0L;
                                    ClientIDManagerImpl.this.thread_pool.run(new httpFilter(socket));
                                }
                            }
                            catch (Throwable e) {
                                ++failed_accepts;
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + ClientIDManagerImpl.this.filter_port, e));
                                if (failed_accepts <= 10L) continue;
                                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + ClientIDManagerImpl.this.filter_port, "TCP"});
                                ClientIDManagerImpl.this.use_filter = false;
                                return;
                            }
                            break;
                        }
                    }
                }.start();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener established on port " + this.filter_port));
                }
            }
            catch (Throwable e) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.filter_port});
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + this.filter_port, e));
                }
                this.use_filter = false;
            }
        }
    }

    @Override
    public ClientIDGenerator getGenerator() {
        return this.generator;
    }

    public byte[] generatePeerID(byte[] hash, boolean for_tracker) throws ClientIDException {
        return this.generator.generatePeerID(hash, for_tracker);
    }

    public Object getProperty(byte[] hash, String property_name) {
        return this.generator.getProperty(hash, property_name);
    }

    public void generateHTTPProperties(byte[] hash, Properties properties) throws ClientIDException {
        URL url;
        boolean filter_it;
        Boolean sni_hack = (Boolean)properties.get("SNI-Hack");
        if (sni_hack != null && sni_hack.booleanValue() && !this.use_filter) {
            this.setupFilter(true);
        }
        if (filter_it = this.use_filter) {
            url = (URL)properties.get("URL");
            String protocol = url.getProtocol();
            String host = url.getHost();
            if (host.equals("127.0.0.1") || protocol.equals("ws") || protocol.equals("wss") || AENetworkClassifier.categoriseAddress(host) != "Public") {
                filter_it = false;
            } else {
                InetSocketAddress address;
                Proxy proxy = (Proxy)properties.get("Proxy");
                if (proxy != null && proxy.type() == Proxy.Type.SOCKS && (address = (InetSocketAddress)proxy.address()).getAddress().isLoopbackAddress()) {
                    filter_it = false;
                }
            }
        }
        this.generator.generateHTTPProperties(hash, properties);
        if (filter_it) {
            url = (URL)properties.get("URL");
            boolean is_ssl = url.getProtocol().toLowerCase().equals("https");
            try {
                String rem;
                String url_str = url.toString();
                String target_host = url.getHost();
                int target_port = url.getPort();
                if (target_port == -1) {
                    target_port = url.getDefaultPort();
                }
                String hash_str = hash == null ? "" : URLEncoder.encode(new String(hash, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                int host_pos = url_str.indexOf(target_host);
                String new_url = String.valueOf(url_str.substring(0, host_pos)) + "127.0.0.1:" + this.filter_port;
                if (is_ssl) {
                    new_url = "http" + new_url.substring(new_url.indexOf(58));
                }
                if ((rem = url_str.substring(host_pos + target_host.length())).charAt(0) == ':') {
                    rem = rem.substring(("" + target_port).length() + 1);
                }
                int q_pos = rem.indexOf(63);
                String details = "cid=" + (is_ssl ? "." : "") + target_host + ":" + target_port + "+" + hash_str;
                new_url = q_pos == -1 ? String.valueOf(new_url) + rem + "?" + details : String.valueOf(new_url) + rem.substring(0, q_pos + 1) + details + "&" + rem.substring(q_pos + 1);
                properties.put("URL", new URL(new_url));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    static /* synthetic */ boolean access$0(ClientIDManagerImpl clientIDManagerImpl) {
        return clientIDManagerImpl.filter_override;
    }

    static /* synthetic */ ClientIDGenerator access$1(ClientIDManagerImpl clientIDManagerImpl) {
        return clientIDManagerImpl.generator;
    }

    static /* synthetic */ int access$2() {
        return connect_timeout;
    }

    static /* synthetic */ int access$3() {
        return read_timeout;
    }

    protected class httpFilter
    extends ThreadPoolTask {
        private Socket socket;

        protected httpFilter(Socket _socket) {
            this.socket = _socket;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void runSupport() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void interruptTask() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

