/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;

public class PluginCoreUtils {
    public static Torrent wrap(TOTorrent t) {
        return new TorrentImpl(t);
    }

    public static TOTorrent unwrap(Torrent t) {
        return ((TorrentImpl)t).getTorrent();
    }

    public static DiskManager wrap(org.gudy.azureus2.core3.disk.DiskManager dm) {
        return new DiskManagerImpl(dm);
    }

    public static org.gudy.azureus2.core3.disk.DiskManager unwrap(DiskManager dm) {
        return ((DiskManagerImpl)dm).getDiskmanager();
    }

    public static Download wrap(DownloadManager dm) {
        try {
            return DownloadManagerImpl.getDownloadStatic(dm);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static NetworkConnection unwrap(Connection connection) {
        if (connection instanceof ConnectionImpl) {
            return ((ConnectionImpl)connection).getCoreConnection();
        }
        return null;
    }

    public static Connection wrap(NetworkConnection connection) {
        return new ConnectionImpl(connection, connection.isIncoming());
    }

    public static DiskManagerFileInfo wrap(org.gudy.azureus2.core3.disk.DiskManagerFileInfo info) throws DownloadException {
        if (info == null) {
            return null;
        }
        return new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(info.getDownloadManager()), info);
    }

    public static org.gudy.azureus2.core3.disk.DiskManagerFileInfo unwrap(final DiskManagerFileInfo info) throws DownloadException {
        if (info instanceof DiskManagerFileInfoImpl) {
            return ((DiskManagerFileInfoImpl)info).getCore();
        }
        if (info == null) {
            return null;
        }
        try {
            Download dl = info.getDownload();
            if (dl != null) {
                DownloadManager dm = PluginCoreUtils.unwrap(dl);
                return dm.getDiskManagerFileInfo()[info.getIndex()];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new org.gudy.azureus2.core3.disk.DiskManagerFileInfo(){

            @Override
            public void setPriority(int b) {
                info.setNumericPriority(b);
            }

            @Override
            public void setSkipped(boolean b) {
                info.setSkipped(b);
            }

            @Override
            public boolean setLink(File link_destination) {
                info.setLink(link_destination);
                return true;
            }

            @Override
            public boolean setLinkAtomic(File link_destination) {
                info.setLink(link_destination);
                return true;
            }

            @Override
            public File getLink() {
                return info.getLink();
            }

            @Override
            public boolean setStorageType(int type) {
                return false;
            }

            @Override
            public int getStorageType() {
                return 1;
            }

            @Override
            public int getAccessMode() {
                return info.getAccessMode();
            }

            @Override
            public long getDownloaded() {
                return info.getDownloaded();
            }

            @Override
            public String getExtension() {
                return "";
            }

            @Override
            public int getFirstPieceNumber() {
                return info.getFirstPieceNumber();
            }

            @Override
            public int getLastPieceNumber() {
                return (int)((info.getLength() + info.getPieceSize() - 1L) / info.getPieceSize());
            }

            @Override
            public long getLength() {
                return info.getLength();
            }

            @Override
            public int getNbPieces() {
                return info.getNumPieces();
            }

            @Override
            public int getPriority() {
                return info.getNumericPriorty();
            }

            @Override
            public boolean isSkipped() {
                return info.isSkipped();
            }

            @Override
            public int getIndex() {
                return info.getIndex();
            }

            @Override
            public DownloadManager getDownloadManager() {
                return null;
            }

            @Override
            public org.gudy.azureus2.core3.disk.DiskManager getDiskManager() {
                return null;
            }

            @Override
            public File getFile(boolean follow_link) {
                if (follow_link) {
                    return info.getLink();
                }
                return info.getFile();
            }

            @Override
            public TOTorrentFile getTorrentFile() {
                return null;
            }

            @Override
            public DirectByteBuffer read(long offset, int length) throws IOException {
                throw new IOException("unsupported");
            }

            @Override
            public void flushCache() throws Exception {
            }

            @Override
            public int getReadBytesPerSecond() {
                return 0;
            }

            @Override
            public int getWriteBytesPerSecond() {
                return 0;
            }

            @Override
            public long getETA() {
                return -1L;
            }

            @Override
            public void close() {
            }

            @Override
            public void addListener(DiskManagerFileInfoListener listener) {
            }

            @Override
            public void removeListener(DiskManagerFileInfoListener listener) {
            }
        };
    }

    public static Object convert(Object datasource, boolean toCore) {
        if (datasource instanceof Object[]) {
            Object[] array = (Object[])datasource;
            Object[] newArray = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                Object o = array[i];
                newArray[i] = PluginCoreUtils.convert(o, toCore);
                ++i;
            }
            return newArray;
        }
        try {
            if (toCore) {
                if (datasource instanceof DownloadManager) {
                    return datasource;
                }
                if (datasource instanceof DownloadImpl) {
                    return ((DownloadImpl)datasource).getDownload();
                }
                if (datasource instanceof org.gudy.azureus2.core3.disk.DiskManager) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerImpl) {
                    return ((DiskManagerImpl)datasource).getDiskmanager();
                }
                if (datasource instanceof PEPeerManager) {
                    return datasource;
                }
                if (datasource instanceof PeerManagerImpl) {
                    return ((PeerManagerImpl)datasource).getDelegate();
                }
                if (datasource instanceof PEPeer) {
                    return datasource;
                }
                if (datasource instanceof PeerImpl) {
                    return ((PeerImpl)datasource).getPEPeer();
                }
                if (datasource instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerFileInfoImpl) {
                    return ((DiskManagerFileInfoImpl)datasource).getCore();
                }
                if (datasource instanceof TRHostTorrent) {
                    return datasource;
                }
                if (datasource instanceof TrackerTorrentImpl) {
                    ((TrackerTorrentImpl)datasource).getHostTorrent();
                }
            } else {
                org.gudy.azureus2.core3.disk.DiskManagerFileInfo fileInfo2;
                if (datasource instanceof DownloadManager) {
                    return PluginCoreUtils.wrap((DownloadManager)datasource);
                }
                if (datasource instanceof DownloadImpl) {
                    return datasource;
                }
                if (datasource instanceof org.gudy.azureus2.core3.disk.DiskManager) {
                    return PluginCoreUtils.wrap((org.gudy.azureus2.core3.disk.DiskManager)datasource);
                }
                if (datasource instanceof DiskManagerImpl) {
                    return datasource;
                }
                if (datasource instanceof PEPeerManager) {
                    return PluginCoreUtils.wrap((PEPeerManager)datasource);
                }
                if (datasource instanceof PeerManagerImpl) {
                    return datasource;
                }
                if (datasource instanceof PEPeer) {
                    return PeerManagerImpl.getPeerForPEPeer((PEPeer)datasource);
                }
                if (datasource instanceof Peer) {
                    return datasource;
                }
                if (datasource instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo && (fileInfo2 = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)datasource) != null) {
                    try {
                        return new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(fileInfo2.getDownloadManager()), fileInfo2);
                    }
                    catch (DownloadException downloadException) {
                        // empty catch block
                    }
                }
                if (datasource instanceof DiskManagerFileInfoImpl) {
                    return datasource;
                }
                if (datasource instanceof TRHostTorrent) {
                    TRHostTorrent item = (TRHostTorrent)datasource;
                    return new TrackerTorrentImpl(item);
                }
                if (datasource instanceof TrackerTorrentImpl) {
                    return datasource;
                }
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return datasource;
    }

    public static DownloadManager unwrapIfPossible(Download dm) {
        if (dm instanceof DownloadImpl) {
            return ((DownloadImpl)dm).getDownload();
        }
        return null;
    }

    public static DownloadManager unwrap(Download dm) {
        if (dm instanceof DownloadImpl) {
            return ((DownloadImpl)dm).getDownload();
        }
        Debug.out("Can't unwrap " + dm);
        return null;
    }

    public static PeerManager wrap(PEPeerManager pm) {
        return PeerManagerImpl.getPeerManager(pm);
    }

    public static PEPeerManager unwrap(PeerManager pm) {
        return ((PeerManagerImpl)pm).getDelegate();
    }

    public static TRTrackerServerTorrent unwrap(TrackerTorrent torrent) {
        return ((TrackerTorrentImpl)torrent).getHostTorrent().getTrackerTorrent();
    }

    public static PEPeer unwrap(Peer peer) {
        return ((PeerImpl)peer).getDelegate();
    }

    public static boolean isInitialisationComplete() {
        return PluginInitializer.getDefaultInterface().getPluginState().isInitialisationComplete();
    }
}

