/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.ui.tables;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;

public class TableCellRefresher {
    private static TableCellRefresher instance = null;
    private AEThread2 refresher;
    private Map<TableCell, TableColumn> mapCellsToColumn = new HashMap<TableCell, TableColumn>();
    private long iterationNumber;
    private volatile boolean inProgress = false;
    private AERunnable runnable = new AERunnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            try {
                HashMap cellsCopy;
                Map map = TableCellRefresher.this.mapCellsToColumn;
                synchronized (map) {
                    cellsCopy = new HashMap(TableCellRefresher.this.mapCellsToColumn);
                    TableCellRefresher.this.mapCellsToColumn.clear();
                }
                for (TableCell cell : cellsCopy.keySet()) {
                    TableColumn column = (TableColumn)cellsCopy.get(cell);
                    try {
                        if (column instanceof TableCellRefreshListener) {
                            ((TableCellRefreshListener)((Object)column)).refresh(cell);
                            continue;
                        }
                        if (!(column instanceof TableColumnImpl)) continue;
                        List<TableCellRefreshListener> listeners = ((TableColumnImpl)column).getCellRefreshListeners();
                        for (TableCellRefreshListener listener : listeners) {
                            listener.refresh(cell);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            finally {
                TableCellRefresher.this.inProgress = false;
            }
        }
    };

    private TableCellRefresher() {
        this.refresher = new AEThread2("Cell Refresher", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TableCellRefresher.this.iterationNumber = 0L;
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    while (true) {
                        if (uif != null) {
                            int size;
                            Map map = TableCellRefresher.this.mapCellsToColumn;
                            synchronized (map) {
                                size = TableCellRefresher.this.mapCellsToColumn.size();
                            }
                            if (size > 0 && !TableCellRefresher.this.inProgress) {
                                TableCellRefresher.this.inProgress = true;
                                uif.runOnUIThread(1, TableCellRefresher.this.runnable);
                            }
                        }
                        Thread.sleep(100L);
                        TableCellRefresher tableCellRefresher = TableCellRefresher.this;
                        tableCellRefresher.iterationNumber = tableCellRefresher.iterationNumber + 1L;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        this.refresher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addColumnCell(TableColumn column, TableCell cell) {
        Map<TableCell, TableColumn> map = this.mapCellsToColumn;
        synchronized (map) {
            if (this.mapCellsToColumn.containsKey(cell)) {
                return;
            }
            this.mapCellsToColumn.put(cell, column);
        }
    }

    private int _getRefreshIndex(int refreshEvery100ms, int nbIndices) {
        if (refreshEvery100ms <= 0) {
            return 1;
        }
        if (nbIndices <= 0) {
            return 1;
        }
        return (int)(this.iterationNumber / (long)refreshEvery100ms % (long)nbIndices);
    }

    private static synchronized TableCellRefresher getInstance() {
        if (instance == null) {
            instance = new TableCellRefresher();
        }
        return instance;
    }

    public static void addCell(TableColumn column, TableCell cell) {
        TableCellRefresher.getInstance()._addColumnCell(column, cell);
    }

    public static int getRefreshIndex(int refreshEvery100ms, int nbIndices) {
        return TableCellRefresher.getInstance()._getRefreshIndex(refreshEvery100ms, nbIndices);
    }
}

