/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.unix.ScriptAfterShutdown;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.update.UpdaterUtils;

public class PlatformManagerUnixPlugin
implements Plugin {
    private PluginInterface plugin_interface;

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
        String version = "1.0";
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.hasCapability(PlatformManagerCapabilities.GetVersion)) {
            try {
                version = platform.getVersion();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        } else {
            this.plugin_interface.getPluginProperties().setProperty("plugin.version.info", "Not required for this platform");
        }
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", version);
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){
            boolean done = false;

            @Override
            public void UIDetached(UIInstance instance) {
            }

            @Override
            public void UIAttached(UIInstance instance) {
                if (!this.done) {
                    this.done = true;
                    if (Constants.compareVersions(UpdaterUtils.getUpdaterPluginVersion(), "1.8.5") >= 0) {
                        PlatformManagerUnixPlugin.this.checkStartupScript();
                    }
                }
            }
        });
    }

    private void checkStartupScript() {
        block30: {
            Matcher matcher;
            String oldStartupScript;
            File oldFilePath;
            COConfigurationManager.setIntDefault("unix.script.lastaskversion", -1);
            int lastAskedVersion = COConfigurationManager.getIntParameter("unix.script.lastaskversion");
            String sVersion = System.getProperty("azureus.script.version", "0");
            int version = 0;
            try {
                version = Integer.parseInt(sVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Pattern pat = Pattern.compile("SCRIPT_VERSION=([0-9]+)", 2);
            String sScriptFile = System.getProperty("azureus.script", null);
            if (sScriptFile != null && new File(sScriptFile).exists()) {
                oldFilePath = new File(sScriptFile);
            } else {
                oldFilePath = new File(SystemProperties.getApplicationPath(), "azureus");
                if (!oldFilePath.exists()) {
                    return;
                }
            }
            String oldFilePathString = oldFilePath.getAbsolutePath();
            try {
                oldStartupScript = FileUtil.readFileAsString(oldFilePath, 65535, "utf8");
            }
            catch (IOException e) {
                oldStartupScript = "";
            }
            if (version == 0 && (matcher = pat.matcher(oldStartupScript)).find()) {
                String sScriptVersion = matcher.group(1);
                try {
                    version = Integer.parseInt(sScriptVersion);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (version <= lastAskedVersion) {
                return;
            }
            InputStream stream = this.getClass().getResourceAsStream("startupScript");
            try {
                try {
                    String newFilePath;
                    String startupScript = FileUtil.readInputStreamAsString(stream, 65535, "utf8");
                    Matcher matcher2 = pat.matcher(startupScript);
                    if (!matcher2.find()) break block30;
                    String sScriptVersion = matcher2.group(1);
                    int latestVersion = 0;
                    try {
                        latestVersion = Integer.parseInt(sScriptVersion);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (latestVersion <= version) break block30;
                    boolean bNotChanged = oldStartupScript.indexOf("SCRIPT_NOT_CHANGED=0") > 0 || oldStartupScript.indexOf("AUTOUPDATE_SCRIPT=1") > 0;
                    boolean bInformUserManual = true;
                    if (bNotChanged) {
                        if (version >= 1) {
                            newFilePath = new File(SystemProperties.getApplicationPath(), "azureus.new").getAbsolutePath();
                            FileUtil.writeBytesAsFile(newFilePath, startupScript.getBytes());
                            String s = "cp \"" + newFilePath + "\" \"" + oldFilePathString + "\"; chmod +x \"" + oldFilePathString + "\"; echo \"Script Update successful\"";
                            ScriptAfterShutdown.addExtraCommand(s);
                            ScriptAfterShutdown.setRequiresExit(true);
                            bInformUserManual = false;
                        } else {
                            try {
                                FileUtil.writeBytesAsFile(oldFilePathString, startupScript.getBytes());
                                Runtime.getRuntime().exec(new String[]{this.findCommand("chmod"), "+x", oldStartupScript});
                                bInformUserManual = false;
                            }
                            catch (Throwable newFilePath2) {
                                // empty catch block
                            }
                        }
                    }
                    if (bInformUserManual) {
                        newFilePath = new File(SystemProperties.getApplicationPath(), "azureus.new").getAbsolutePath();
                        FileUtil.writeBytesAsFile(newFilePath, startupScript.getBytes());
                        this.showScriptManualUpdateDialog(newFilePath, oldFilePathString, latestVersion);
                        break block30;
                    }
                    this.showScriptAutoUpdateDialog();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String findCommand(String name) {
        String[] locations;
        String[] stringArray = locations = new String[]{"/bin", "/usr/bin"};
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File f = new File(s, name);
            if (f.exists() && f.canRead()) {
                return f.getAbsolutePath();
            }
            ++n2;
        }
        return name;
    }

    private void showScriptManualUpdateDialog(String newFilePath, String oldFilePath, final int version) {
        final UIFunctions uif = UIFunctionsManager.getUIFunctions();
        if (uif != null) {
            final String sCopyLine = "cp \"" + newFilePath + "\" \"" + oldFilePath + "\"";
            uif.promptUser(MessageText.getString("unix.script.new.title"), MessageText.getString("unix.script.new.text", new String[]{newFilePath, sCopyLine}), new String[]{MessageText.getString("unix.script.new.button.quit"), MessageText.getString("unix.script.new.button.continue"), MessageText.getString("unix.script.new.button.asknomore")}, 0, null, null, false, 0, new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int answer) {
                    if (answer == 0) {
                        System.out.println("The line you should run:\n" + sCopyLine);
                        uif.dispose(false, false);
                    } else if (answer == 2) {
                        COConfigurationManager.setParameter("unix.script.lastaskversion", version);
                    }
                }
            });
        } else {
            System.out.println("NO UIF");
        }
    }

    private void showScriptAutoUpdateDialog() {
        final UIFunctions uif = UIFunctionsManager.getUIFunctions();
        if (uif != null) {
            uif.promptUser(MessageText.getString("unix.script.new.auto.title"), MessageText.getString("unix.script.new.auto.text", new String[0]), new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0, null, null, false, 0, new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int answer) {
                    if (answer == 0) {
                        uif.dispose(true, false);
                    }
                }
            });
        } else {
            System.out.println("NO UIF");
        }
    }
}

