/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class LightHashMap<S, T>
extends AbstractMap<S, T>
implements Cloneable {
    private static final Object THOMBSTONE = new Object();
    private static final Object NULLKEY = new Object();
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 8;
    final float loadFactor;
    int size;
    Object[] data;

    public LightHashMap() {
        this(8, 0.75f);
    }

    public LightHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LightHashMap(Map m) {
        this(0);
        if (m instanceof LightHashMap) {
            LightHashMap lightMap = (LightHashMap)m;
            this.size = lightMap.size;
            this.data = (Object[])lightMap.data.clone();
        } else {
            this.putAll(m);
        }
    }

    @Override
    public Object clone() {
        try {
            LightHashMap newMap = (LightHashMap)super.clone();
            newMap.data = (Object[])this.data.clone();
            return newMap;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public LightHashMap(int initialCapacity, float loadFactor) {
        if (loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must not be > 1");
        }
        this.loadFactor = loadFactor;
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.data = new Object[capacity * 2];
    }

    @Override
    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public T put(Object key, Object value) {
        this.checkCapacity(1);
        return (T)this.add(key, value, false);
    }

    @Override
    public void putAll(Map m) {
        this.checkCapacity(m.size());
        for (Map.Entry entry : m.entrySet()) {
            this.add(entry.getKey(), entry.getValue(), true);
        }
    }

    @Override
    public Set<S> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<T> values() {
        return new Values();
    }

    public int capacity() {
        return this.data.length >> 1;
    }

    @Override
    public T get(Object key) {
        if (key == null) {
            key = NULLKEY;
        }
        return (T)this.data[this.nonModifyingFindIndex(key) + 1];
    }

    private Object add(Object key, Object value, boolean bulkAdd) {
        if (key == null) {
            key = NULLKEY;
        }
        int idx = bulkAdd ? this.nonModifyingFindIndex(key) : this.findIndex(key);
        Object oldValue = this.data[idx + 1];
        if (this.data[idx] == null || this.data[idx] == THOMBSTONE) {
            this.data[idx] = key;
            ++this.size;
        }
        this.data[idx + 1] = value;
        return oldValue;
    }

    @Override
    public T remove(Object key) {
        int idx;
        if (this.size == 0) {
            return null;
        }
        if (key == null) {
            key = NULLKEY;
        }
        if (this.keysEqual(this.data[idx = this.findIndex(key)], key)) {
            return (T)this.removeForIndex(idx);
        }
        return null;
    }

    private Object removeForIndex(int idx) {
        Object oldValue = this.data[idx + 1];
        this.data[idx] = THOMBSTONE;
        this.data[idx + 1] = null;
        --this.size;
        return oldValue;
    }

    @Override
    public void clear() {
        this.size = 0;
        int capacity = 1;
        while (capacity < 8) {
            capacity <<= 1;
        }
        this.data = new Object[capacity * 2];
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.size == 0) {
            return false;
        }
        if (key == null) {
            key = NULLKEY;
        }
        return this.keysEqual(key, this.data[this.nonModifyingFindIndex(key)]);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            int i = 0;
            while (i < this.data.length) {
                if (value.equals(this.data[i + 1])) {
                    return true;
                }
                i += 2;
            }
        } else {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i + 1] == null && this.data[i] != null && this.data[i] != THOMBSTONE) {
                    return true;
                }
                i += 2;
            }
        }
        return false;
    }

    private final boolean keysEqual(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.hashCode() == o2.hashCode() && o1.equals(o2);
    }

    private int findIndex(Object keyToFind) {
        int hash = keyToFind.hashCode() << 1;
        int probe = 1;
        int newIndex = hash & this.data.length - 1;
        int thombStoneIndex = -1;
        int thombStoneCount = 0;
        int thombStoneThreshold = Math.min((this.data.length >> 1) - this.size, 100);
        while (this.data[newIndex] != null && !this.keysEqual(this.data[newIndex], keyToFind)) {
            if (this.data[newIndex] == THOMBSTONE) {
                if (thombStoneIndex == -1) {
                    thombStoneIndex = newIndex;
                }
                if (++thombStoneCount * 2 > thombStoneThreshold) {
                    this.compactify(0.0f);
                    thombStoneIndex = -1;
                    probe = 0;
                    thombStoneCount = 0;
                }
            }
            newIndex = hash + probe + probe * probe & this.data.length - 1;
            ++probe;
        }
        if (thombStoneIndex != -1 && !this.keysEqual(this.data[newIndex], keyToFind)) {
            return thombStoneIndex;
        }
        return newIndex;
    }

    private int nonModifyingFindIndex(Object keyToFind) {
        int hash = keyToFind.hashCode() << 1;
        int probe = 1;
        int newIndex = hash & this.data.length - 1;
        int thombStoneIndex = -1;
        while (this.data[newIndex] != null && !this.keysEqual(this.data[newIndex], keyToFind) && probe < this.data.length >> 1) {
            if (this.data[newIndex] == THOMBSTONE && thombStoneIndex == -1) {
                thombStoneIndex = newIndex;
            }
            newIndex = hash + probe + probe * probe & this.data.length - 1;
            ++probe;
        }
        if (thombStoneIndex != -1 && !this.keysEqual(this.data[newIndex], keyToFind)) {
            return thombStoneIndex;
        }
        return newIndex;
    }

    private void checkCapacity(int n) {
        int currentCapacity = this.data.length >> 1;
        if ((float)(this.size + n) < (float)currentCapacity * this.loadFactor) {
            return;
        }
        int newCapacity = currentCapacity;
        while ((float)(newCapacity <<= 1) * this.loadFactor < (float)(this.size + n)) {
        }
        this.adjustCapacity(newCapacity);
    }

    public void compactify(float compactingLoadFactor) {
        int newCapacity = 1;
        float adjustedLoadFactor = Math.abs(compactingLoadFactor);
        if (adjustedLoadFactor <= 0.0f || adjustedLoadFactor >= 1.0f) {
            adjustedLoadFactor = this.loadFactor;
        }
        while ((float)newCapacity * adjustedLoadFactor < (float)(this.size + 1)) {
            newCapacity <<= 1;
        }
        if (newCapacity < this.data.length / 2 || compactingLoadFactor >= 0.0f) {
            this.adjustCapacity(newCapacity);
        }
    }

    private void adjustCapacity(int newSize) {
        Object[] oldData = this.data;
        this.data = new Object[newSize * 2];
        this.size = 0;
        int i = 0;
        while (i < oldData.length) {
            if (oldData[i] != null && oldData[i] != THOMBSTONE) {
                this.add(oldData[i], oldData[i + 1], true);
            }
            i += 2;
        }
    }

    static void test() {
        Random rnd = new Random();
        byte[] buffer = new byte[5];
        String[] fillData = new String[1950351];
        int i = 0;
        while (i < fillData.length) {
            rnd.nextBytes(buffer);
            fillData[i] = new String(buffer);
            fillData[i].hashCode();
            ++i;
        }
        HashMap<String, byte[]> m1 = new HashMap<String, byte[]>();
        LightHashMap m2 = new LightHashMap();
        System.out.println("fill:");
        long time = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < fillData.length) {
            m1.put(fillData[i2], buffer);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m2.put(fillData[i2], buffer);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("replace-fill:");
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m1.put(fillData[i2], buffer);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m2.put(fillData[i2], buffer);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("get:");
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m1.get(fillData[i2]);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m2.get(fillData[i2]);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("compactify light map");
        time = System.currentTimeMillis();
        m2.compactify(0.9f);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("transfer to hashmap");
        time = System.currentTimeMillis();
        new HashMap(m1);
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        new HashMap(m2);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("transfer to lighthashmap");
        time = System.currentTimeMillis();
        new LightHashMap(m1);
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        new LightHashMap(m2);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("remove entry by entry");
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m1.remove(fillData[i2]);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < fillData.length) {
            m2.remove(fillData[i2]);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - time);
    }

    public static void main(String[] args) {
        int random;
        System.out.println("Call with -Xmx300m -Xcomp -server");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LightHashMap.test();
        System.out.println("-------------------------------------");
        System.gc();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LightHashMap.test();
        System.out.println("\n\nPerforming sanity tests");
        Random rnd = new Random();
        byte[] buffer = new byte[25];
        String[] fillData = new String[1048];
        int i = 0;
        while (i < fillData.length) {
            rnd.nextBytes(buffer);
            fillData[i] = new String(buffer);
            fillData[i].hashCode();
            ++i;
        }
        HashMap<String, String> m1 = new HashMap<String, String>();
        LightHashMap m2 = new LightHashMap();
        int i2 = 0;
        while (i2 < fillData.length * 10) {
            random = rnd.nextInt(fillData.length);
            m1.put(null, fillData[i2 % fillData.length]);
            m2.put(null, fillData[i2 % fillData.length]);
            if (!m1.equals(m2)) {
                System.out.println("Error 0");
            }
            m1.put(fillData[random], fillData[i2 % fillData.length]);
            m2.put(fillData[random], fillData[i2 % fillData.length]);
            if (!m1.equals(m2)) {
                System.out.println("Error 1");
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < fillData.length / 2) {
            random = rnd.nextInt(fillData.length);
            m1.remove(fillData[random]);
            m2.remove(fillData[random]);
            if (!m1.equals(m2)) {
                System.out.println("Error 2");
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < fillData.length * 10) {
            random = rnd.nextInt(fillData.length);
            m1.put(fillData[random], fillData[i2 % fillData.length]);
            m1.put(null, fillData[i2 % fillData.length]);
            m2.put(fillData[random], fillData[i2 % fillData.length]);
            m2.put(null, fillData[i2 % fillData.length]);
            if (!m1.equals(m2)) {
                System.out.println("Error 3");
            }
            ++i2;
        }
        Iterator i1 = m1.entrySet().iterator();
        Iterator i22 = m2.entrySet().iterator();
        while (i1.hasNext()) {
            i1.next();
            i1.remove();
            i22.next();
            i22.remove();
        }
        if (!m1.equals(m2)) {
            System.out.println("Error 4");
        }
        m2.clear();
        int i3 = 0;
        while (i3 < 100000) {
            rnd.nextBytes(buffer);
            String s = new String(buffer);
            m2.put(s, buffer);
            m2.containsKey(s);
            m2.remove(s);
            ++i3;
        }
        System.out.println("checks done");
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LightHashMap.this.size;
        }

        private class EntrySetIterator
        extends HashIterator {
            private EntrySetIterator() {
            }

            @Override
            public Object nextIntern() {
                return new Entry(this.currentIdx);
            }

            private final class Entry
            implements Map.Entry {
                final int entryIndex;

                public Entry(int idx) {
                    this.entryIndex = idx;
                }

                public Object getKey() {
                    Object key = EntrySetIterator.this.itData[this.entryIndex];
                    return key != NULLKEY ? key : null;
                }

                public Object getValue() {
                    return EntrySetIterator.this.itData[this.entryIndex + 1];
                }

                public Object setValue(Object value) {
                    Object oldValue = EntrySetIterator.this.itData[this.entryIndex + 1];
                    EntrySetIterator.this.itData[this.entryIndex + 1] = value;
                    return oldValue;
                }

                @Override
                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
                }

                @Override
                public int hashCode() {
                    return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                }
            }
        }
    }

    private abstract class HashIterator
    implements Iterator {
        protected int nextIdx = -2;
        protected int currentIdx = -2;
        protected Object[] itData;

        public HashIterator() {
            this.itData = LightHashMap.this.data;
            this.findNext();
        }

        private void findNext() {
            do {
                this.nextIdx += 2;
            } while (this.nextIdx < this.itData.length && (this.itData[this.nextIdx] == null || this.itData[this.nextIdx] == THOMBSTONE));
        }

        @Override
        public void remove() {
            if (this.currentIdx == -2) {
                throw new IllegalStateException("No entry to delete, use next() first");
            }
            if (this.itData != LightHashMap.this.data) {
                throw new ConcurrentModificationException("removal opperation not supported as concurrent structural modification occured");
            }
            LightHashMap.this.removeForIndex(this.currentIdx);
            this.currentIdx = -2;
        }

        @Override
        public boolean hasNext() {
            return this.nextIdx < this.itData.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more entries");
            }
            this.currentIdx = this.nextIdx;
            this.findNext();
            return this.nextIntern();
        }

        abstract Object nextIntern();
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return LightHashMap.this.size;
        }

        static /* synthetic */ LightHashMap access$1(KeySet keySet) {
            return keySet.LightHashMap.this;
        }

        private class KeySetIterator
        extends HashIterator {
            private KeySetIterator() {
            }

            @Override
            Object nextIntern() {
                Object key = this.itData[this.currentIdx];
                return key != NULLKEY ? key : null;
            }
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return LightHashMap.this.size;
        }

        static /* synthetic */ LightHashMap access$1(Values values) {
            return values.LightHashMap.this;
        }

        private class ValueIterator
        extends HashIterator {
            private ValueIterator() {
            }

            @Override
            Object nextIntern() {
                return this.itData[this.currentIdx + 1];
            }
        }
    }
}

