/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.bouncycastle.util.encoders.Base64;

public class AddressUtils {
    public static final byte LAN_LOCAL_MAYBE = 0;
    public static final byte LAN_LOCAL_YES = 1;
    public static final byte LAN_LOCAL_NO = 2;
    private static boolean i2p_is_lan_limit;
    private static AZInstanceManager instance_manager;
    private static Map host_map;

    static {
        COConfigurationManager.addAndFireParameterListener("Plugin.azi2phelper.azi2phelper.rates.use.lan", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                i2p_is_lan_limit = COConfigurationManager.getBooleanParameter("Plugin.azi2phelper.azi2phelper.rates.use.lan", false);
            }
        });
        host_map = null;
    }

    public static URL adjustURL(URL url) {
        String rewrite;
        url = AEProxyFactory.getAddressMapper().internalise(url);
        if (host_map != null && (rewrite = (String)host_map.get(url.getHost())) != null) {
            String str = url.toExternalForm();
            try {
                int pos = str.indexOf("//") + 2;
                int pos2 = str.indexOf("/", pos);
                String host_bit = str.substring(pos, pos2);
                int pos3 = host_bit.indexOf(58);
                String port_bit = pos3 == -1 ? "" : host_bit.substring(pos3);
                String new_str = String.valueOf(str.substring(0, pos)) + rewrite + port_bit + str.substring(pos2);
                url = new URL(new_str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return url;
    }

    public static synchronized void addHostRedirect(String from_host, String to_host) {
        System.out.println("AddressUtils::addHostRedirect - " + from_host + " -> " + to_host);
        HashMap<String, String> new_map = host_map == null ? new HashMap<String, String>() : new HashMap(host_map);
        new_map.put(from_host, to_host);
        host_map = new_map;
    }

    public static InetSocketAddress adjustTCPAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 1);
    }

    public static InetSocketAddress adjustUDPAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 2);
    }

    public static InetSocketAddress adjustDHTAddress(InetSocketAddress address, boolean ext_to_lan) {
        return AddressUtils.adjustAddress(address, ext_to_lan, 3);
    }

    private static InetSocketAddress adjustAddress(InetSocketAddress address, boolean ext_to_lan, int port_type) {
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return address;
        }
        InetSocketAddress adjusted_address = ext_to_lan ? instance_manager.getLANAddress(address, port_type) : instance_manager.getExternalAddress(address, port_type);
        if (adjusted_address == null) {
            adjusted_address = address;
        }
        return adjusted_address;
    }

    public static List getLANAddresses(String address) {
        ArrayList<String> result;
        block10: {
            result = new ArrayList<String>();
            result.add(address);
            try {
                InetAddress ad = InetAddress.getByName(address);
                if (AddressUtils.isLANLocalAddress(address) == 2) break block10;
                if (instance_manager == null) {
                    try {
                        instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (instance_manager == null || !instance_manager.isInitialized()) {
                    return result;
                }
                AZInstance[] instances = instance_manager.getOtherInstances();
                int i = 0;
                while (i < instances.length) {
                    AZInstance instance = instances[i];
                    List addresses = instance.getInternalAddresses();
                    if (addresses.contains(ad)) {
                        int j = 0;
                        while (j < addresses.size()) {
                            InetAddress ia = (InetAddress)addresses.get(j);
                            String str = ia.getHostAddress();
                            if (!result.contains(str)) {
                                result.add(str);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static byte isLANLocalAddress(InetSocketAddress socket_address) {
        InetAddress address = socket_address.getAddress();
        return AddressUtils.isLANLocalAddress(address);
    }

    public static byte isLANLocalAddress(InetAddress address) {
        if (address == null) {
            return 2;
        }
        if (instance_manager == null && AzureusCoreFactory.isCoreAvailable()) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return 0;
        }
        return instance_manager.isLANAddress(address) ? (byte)1 : 2;
    }

    public static byte isLANLocalAddress(String address) {
        byte is_lan_local = 0;
        try {
            is_lan_local = AddressUtils.isLANLocalAddress(HostNameToIPResolver.syncResolve(address));
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return is_lan_local;
    }

    public static boolean applyLANRateLimits(InetSocketAddress address) {
        if (i2p_is_lan_limit && address.isUnresolved()) {
            return AENetworkClassifier.categoriseAddress(address) == "I2P";
        }
        return false;
    }

    public static boolean isGlobalAddressV6(InetAddress addr) {
        return addr instanceof Inet6Address && !addr.isAnyLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress() && !addr.isMulticastAddress() && !addr.isSiteLocalAddress() && !((Inet6Address)addr).isIPv4CompatibleAddress();
    }

    public static boolean isTeredo(InetAddress addr) {
        if (!(addr instanceof Inet6Address)) {
            return false;
        }
        byte[] bytes = addr.getAddress();
        return bytes[0] == 32 && bytes[1] == 1 && bytes[2] == 0 && bytes[3] == 0;
    }

    public static boolean is6to4(InetAddress addr) {
        if (!(addr instanceof Inet6Address)) {
            return false;
        }
        byte[] bytes = addr.getAddress();
        return bytes[0] == 32 && bytes[1] == 2;
    }

    public static InetAddress pickBestGlobalV6Address(List<InetAddress> addrs) {
        InetAddress bestPick = null;
        int currentRanking = 0;
        for (InetAddress addr : addrs) {
            if (!AddressUtils.isGlobalAddressV6(addr)) continue;
            int ranking = 3;
            if (AddressUtils.isTeredo(addr)) {
                ranking = 1;
            } else if (AddressUtils.is6to4(addr)) {
                ranking = 2;
            }
            if (ranking <= currentRanking) continue;
            bestPick = addr;
            currentRanking = ranking;
        }
        return bestPick;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (AENetworkClassifier.categoriseAddress(host) == "Public") {
            return InetAddress.getByName(host);
        }
        throw new UnknownHostException(host);
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        if (AENetworkClassifier.categoriseAddress(host) == "Public") {
            return InetAddress.getAllByName(host);
        }
        throw new UnknownHostException(host);
    }

    public static byte[] getAddressBytes(InetSocketAddress address) {
        if (address.isUnresolved()) {
            try {
                return address.getHostName().getBytes("ISO8859-1");
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        return address.getAddress().getAddress();
    }

    public static String getHostAddress(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return address.getHostName();
        }
        return address.getAddress().getHostAddress();
    }

    public static String getHostNameNoResolve(InetSocketAddress address) {
        InetAddress i_address = address.getAddress();
        if (i_address == null) {
            return address.getHostName();
        }
        String str = i_address.toString();
        int pos = str.indexOf(47);
        if (pos == -1) {
            System.out.println("InetAddress::toString not returning expected result: " + str);
            return i_address.getHostAddress();
        }
        if (pos > 0) {
            return str.substring(0, pos);
        }
        return str.substring(pos + 1);
    }

    public static String convertToShortForm(String address) {
        int address_length = address.length();
        if (address_length > 256) {
            String to_decode;
            if (address.endsWith(".i2p")) {
                to_decode = address.substring(0, address.length() - 4);
            } else if (address.indexOf(46) == -1) {
                to_decode = address;
            } else {
                return address;
            }
            try {
                char[] encoded = to_decode.toCharArray();
                int i = 0;
                while (i < encoded.length) {
                    char c = encoded[i];
                    if (c == '~') {
                        encoded[i] = 47;
                    } else if (c == '-') {
                        encoded[i] = 43;
                    }
                    ++i;
                }
                byte[] decoded = Base64.decode(encoded);
                byte[] hash = MessageDigest.getInstance("SHA-256").digest(decoded);
                return String.valueOf(Base32.encode(hash).toLowerCase(Locale.US)) + ".b32.i2p";
            }
            catch (Throwable e) {
                return null;
            }
        }
        return address;
    }
}

