/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerProcessorUDP;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ThreadPool;

public class TRTrackerServerUDP
extends TRTrackerServerImpl {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int THREAD_POOL_SIZE = 10;
    private ThreadPool thread_pool;
    private int port;
    private InetAddress current_bind_ip;
    private DatagramSocket dg_socket;
    private volatile boolean closed;

    public TRTrackerServerUDP(String _name, int _port, boolean _start_up_ready) {
        super(_name, _start_up_ready);
        this.port = _port;
        this.thread_pool = new ThreadPool("TrackerServer:UDP:" + this.port, 10);
        try {
            DatagramSocket socket;
            InetSocketAddress address;
            InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (bind_ip == null) {
                address = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port);
                socket = new DatagramSocket(this.port);
            } else {
                this.current_bind_ip = bind_ip;
                address = new InetSocketAddress(bind_ip, this.port);
                socket = new DatagramSocket(address);
            }
            socket.setReuseAddress(true);
            this.dg_socket = socket;
            final InetSocketAddress f_address = address;
            AEThread recv_thread = new AEThread("TRTrackerServerUDP:recv.loop"){

                @Override
                public void runSupport() {
                    TRTrackerServerUDP.this.recvLoop(TRTrackerServerUDP.this.dg_socket, f_address);
                }
            };
            recv_thread.setDaemon(true);
            recv_thread.start();
            Logger.log(new LogEvent(LOGID, "TRTrackerServerUDP: recv established on port " + this.port));
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "TRTrackerServerUDP: DatagramSocket bind failed on port " + this.port, e));
        }
    }

    @Override
    public InetAddress getBindIP() {
        return this.current_bind_ip;
    }

    protected void recvLoop(DatagramSocket socket, InetSocketAddress address) {
        long successful_accepts = 0L;
        long failed_accepts = 0L;
        while (!this.closed) {
            try {
                byte[] buf = new byte[8192];
                DatagramPacket packet = new DatagramPacket(buf, buf.length, address);
                socket.receive(packet);
                ++successful_accepts;
                failed_accepts = 0L;
                String ip = packet.getAddress().getHostAddress();
                if (this.ip_filter.isInRange(ip, "Tracker", null)) continue;
                this.thread_pool.run(new TRTrackerServerProcessorUDP(this, socket, packet));
            }
            catch (Throwable e) {
                if (this.closed) continue;
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: receive failed on port " + this.port, e));
                if ((++failed_accepts <= 100L || successful_accepts != 0L) && failed_accepts <= 1000L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "UDP"});
                break;
            }
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    @Override
    public boolean isSSL() {
        return false;
    }

    @Override
    public void addRequestListener(TRTrackerServerRequestListener l) {
    }

    @Override
    public void removeRequestListener(TRTrackerServerRequestListener l) {
    }

    @Override
    protected void closeSupport() {
        this.closed = true;
        try {
            this.dg_socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.destroySupport();
    }
}

