/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import java.net.URL;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerBTScraperImpl {
    protected static TRTrackerBTScraperImpl singleton;
    protected static AEMonitor class_mon;
    private TRTrackerScraperImpl scraper;
    private TrackerChecker tracker_checker;

    static {
        class_mon = new AEMonitor("TRTrackerBTScraper");
    }

    public static TRTrackerBTScraperImpl create(TRTrackerScraperImpl _scraper) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerBTScraperImpl(_scraper);
            }
            TRTrackerBTScraperImpl tRTrackerBTScraperImpl = singleton;
            return tRTrackerBTScraperImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TRTrackerBTScraperImpl(TRTrackerScraperImpl _scraper) {
        this.scraper = _scraper;
        this.tracker_checker = new TrackerChecker(this);
    }

    protected TRTrackerScraperImpl getScraper() {
        return this.scraper;
    }

    public void setScrape(TOTorrent torrent, URL url, DownloadScrapeResult result) {
        if (torrent != null && result != null) {
            TRTrackerScraperResponseImpl resp = this.tracker_checker.getHashData(torrent, url);
            URL result_url = result.getURL();
            boolean update_is_dht = TorrentUtils.isDecentralised(result_url);
            if (resp != null && (resp.getStatus() == 1 || resp.isDHTBackup() && update_is_dht)) {
                resp.setDHTBackup(update_is_dht);
                resp.setScrapeStartTime(result.getScrapeStartTime());
                resp.setStatus(result.getResponseType() == 1 ? 2 : 1, String.valueOf(result.getStatus()) + " (" + (update_is_dht ? MessageText.getString("dht.backup.only") : (result_url == null ? "<null>" : result_url.getHost())) + ")");
                resp.setSeedsPeers(result.getSeedCount(), result.getNonSeedCount());
                this.scraper.scrapeReceived(resp);
            }
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url, boolean force) {
        if (torrent == null) {
            return null;
        }
        if (force) {
            this.tracker_checker.syncUpdate(torrent, target_url);
        }
        TRTrackerScraperResponseImpl res = this.tracker_checker.getHashData(torrent, target_url);
        return res;
    }

    public TRTrackerScraperResponse peekScrape(TOTorrent torrent, URL target_url) {
        if (torrent == null) {
            return null;
        }
        TRTrackerScraperResponseImpl res = this.tracker_checker.peekHashData(torrent, target_url);
        return res;
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tracker_client) {
        TRTrackerScraperResponseImpl res = this.tracker_checker.getHashData(tracker_client);
        return res;
    }

    public void remove(TOTorrent torrent) {
        this.tracker_checker.removeHash(torrent);
    }
}

