/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderImpl;

public class TorrentDownloaderManager
implements TorrentDownloaderCallBackInterface {
    private static TorrentDownloaderManager man = null;
    private boolean logged = false;
    private boolean autostart = false;
    private GlobalManager gm = null;
    private String downloaddir;
    private ArrayList running = new ArrayList();
    private ArrayList queued = new ArrayList();
    private ArrayList errors = new ArrayList();

    public TorrentDownloaderManager() {
        try {
            this.downloaddir = COConfigurationManager.getDirectoryParameter("Default save path");
        }
        catch (Exception e) {
            this.downloaddir = null;
        }
    }

    public static TorrentDownloaderManager getInstance() {
        if (man == null) {
            man = new TorrentDownloaderManager();
        }
        return man;
    }

    public void init(GlobalManager _gm, boolean _logged, boolean _autostart, String _downloaddir) {
        this.gm = _gm;
        this.logged = _logged;
        this.autostart = _autostart;
        if (_downloaddir != null) {
            this.downloaddir = _downloaddir;
        }
    }

    public TorrentDownloader add(TorrentDownloader dl) {
        if (dl.getDownloadState() == 4) {
            this.errors.add(dl);
        } else if (this.running.contains(dl) || this.queued.contains(dl)) {
            ((TorrentDownloaderImpl)dl).setDownloadState(5);
            ((TorrentDownloaderImpl)dl).notifyListener();
            this.errors.add(dl);
        } else if (this.autostart) {
            dl.start();
        } else {
            this.queued.add(dl);
        }
        return dl;
    }

    public TorrentDownloader download(String url, String fileordir, boolean logged) {
        return this.add(TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, url, null, fileordir, logged));
    }

    public TorrentDownloader download(String url, boolean logged) {
        return this.add(TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, url, null, null, logged));
    }

    public TorrentDownloader download(String url, String fileordir) {
        return this.add(TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, url, null, fileordir, this.logged));
    }

    public TorrentDownloader download(String url) {
        return this.add(TorrentDownloaderFactory.create(this, url, this.logged));
    }

    @Override
    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        switch (state) {
            case 1: {
                if (this.queued.contains(inf)) {
                    this.queued.remove(inf);
                }
                if (this.running.contains(inf)) break;
                this.running.add(inf);
                break;
            }
            case 3: {
                this.remove(inf);
                if (this.gm == null || this.downloaddir == null) break;
                this.gm.addDownloadManager(inf.getFile().getAbsolutePath(), this.downloaddir);
                break;
            }
            case 4: {
                this.remove(inf);
                this.errors.add(inf);
            }
        }
    }

    public void remove(TorrentDownloader inf) {
        if (this.running.contains(inf)) {
            this.running.remove(inf);
        }
        if (this.queued.contains(inf)) {
            this.queued.remove(inf);
        }
    }
}

