/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentCreateImpl;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class TOTorrentCreatorImpl
implements TOTorrentCreator {
    private File torrent_base;
    private URL announce_url;
    private boolean add_other_hashes;
    private long piece_length;
    private long piece_min_size;
    private long piece_max_size;
    private long piece_num_lower;
    private long piece_num_upper;
    private boolean is_desc;
    private Map<String, File> linkage_map = new HashMap<String, File>();
    private File descriptor_dir;
    private TOTorrentCreateImpl torrent;
    private List<TOTorrentProgressListener> listeners = new ArrayList<TOTorrentProgressListener>();

    public TOTorrentCreatorImpl(File _torrent_base) {
        this.torrent_base = _torrent_base;
    }

    public TOTorrentCreatorImpl(File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_length) throws TOTorrentException {
        this.torrent_base = _torrent_base;
        this.announce_url = _announce_url;
        this.add_other_hashes = _add_other_hashes;
        this.piece_length = _piece_length;
    }

    public TOTorrentCreatorImpl(File _torrent_base, URL _announce_url, boolean _add_other_hashes, long _piece_min_size, long _piece_max_size, long _piece_num_lower, long _piece_num_upper) throws TOTorrentException {
        this.torrent_base = _torrent_base;
        this.announce_url = _announce_url;
        this.add_other_hashes = _add_other_hashes;
        this.piece_min_size = _piece_min_size;
        this.piece_max_size = _piece_max_size;
        this.piece_num_lower = _piece_num_lower;
        this.piece_num_upper = _piece_num_upper;
    }

    @Override
    public void setFileIsLayoutDescriptor(boolean b) {
        this.is_desc = b;
    }

    @Override
    public TOTorrent create() throws TOTorrentException {
        try {
            if (this.announce_url == null) {
                throw new TOTorrentException("Skeleton creator", 5);
            }
            File base_to_use = this.is_desc ? this.createLayoutMap() : this.torrent_base;
            this.torrent = this.piece_length > 0L ? new TOTorrentCreateImpl(this.linkage_map, base_to_use, this.announce_url, this.add_other_hashes, this.piece_length) : new TOTorrentCreateImpl(this.linkage_map, base_to_use, this.announce_url, this.add_other_hashes, this.piece_min_size, this.piece_max_size, this.piece_num_lower, this.piece_num_upper);
            for (TOTorrentProgressListener l : this.listeners) {
                this.torrent.addListener(l);
            }
            this.torrent.create();
            TOTorrentCreateImpl tOTorrentCreateImpl = this.torrent;
            return tOTorrentCreateImpl;
        }
        finally {
            if (this.is_desc) {
                this.destroyLayoutMap();
            }
        }
    }

    private List<DescEntry> readDescriptor() throws TOTorrentException {
        try {
            boolean top_files = false;
            int top_entries = 0;
            String top_component = null;
            Map<String, Object> map = BDecoder.decode(FileUtil.readFileAsByteArray(this.torrent_base));
            List file_map = (List)map.get("file_map");
            if (file_map == null) {
                throw new TOTorrentException("Invalid descriptor file", 4);
            }
            ArrayList<DescEntry> desc_entries = new ArrayList<DescEntry>();
            BDecoder.decodeStrings(file_map);
            for (Map m : file_map) {
                List logical_path = (List)m.get("logical_path");
                String target = (String)m.get("target");
                if (logical_path == null || target == null) {
                    throw new TOTorrentException("Invalid descriptor file: entry=" + m, 4);
                }
                if (logical_path.size() == 0) {
                    throw new TOTorrentException("Logical path must have at least one entry: " + m, 4);
                }
                int i = 0;
                while (i < logical_path.size()) {
                    logical_path.set(i, FileUtil.convertOSSpecificChars((String)logical_path.get(i), i < logical_path.size() - 1));
                    ++i;
                }
                File tf = new File(target);
                if (!tf.exists()) {
                    throw new TOTorrentException("Invalid descriptor file: file '" + tf + "' not found" + m, 4);
                }
                String str = (String)logical_path.get(0);
                if (logical_path.size() == 1) {
                    ++top_entries;
                }
                if (top_component != null && !top_component.equals(str)) {
                    throw new TOTorrentException("Invalid descriptor file: multiple top level elements specified", 4);
                }
                top_component = str;
                desc_entries.add(new DescEntry(logical_path, tf));
            }
            if (top_entries > 1) {
                throw new TOTorrentException("Invalid descriptor file: exactly one top level entry required", 4);
            }
            if (desc_entries.isEmpty()) {
                throw new TOTorrentException("Invalid descriptor file: no mapping entries found", 4);
            }
            return desc_entries;
        }
        catch (IOException e) {
            throw new TOTorrentException("Invalid descriptor file: " + Debug.getNestedExceptionMessage(e), 4);
        }
    }

    private void mapDirectory(int prefix_length, File target, File temp) throws IOException {
        File[] files;
        File[] fileArray = files = target.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String file_name = f.getName();
            if (!file_name.equals(".") && !file_name.equals("..")) {
                File t = new File(temp, file_name);
                if (f.isDirectory()) {
                    if (!t.isDirectory()) {
                        t.mkdirs();
                    }
                    this.mapDirectory(prefix_length, f, t);
                } else {
                    if (t.exists()) {
                        throw new IOException("Duplicate file: " + t);
                    }
                    t.createNewFile();
                    this.linkage_map.put(t.getAbsolutePath().substring(prefix_length), f);
                }
            }
            ++n2;
        }
    }

    private File createLayoutMap() throws TOTorrentException {
        if (this.descriptor_dir != null) {
            return this.descriptor_dir;
        }
        try {
            this.descriptor_dir = AETemporaryFileHandler.createTempDir();
            File top_level_file = null;
            List<DescEntry> desc_entries = this.readDescriptor();
            for (DescEntry entry : desc_entries) {
                List logical_path = entry.getLogicalPath();
                File target = entry.getTarget();
                File temp = this.descriptor_dir;
                int prefix_length = this.descriptor_dir.getAbsolutePath().length() + 1;
                int i = 0;
                while (i < logical_path.size()) {
                    temp = new File(temp, (String)logical_path.get(i));
                    if (top_level_file == null) {
                        top_level_file = temp;
                    }
                    ++i;
                }
                if (target.isDirectory()) {
                    if (!temp.isDirectory() && !temp.mkdirs()) {
                        throw new TOTorrentException("Failed to create logical directory: " + temp, 5);
                    }
                    this.mapDirectory(prefix_length, target, temp);
                    continue;
                }
                File p = temp.getParentFile();
                if (!p.isDirectory() && !p.mkdirs()) {
                    throw new TOTorrentException("Failed to create logical directory: " + p, 5);
                }
                if (temp.exists()) {
                    throw new TOTorrentException("Duplicate file: " + temp, 5);
                }
                temp.createNewFile();
                this.linkage_map.put(temp.getAbsolutePath().substring(prefix_length), target);
            }
            return top_level_file;
        }
        catch (TOTorrentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TOTorrentException(Debug.getNestedExceptionMessage(e), 5);
        }
    }

    private void destroyLayoutMap() {
        if (this.descriptor_dir != null && this.descriptor_dir.exists() && !FileUtil.recursiveDelete(this.descriptor_dir)) {
            Debug.out("Failed to delete descriptor directory '" + this.descriptor_dir + "'");
        }
    }

    @Override
    public long getTorrentDataSizeFromFileOrDir() throws TOTorrentException {
        if (this.is_desc) {
            List<DescEntry> desc_entries = this.readDescriptor();
            long result = 0L;
            for (DescEntry entry : desc_entries) {
                result += this.getTorrentDataSizeFromFileOrDir(entry.getTarget());
            }
            return result;
        }
        return this.getTorrentDataSizeFromFileOrDir(this.torrent_base);
    }

    private long getTorrentDataSizeFromFileOrDir(File file) {
        String name = file.getName();
        if (name.equals(".") || name.equals("..")) {
            return 0L;
        }
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] dir_files = file.listFiles();
        long length = 0L;
        int i = 0;
        while (i < dir_files.length) {
            length += this.getTorrentDataSizeFromFileOrDir(dir_files[i]);
            ++i;
        }
        return length;
    }

    @Override
    public void cancel() {
        if (this.torrent != null) {
            this.torrent.cancel();
        }
    }

    @Override
    public void addListener(TOTorrentProgressListener listener) {
        if (this.torrent == null) {
            this.listeners.add(listener);
        } else {
            this.torrent.addListener(listener);
        }
    }

    @Override
    public void removeListener(TOTorrentProgressListener listener) {
        if (this.torrent == null) {
            this.listeners.remove(listener);
        } else {
            this.torrent.removeListener(listener);
        }
    }

    private static class DescEntry {
        private List<String> logical_path;
        private File target;

        private DescEntry(List<String> _l, File _t) {
            this.logical_path = _l;
            this.target = _t;
        }

        private List<String> getLogicalPath() {
            return this.logical_path;
        }

        private File getTarget() {
            return this.target;
        }
    }
}

