/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.stats.transfer.LongTermStats;
import org.gudy.azureus2.core3.stats.transfer.LongTermStatsListener;
import org.gudy.azureus2.core3.stats.transfer.impl.LongTermStatsWrapper;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class LongTermStatsGenericImpl
implements LongTermStatsWrapper.LongTermStatsWrapperHelper {
    private static final int VERSION = 1;
    private static final long MIN_IN_MILLIS = 60000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long WEEK_IN_MILLIS = 604800000L;
    public static final int RT_SESSION_START = 1;
    public static final int RT_SESSION_STATS = 2;
    public static final int RT_SESSION_END = 3;
    private final int STAT_ENTRY_COUNT;
    private long[] st;
    private long[] ss;
    private long[] line_stats_prev;
    private Average[] stat_averages;
    private boolean active;
    private boolean closing;
    private TimerEventPeriodic event;
    private PrintWriter writer;
    private String writer_rel_file;
    private DayCache day_cache;
    private final int MONTH_CACHE_MAX = 3;
    private Map<String, MonthCache> month_cache_map = new LinkedHashMap<String, MonthCache>(3, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, MonthCache> eldest) {
            return this.size() > 3;
        }
    };
    private static SimpleDateFormat debug_utc_format = new SimpleDateFormat("yyyy,MM,dd:HH:mm");
    private static SimpleDateFormat utc_date_format = new SimpleDateFormat("yyyy,MM,dd");
    private File stats_dir;
    private long session_total;
    private CopyOnWriteList<Object[]> listeners = new CopyOnWriteList();
    private AsyncDispatcher dispatcher = new AsyncDispatcher("lts", 5000);
    private int start_of_week = -1;
    private int start_of_month = -1;
    private volatile boolean destroyed;
    private final String generic_id;
    private final LongTermStats.GenericStatsSource generic_source;

    static {
        debug_utc_format.setTimeZone(TimeZone.getTimeZone("UTC"));
        utc_date_format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public LongTermStatsGenericImpl(String id, LongTermStats.GenericStatsSource source) {
        this.generic_id = id;
        this.generic_source = source;
        this.STAT_ENTRY_COUNT = source.getEntryCount();
        this.ss = new long[this.STAT_ENTRY_COUNT];
        this.st = new long[this.STAT_ENTRY_COUNT];
        this.line_stats_prev = new long[this.STAT_ENTRY_COUNT];
        this.stat_averages = new Average[this.STAT_ENTRY_COUNT];
        int i = 0;
        while (i < this.STAT_ENTRY_COUNT) {
            this.stat_averages[i] = AverageFactory.MovingImmediateAverage(3);
            ++i;
        }
        this.stats_dir = FileUtil.getUserFile("stats");
        this.stats_dir = new File(this.stats_dir, "gen." + id);
        COConfigurationManager.addParameterListener("long.term.stats.enable", new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String name) {
                if (LongTermStatsGenericImpl.this.destroyed) {
                    COConfigurationManager.removeParameterListener("long.term.stats.enable", this);
                    return;
                }
                boolean enabled = COConfigurationManager.getBooleanParameter(name);
                LongTermStatsGenericImpl longTermStatsGenericImpl = LongTermStatsGenericImpl.this;
                synchronized (longTermStatsGenericImpl) {
                    if (enabled) {
                        if (!LongTermStatsGenericImpl.this.active) {
                            LongTermStatsGenericImpl.this.sessionStart();
                        }
                    } else if (LongTermStatsGenericImpl.this.active) {
                        LongTermStatsGenericImpl.this.sessionEnd();
                    }
                }
            }
        });
        this.sessionStart();
        AzureusCoreFactory.getSingleton().addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopped(AzureusCore core) {
                if (LongTermStatsGenericImpl.this.destroyed) {
                    core.removeLifecycleListener(this);
                    return;
                }
                LongTermStatsGenericImpl longTermStatsGenericImpl = LongTermStatsGenericImpl.this;
                synchronized (longTermStatsGenericImpl) {
                    LongTermStatsGenericImpl.this.closing = true;
                    if (LongTermStatsGenericImpl.this.active) {
                        LongTermStatsGenericImpl.this.sessionEnd();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            return this.active;
        }
    }

    @Override
    public void reset() {
        Debug.out("eh?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyAndDeleteData() {
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            this.destroyed = true;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            int i = 0;
            while (i < 4) {
                if (FileUtil.recursiveDeleteNoCheck(this.stats_dir)) {
                    return;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i;
            }
            Debug.out("Failed to delete " + this.stats_dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionStart() {
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            if (this.closing) {
                return;
            }
            boolean enabled = COConfigurationManager.getBooleanParameter("long.term.stats.enable");
            if (this.active || !enabled) {
                return;
            }
            this.active = true;
            long[] current = this.generic_source.getStats(this.generic_id);
            int i = 0;
            while (i < current.length) {
                this.ss[i] = current[i];
                this.st[i] = this.ss[i];
                ++i;
            }
            this.write(1, this.st);
            if (this.event == null) {
                this.event = SimpleTimer.addPeriodicEvent("LongTermStats:" + this.generic_id, 60000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        if (LongTermStatsGenericImpl.this.destroyed) {
                            event2.cancel();
                            return;
                        }
                        LongTermStatsGenericImpl.this.updateStats();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionEnd() {
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            if (!this.active) {
                return;
            }
            this.updateStats(3);
            this.active = false;
            if (this.event != null) {
                this.event.cancel();
                this.event = null;
            }
        }
    }

    private void updateStats() {
        this.updateStats(2);
    }

    private void updateStats(int record_type) {
        long[] current = this.generic_source.getStats(this.generic_id);
        long[] diffs = new long[this.STAT_ENTRY_COUNT];
        int i = 0;
        while (i < this.STAT_ENTRY_COUNT) {
            diffs[i] = current[i] - this.ss[i];
            ++i;
        }
        this.write(record_type, diffs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(int record_type, long[] line_stats) {
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            block42: {
                if (this.destroyed) {
                    return;
                }
                try {
                    try {
                        int i;
                        long now = SystemTime.getCurrentTime();
                        long now_mins = now / 60000L;
                        String[] bits = utc_date_format.format(new Date(now)).split(",");
                        String year = bits[0];
                        String month = bits[1];
                        String day = bits[2];
                        String current_rel_file = String.valueOf(year) + File.separator + month + File.separator + day + ".dat";
                        String stats_str = "";
                        if (record_type == 1) {
                            int i2 = 0;
                            while (i2 < line_stats.length) {
                                stats_str = String.valueOf(stats_str) + "," + line_stats[i2];
                                this.line_stats_prev[i2] = 0L;
                                ++i2;
                            }
                            this.day_cache = null;
                        } else {
                            long[] diffs = new long[this.STAT_ENTRY_COUNT];
                            i = 0;
                            while (i < line_stats.length) {
                                long diff = line_stats[i] - this.line_stats_prev[i];
                                this.session_total += diff;
                                diffs[i] = diff;
                                stats_str = String.valueOf(stats_str) + "," + diff;
                                this.line_stats_prev[i] = line_stats[i];
                                this.stat_averages[i].update(diff);
                                ++i;
                            }
                            if (this.day_cache != null && this.day_cache.isForDay(year, month, day)) {
                                this.day_cache.addRecord(now_mins, diffs);
                            }
                        }
                        String line = record_type != 2 ? String.valueOf(record_type == 1 ? "s," : "e,") + 1 + "," + now_mins + stats_str : stats_str.substring(1);
                        if (this.writer == null || !this.writer_rel_file.equals(current_rel_file)) {
                            if (this.writer != null) {
                                if (record_type != 1) {
                                    this.writer.println(line);
                                }
                                this.writer.close();
                                if (this.writer.checkError()) {
                                    this.writer = null;
                                    throw new IOException("Write faled");
                                }
                                this.writer = null;
                            }
                            if (record_type != 3) {
                                File file = new File(this.stats_dir, current_rel_file);
                                file.getParentFile().mkdirs();
                                this.writer = new PrintWriter(new FileWriter(file, true));
                                this.writer_rel_file = current_rel_file;
                                if (record_type == 1) {
                                    this.writer.println(line);
                                } else {
                                    i = 0;
                                    while (i < this.STAT_ENTRY_COUNT) {
                                        int n = i;
                                        this.st[n] = this.st[n] + line_stats[i];
                                        int n2 = i;
                                        this.ss[n2] = this.ss[n2] + line_stats[i];
                                        ++i;
                                    }
                                    stats_str = "";
                                    long[] st_stats = this.st;
                                    int i3 = 0;
                                    while (i3 < st_stats.length) {
                                        stats_str = String.valueOf(stats_str) + "," + st_stats[i3];
                                        this.line_stats_prev[i3] = 0L;
                                        ++i3;
                                    }
                                    line = "s,1," + now_mins + stats_str;
                                    this.writer.println(line);
                                }
                            }
                        } else {
                            this.writer.println(line);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to write long term stats", e);
                        if (this.writer != null) {
                            if (record_type == 3) {
                                this.writer.close();
                            }
                            if (this.writer.checkError()) {
                                Debug.out("Failed to write long term stats");
                                this.writer.close();
                                this.writer = null;
                            } else if (record_type == 3) {
                                this.writer = null;
                            }
                        }
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    if (this.writer != null) {
                        if (record_type == 3) {
                            this.writer.close();
                        }
                        if (this.writer.checkError()) {
                            Debug.out("Failed to write long term stats");
                            this.writer.close();
                            this.writer = null;
                        } else if (record_type == 3) {
                            this.writer = null;
                        }
                    }
                    throw throwable;
                }
                if (this.writer != null) {
                    if (record_type == 3) {
                        this.writer.close();
                    }
                    if (this.writer.checkError()) {
                        Debug.out("Failed to write long term stats");
                        this.writer.close();
                        this.writer = null;
                    } else if (record_type == 3) {
                        this.writer = null;
                    }
                }
            }
        }
        if (record_type != 3) {
            final ArrayList<LongTermStatsListener> to_fire = new ArrayList<LongTermStatsListener>();
            for (Object[] entry : this.listeners) {
                long diff = this.session_total - (Long)entry[2];
                if (diff < (Long)entry[1]) continue;
                entry[2] = this.session_total;
                to_fire.add((LongTermStatsListener)entry[0]);
            }
            if (to_fire.size() > 0) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        for (LongTermStatsListener l : to_fire) {
                            try {
                                l.updated(LongTermStatsGenericImpl.this);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                });
            }
        }
    }

    private static String getString(long[] stats) {
        String str = "";
        long[] lArray = stats;
        int n = stats.length;
        int n2 = 0;
        while (n2 < n) {
            long s = lArray[n2];
            str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + s;
            ++n2;
        }
        return str;
    }

    private MonthCache getMonthCache(String year, String month) {
        String key = String.valueOf(year) + "_" + month;
        MonthCache cache = this.month_cache_map.get(key);
        if (cache == null) {
            cache = new MonthCache(year, month);
            this.month_cache_map.put(key, cache);
        }
        return cache;
    }

    @Override
    public long[] getTotalUsageInPeriod(Date start_date, Date end_date) {
        return this.getTotalUsageInPeriod(start_date, end_date, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getTotalUsageInPeriod(Date start_date, Date end_date, LongTermStats.RecordAccepter accepter) {
        boolean enable_caching = accepter == null;
        LongTermStatsGenericImpl longTermStatsGenericImpl = this;
        synchronized (longTermStatsGenericImpl) {
            long end_day;
            long start_day;
            long[] result = new long[this.STAT_ENTRY_COUNT];
            long start_millis = start_date.getTime();
            long end_millis = end_date.getTime();
            long now = SystemTime.getCurrentTime();
            long now_day = now / 86400000L * 86400000L;
            if (end_millis > now) {
                end_millis = now;
            }
            if ((start_day = start_millis / 86400000L * 86400000L) > (end_day = end_millis / 86400000L * 86400000L)) {
                return result;
            }
            long start_offset = start_millis - start_day;
            boolean offset_cachable = (start_offset /= 60000L) % 60L == 0L;
            MonthCache month_cache = null;
            long this_day = start_day;
            while (this_day <= end_day) {
                block41: {
                    String current_rel_file;
                    File stats_file;
                    boolean can_cache;
                    long cache_offset;
                    int day;
                    String day_str;
                    String month_str;
                    String year_str;
                    String[] bits;
                    block44: {
                        block42: {
                            block45: {
                                long[] cached_totals;
                                block43: {
                                    bits = utc_date_format.format(new Date(this_day)).split(",");
                                    year_str = bits[0];
                                    month_str = bits[1];
                                    day_str = bits[2];
                                    int year = Integer.parseInt(year_str);
                                    int month = Integer.parseInt(month_str);
                                    day = Integer.parseInt(day_str);
                                    long l = cache_offset = this_day == start_day ? start_offset : 0L;
                                    if (!enable_caching) break block42;
                                    if (month_cache == null || !month_cache.isForMonth(year_str, month_str)) {
                                        if (month_cache != null && month_cache.isDirty()) {
                                            month_cache.save();
                                        }
                                        month_cache = this.getMonthCache(year_str, month_str);
                                    }
                                    boolean bl = can_cache = this_day != now_day && (this_day > start_day || this_day == start_day && offset_cachable) && this_day < end_day;
                                    if (!can_cache) break block43;
                                    cached_totals = month_cache.getTotals(day, cache_offset);
                                    if (cached_totals == null) break block44;
                                    int i = 0;
                                    while (i < cached_totals.length) {
                                        int n = i;
                                        result[n] = result[n] + cached_totals[i];
                                        ++i;
                                    }
                                    break block41;
                                }
                                if (this_day != now_day || this.day_cache == null) break block44;
                                if (!this.day_cache.isForDay(year_str, month_str, day_str)) break block45;
                                cached_totals = this.day_cache.getTotals(cache_offset);
                                if (cached_totals == null) break block44;
                                int i = 0;
                                while (i < cached_totals.length) {
                                    int n = i;
                                    result[n] = result[n] + cached_totals[i];
                                    ++i;
                                }
                                break block41;
                            }
                            this.day_cache = null;
                            break block44;
                        }
                        can_cache = false;
                    }
                    if (!(stats_file = new File(this.stats_dir, current_rel_file = String.valueOf(bits[0]) + File.separator + bits[1] + File.separator + bits[2] + ".dat")).exists()) {
                        if (can_cache) {
                            month_cache.setTotals(day, cache_offset, new long[0]);
                        }
                    } else {
                        BufferedReader lnr = null;
                        try {
                            try {
                                String line;
                                lnr = new LineNumberReader(new FileReader(stats_file));
                                long file_start_time = 0L;
                                long[] file_totals = null;
                                long[] file_result_totals = new long[this.STAT_ENTRY_COUNT];
                                long[] session_start_stats = null;
                                long session_start_time = 0L;
                                long session_time = 0L;
                                while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                                    String[] fields = line.split(",");
                                    if (fields.length < this.STAT_ENTRY_COUNT) continue;
                                    String first_field = fields[0];
                                    if (first_field.equals("s")) {
                                        session_start_time = Long.parseLong(fields[2]) * 60000L;
                                        if (file_totals == null) {
                                            file_totals = new long[this.STAT_ENTRY_COUNT];
                                            file_start_time = session_start_time;
                                        }
                                        session_time = session_start_time;
                                        session_start_stats = new long[this.STAT_ENTRY_COUNT];
                                        int i = 3;
                                        while (i < 3 + this.STAT_ENTRY_COUNT) {
                                            session_start_stats[i - 3] = Long.parseLong(fields[i]);
                                            ++i;
                                        }
                                        continue;
                                    }
                                    if (session_start_time <= 0L) continue;
                                    session_time += 60000L;
                                    int field_offset = 0;
                                    if (first_field.equals("e")) {
                                        field_offset = 3;
                                    }
                                    long[] line_stats = new long[this.STAT_ENTRY_COUNT];
                                    int i = 0;
                                    while (i < this.STAT_ENTRY_COUNT) {
                                        line_stats[i] = Long.parseLong(fields[i + field_offset]);
                                        int n = i;
                                        file_totals[n] = file_totals[n] + line_stats[i];
                                        ++i;
                                    }
                                    if (session_time < start_millis || session_time > end_millis || accepter != null && !accepter.acceptRecord(session_time)) continue;
                                    i = 0;
                                    while (i < this.STAT_ENTRY_COUNT) {
                                        int n = i;
                                        result[n] = result[n] + line_stats[i];
                                        int n2 = i;
                                        file_result_totals[n2] = file_result_totals[n2] + line_stats[i];
                                        ++i;
                                    }
                                }
                                if (file_totals == null) {
                                    file_totals = new long[]{};
                                }
                                if (can_cache) {
                                    month_cache.setTotals(day, cache_offset, file_result_totals);
                                    if (cache_offset != 0L) {
                                        month_cache.setTotals(day, 0L, file_totals);
                                    }
                                } else if (enable_caching && this_day == now_day) {
                                    if (this.day_cache == null) {
                                        this.day_cache = new DayCache(year_str, month_str, day_str);
                                    }
                                    this.day_cache.setTotals(cache_offset, file_result_totals);
                                    if (cache_offset != 0L) {
                                        this.day_cache.setTotals(0L, file_totals);
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                if (lnr == null) break block41;
                                try {
                                    lnr.close();
                                }
                                catch (Throwable throwable) {}
                                break block41;
                            }
                        }
                        catch (Throwable throwable) {
                            if (lnr != null) {
                                try {
                                    lnr.close();
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (lnr != null) {
                            try {
                                lnr.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                this_day += 86400000L;
            }
            if (enable_caching && month_cache != null && month_cache.isDirty()) {
                month_cache.save();
            }
            return result;
        }
    }

    @Override
    public long[] getTotalUsageInPeriod(int period_type, double multiplier) {
        return this.getTotalUsageInPeriod(period_type, multiplier, null);
    }

    @Override
    public long[] getTotalUsageInPeriod(int period_type, double multiplier, LongTermStats.RecordAccepter accepter) {
        long top_time;
        long bottom_time;
        if (this.start_of_week == -1) {
            COConfigurationManager.addAndFireParameterListeners(new String[]{"long.term.stats.weekstart", "long.term.stats.monthstart"}, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    LongTermStatsGenericImpl.this.start_of_week = COConfigurationManager.getIntParameter("long.term.stats.weekstart");
                    LongTermStatsGenericImpl.this.start_of_month = COConfigurationManager.getIntParameter("long.term.stats.monthstart");
                }
            });
        }
        long now = SystemTime.getCurrentTime();
        if (period_type == 0) {
            bottom_time = now / 3600000L * 3600000L;
            top_time = bottom_time + 3600000L - 1L;
        } else if (period_type == 10) {
            bottom_time = now - (long)(multiplier * 3600000.0);
            top_time = now;
        } else if (period_type == 11) {
            bottom_time = now - (long)(multiplier * 8.64E7);
            top_time = now;
        } else if (period_type == 12) {
            bottom_time = now - (long)(multiplier * 6.048E8);
            top_time = now;
        } else {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(now);
            calendar.set(14, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            top_time = calendar.getTimeInMillis() + 86400000L - 1L;
            if (period_type != 1) {
                if (period_type == 2) {
                    int day_of_week = calendar.get(7);
                    if (day_of_week != this.start_of_week) {
                        if (day_of_week > this.start_of_week) {
                            ((Calendar)calendar).add(7, -(day_of_week - this.start_of_week));
                        } else {
                            ((Calendar)calendar).add(7, -(7 - (this.start_of_week - day_of_week)));
                        }
                    }
                } else if (this.start_of_month == 1) {
                    calendar.set(5, 1);
                } else {
                    int day_of_month = calendar.get(5);
                    if (day_of_month != this.start_of_month) {
                        if (day_of_month > this.start_of_month) {
                            calendar.set(5, this.start_of_month);
                        } else {
                            ((Calendar)calendar).add(2, -1);
                            calendar.set(5, this.start_of_month);
                        }
                    }
                }
            }
            bottom_time = calendar.getTimeInMillis();
        }
        return this.getTotalUsageInPeriod(new Date(bottom_time), new Date(top_time), accepter);
    }

    @Override
    public long[] getCurrentRateBytesPerSecond() {
        long[] result = new long[this.STAT_ENTRY_COUNT];
        int i = 0;
        while (i < this.STAT_ENTRY_COUNT) {
            result[i] = (long)(this.stat_averages[i].getAverage() / 60.0);
            ++i;
        }
        return result;
    }

    @Override
    public void addListener(long min_delta_bytes, final LongTermStatsListener listener) {
        this.listeners.add(new Object[]{listener, min_delta_bytes, this.session_total});
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                listener.updated(LongTermStatsGenericImpl.this);
            }
        });
    }

    @Override
    public void removeListener(LongTermStatsListener listener) {
        for (Object[] entry : this.listeners) {
            if (entry[0] != listener) continue;
            this.listeners.remove(entry);
            break;
        }
    }

    private class DayCache {
        private String year;
        private String month;
        private String day;
        private Map<Long, long[]> contents = new HashMap<Long, long[]>();

        private DayCache(String _year, String _month, String _day) {
            this.year = _year;
            this.month = _month;
            this.day = _day;
        }

        private boolean isForDay(String _year, String _month, String _day) {
            return this.year.equals(_year) && this.month.equals(_month) && this.day.equals(_day);
        }

        private void addRecord(long offset, long[] stats) {
            for (Map.Entry<Long, long[]> entry : this.contents.entrySet()) {
                if (offset < entry.getKey()) continue;
                long[] old = entry.getValue();
                int i = 0;
                while (i < old.length) {
                    int n = i;
                    old[n] = old[n] + stats[i];
                    ++i;
                }
            }
        }

        private long[] getTotals(long offset) {
            return this.contents.get(offset);
        }

        private void setTotals(long offset, long[] value) {
            this.contents.put(offset, value);
        }
    }

    private class MonthCache {
        private String year;
        private String month;
        private boolean dirty;
        private Map<String, List<Long>> contents;

        private MonthCache(String _year, String _month) {
            this.year = _year;
            this.month = _month;
        }

        private File getCacheFile() {
            return new File(LongTermStatsGenericImpl.this.stats_dir, String.valueOf(this.year) + File.separator + this.month + File.separator + "cache.dat");
        }

        private boolean isForMonth(String _year, String _month) {
            return this.year.equals(_year) && this.month.equals(_month);
        }

        private Map<String, List<Long>> getContents() {
            if (this.contents == null) {
                File file = this.getCacheFile();
                this.contents = file.exists() ? FileUtil.readResilientFile(file) : new HashMap<String, List<Long>>();
            }
            return this.contents;
        }

        private long[] getTotals(int day) {
            List<Long> records = this.getContents().get(String.valueOf(day));
            if (records != null) {
                long[] result = new long[LongTermStatsGenericImpl.this.STAT_ENTRY_COUNT];
                if (records.size() == LongTermStatsGenericImpl.this.STAT_ENTRY_COUNT) {
                    int i = 0;
                    while (i < LongTermStatsGenericImpl.this.STAT_ENTRY_COUNT) {
                        result[i] = records.get(i);
                        ++i;
                    }
                }
                return result;
            }
            return null;
        }

        private long[] getTotals(int day, long start_offset) {
            if (start_offset == 0L) {
                return this.getTotals(day);
            }
            List<Long> records = this.getContents().get(String.valueOf(day) + "." + start_offset);
            if (records != null) {
                long[] result = new long[LongTermStatsGenericImpl.this.STAT_ENTRY_COUNT];
                if (records.size() == LongTermStatsGenericImpl.this.STAT_ENTRY_COUNT) {
                    int i = 0;
                    while (i < LongTermStatsGenericImpl.this.STAT_ENTRY_COUNT) {
                        result[i] = records.get(i);
                        ++i;
                    }
                }
                return result;
            }
            return null;
        }

        private void setTotals(int day, long[] totals) {
            ArrayList<Long> records = new ArrayList<Long>();
            long[] lArray = totals;
            int n = totals.length;
            int n2 = 0;
            while (n2 < n) {
                Long l = lArray[n2];
                records.add(l);
                ++n2;
            }
            this.getContents().put(String.valueOf(day), records);
            this.dirty = true;
        }

        private void setTotals(int day, long start_offset, long[] totals) {
            if (start_offset == 0L) {
                this.setTotals(day, totals);
            } else {
                ArrayList<Long> records = new ArrayList<Long>();
                long[] lArray = totals;
                int n = totals.length;
                int n2 = 0;
                while (n2 < n) {
                    Long l = lArray[n2];
                    records.add(l);
                    ++n2;
                }
                this.getContents().put(String.valueOf(day) + "." + start_offset, records);
                this.dirty = true;
            }
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void save() {
            File file = this.getCacheFile();
            file.getParentFile().mkdirs();
            FileUtil.writeResilientFile(file, this.contents);
            this.dirty = false;
        }
    }
}

