/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class LocaleTorrentUtil {
    private static List listeners = new ArrayList();

    public static LocaleUtilDecoder getTorrentEncodingIfAvailable(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        String canonical_name;
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if (encoding == null) {
            return null;
        }
        if ("utf8 keys".equals(encoding)) {
            encoding = "utf8";
        }
        try {
            canonical_name = Charset.forName(encoding).name();
        }
        catch (Throwable e) {
            canonical_name = encoding;
        }
        LocaleUtilDecoder chosenDecoder = null;
        LocaleUtilDecoder[] all_decoders = LocaleUtil.getSingleton().getDecoders();
        int i = 0;
        while (i < all_decoders.length) {
            if (all_decoders[i].getName().equals(canonical_name)) {
                chosenDecoder = all_decoders[i];
                break;
            }
            ++i;
        }
        return chosenDecoder;
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        return LocaleTorrentUtil.getTorrentEncoding(torrent, true);
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent, boolean saveToFileAllowed) throws TOTorrentException, UnsupportedEncodingException {
        boolean bSaveToFile;
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if ("utf8 keys".equals(encoding)) {
            encoding = "utf8";
        }
        try {
            TorrentUtils.getTorrentFileName(torrent);
            bSaveToFile = true;
        }
        catch (Throwable e) {
            bSaveToFile = false;
        }
        if (encoding != null) {
            try {
                LocaleUtilDecoder[] all_decoders = LocaleUtil.getSingleton().getDecoders();
                LocaleUtilDecoder fallback_decoder = LocaleUtil.getSingleton().getFallBackDecoder();
                String canonical_name = encoding.equals(fallback_decoder.getName()) ? encoding : Charset.forName(encoding).name();
                int i = 0;
                while (i < all_decoders.length) {
                    if (all_decoders[i].getName().equals(canonical_name)) {
                        return all_decoders[i];
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        LocaleUtilDecoderCandidate[] candidates = LocaleTorrentUtil.getTorrentCandidates(torrent);
        boolean system_decoder_is_valid = false;
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        LocaleUtilDecoder system_decoder = localeUtil.getSystemDecoder();
        int i = 0;
        while (i < candidates.length) {
            if (candidates[i].getDecoder() == system_decoder) {
                system_decoder_is_valid = true;
                break;
            }
            ++i;
        }
        LocaleUtilDecoder selected_decoder = null;
        int i2 = 0;
        while (i2 < listeners.size()) {
            try {
                LocaleUtilDecoderCandidate candidate = ((LocaleUtilListener)listeners.get(i2)).selectDecoder(localeUtil, torrent, candidates);
                if (candidate != null) {
                    selected_decoder = candidate.getDecoder();
                    break;
                }
            }
            catch (Throwable candidate) {
                // empty catch block
            }
            ++i2;
        }
        if (selected_decoder == null) {
            bSaveToFile = false;
            int min_length = Integer.MAX_VALUE;
            int utf8_length = Integer.MAX_VALUE;
            LocaleUtilDecoderCandidate utf8_decoder = null;
            LocaleUtilDecoderCandidate[] localeUtilDecoderCandidateArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                LocaleUtilDecoderCandidate candidate = localeUtilDecoderCandidateArray[n2];
                String val = candidate.getValue();
                if (val != null) {
                    String name;
                    int len = val.length();
                    if (len < min_length) {
                        min_length = len;
                    }
                    if ((name = candidate.getDecoder().getName().toUpperCase(Locale.US)).equals("UTF-8") || name.equals("UTF8")) {
                        utf8_length = len;
                        utf8_decoder = candidate;
                    }
                }
                ++n2;
            }
            selected_decoder = utf8_decoder != null && utf8_length == min_length ? utf8_decoder.getDecoder() : (system_decoder_is_valid ? localeUtil.getSystemDecoder() : localeUtil.getFallBackDecoder());
        }
        torrent.setAdditionalStringProperty("encoding", selected_decoder.getName());
        if (bSaveToFile && saveToFileAllowed) {
            TorrentUtils.writeToFile(torrent);
        }
        return selected_decoder;
    }

    protected static LocaleUtilDecoderCandidate[] getTorrentCandidates(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        byte[] created;
        HashSet cand_set = new HashSet();
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        List candidateDecoders = localeUtil.getCandidateDecoders(torrent.getName());
        long lMinCandidates = candidateDecoders.size();
        byte[] minCandidatesArray = torrent.getName();
        cand_set.addAll(candidateDecoders);
        TOTorrentFile[] files = torrent.getFiles();
        int i = 0;
        while (i < files.length) {
            TOTorrentFile file = files[i];
            byte[][] comps = file.getPathComponents();
            int j = 0;
            while (j < comps.length) {
                candidateDecoders = localeUtil.getCandidateDecoders(comps[j]);
                if ((long)candidateDecoders.size() < lMinCandidates) {
                    lMinCandidates = candidateDecoders.size();
                    minCandidatesArray = comps[j];
                }
                cand_set.retainAll(candidateDecoders);
                ++j;
            }
            ++i;
        }
        byte[] comment = torrent.getComment();
        if (comment != null) {
            candidateDecoders = localeUtil.getCandidateDecoders(comment);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = comment;
            }
            cand_set.retainAll(candidateDecoders);
        }
        if ((created = torrent.getCreatedBy()) != null) {
            candidateDecoders = localeUtil.getCandidateDecoders(created);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = created;
            }
            cand_set.retainAll(candidateDecoders);
        }
        List candidatesList = localeUtil.getCandidatesAsList(minCandidatesArray);
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[candidatesList.size()];
        candidatesList.toArray(candidates);
        Arrays.sort(candidates, new Comparator(){

            public int compare(Object o1, Object o2) {
                LocaleUtilDecoderCandidate luc1 = (LocaleUtilDecoderCandidate)o1;
                LocaleUtilDecoderCandidate luc2 = (LocaleUtilDecoderCandidate)o2;
                LocaleUtilDecoder dec1 = luc1.getDecoder();
                LocaleUtilDecoder dec2 = luc2.getDecoder();
                int res = dec1.getIndex() - dec2.getIndex();
                if (res == 0) {
                    return 0;
                }
                String n1 = dec1.getName();
                String n2 = dec2.getName();
                if (n1.equals("UTF-8")) {
                    return -1;
                }
                if (n2.equals("UTF-8")) {
                    return 1;
                }
                return res;
            }
        });
        return candidates;
    }

    public static void setTorrentEncoding(TOTorrent torrent, String encoding) throws LocaleUtilEncodingException {
        try {
            String canonical_requested_name;
            LocaleUtil localeUtil = LocaleUtil.getSingleton();
            LocaleUtilDecoderCandidate[] candidates = LocaleTorrentUtil.getTorrentCandidates(torrent);
            if (encoding.equalsIgnoreCase("system")) {
                canonical_requested_name = localeUtil.getSystemEncoding();
            } else if (encoding.equalsIgnoreCase(LocaleUtilDecoderFallback.NAME)) {
                canonical_requested_name = LocaleUtilDecoderFallback.NAME;
            } else {
                CharsetDecoder requested_decoder = Charset.forName(encoding).newDecoder();
                canonical_requested_name = requested_decoder.charset().name();
            }
            boolean ok = false;
            int i = 0;
            while (i < candidates.length) {
                if (candidates[i].getDecoder().getName().equals(canonical_requested_name)) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                String[] charsets = new String[candidates.length];
                String[] names = new String[candidates.length];
                int i2 = 0;
                while (i2 < candidates.length) {
                    LocaleUtilDecoder decoder = candidates[i2].getDecoder();
                    charsets[i2] = decoder.getName();
                    names[i2] = decoder.decodeString(torrent.getName());
                    ++i2;
                }
                throw new LocaleUtilEncodingException(charsets, names);
            }
            torrent.setAdditionalStringProperty("encoding", canonical_requested_name);
        }
        catch (Throwable e) {
            if (e instanceof LocaleUtilEncodingException) {
                throw (LocaleUtilEncodingException)e;
            }
            throw new LocaleUtilEncodingException(e);
        }
    }

    public static void setDefaultTorrentEncoding(TOTorrent torrent) throws LocaleUtilEncodingException {
        LocaleTorrentUtil.setTorrentEncoding(torrent, "UTF8");
    }

    public static String getCurrentTorrentEncoding(TOTorrent torrent) {
        return torrent.getAdditionalStringProperty("encoding");
    }

    public static void addListener(LocaleUtilListener l) {
        listeners.add(l);
    }

    public static void removeListener(LocaleUtilListener l) {
        listeners.remove(l);
    }
}

